#!/usr/bin/perl
#  uncleared-txn.pl - Prints a report of the uncleared transactions sorted 
#                     by date
#
#  Written by Kevin L. McWhirter (klmcw@crl.com).  Started May 18, 1997
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: uncleared-txn.pl,v 1.1.1.1 1999/12/18 02:07:11 curt Exp $


package CBB;

use strict;    # don't take no guff


my($cbb_incl_dir, $temp);
my($account, @account_list, $name, $key, $trans, %ALLTRANS);
my($firstdate, $lastdate);
my($firstday, $firstmon, $firstyear, $lastday, $lastmon, $lastyear);
my($totalmonths);
my($junk, $result);
my($date_fmt, $date, $todate, $fromdate);

# specify the installed location of the necessary pieces.
BEGIN{
$CBB::cbb_incl_dir = "..";
unshift(@INC, $CBB::cbb_incl_dir);
}

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

($date_fmt, $fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $trans) = split(/\t/, $result, 2);
        my($date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
	   $junk) = split(/\t/, $trans, 9);

	if ( ($firstdate eq "") || ($date < $firstdate) ) {
	    $firstdate = $date;
	}

	if ( ($lastdate eq "") || ($date > $lastdate) ) {
	    $lastdate = $date;
	}

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) &&
	    ($cleared ne "x") ) {
	    $ALLTRANS{"$key$name"} = $trans;
        }

        $result = &next_trans();
    }
}

# determine number of months in range
if (($fromdate != 0) && ($fromdate > $firstdate)) {
    $firstdate = $fromdate;
}
if (($todate != 0) && ($todate < $lastdate)) {
    $lastdate = $todate;
}
($firstyear,$firstmon,$firstday) = $firstdate =~ /(\d\d\d\d)(\d\d)(\d\d)/;
($lastyear,$lastmon,$lastday) = $lastdate =~ /(\d\d\d\d)(\d\d)(\d\d)/;

$totalmonths = ($lastyear - $firstyear) * 12;
$totalmonths += ($lastmon - $firstmon);
$totalmonths++;

if ( $date_fmt == 1 ) {
    print "Uncleared Transactions for $firstmon/$firstday/$firstyear".
	" to $lastmon/$lastday/$lastyear.\n";
} else {
    print "Uncleared Transactions for $firstday.$firstmon.$firstyear".
	" to $lastday.$lastmon.$lastyear.\n";
}
print "    (Range is $totalmonths months.)\n";
print "\n";

# sort and print
foreach $key (sort (keys %ALLTRANS) ) {
    # print $ALLTRANS{$key} . "\n";
    &format_line("$ALLTRANS{$key}");
}


sub format_line {
    my($date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/\t/, $_[0]);
    my($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    my($nicedate, $cutdesc, $cutcom, $nicecat);

    $year = substr($year, 2, 4);

    if ( $date_fmt == 1 ) {
	$nicedate = "$mon/$day/$year";
    } else {
	$nicedate = "$day.$mon.$year";
    }
    $cutdesc = substr($desc, 0, 15);
    $cutcom = substr($com, 0, 15);
    $nicecat = substr($cat, 0, 9);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

    printf("%5s  %-8s  %-15s  %9.2f  %9.2f  %-1s  %9.2f\n",
          $check, $nicedate, $cutdesc, $debit, $credit, $cleared, $total);
    printf("%5s  %-8s  %-15s  %-9s\n\n", "", "", $cutcom, $nicecat);
}
