.TH SAMPLE1D l "1 November 1999"
.SH NAME
sample1d \- Resampling of 1-D data sets
.SH SYNOPSIS
\fBsample1d\fP \fIinfile\fP [ \fB\-Fl|a|c\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP\fIxinc\fP ] 
[ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP\fIknotfile\fP ] [ \fB\-S\fP\fIxstart\fP ] [ \fB\-T\fP\fIx-col\fP] 
[ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBsample1d\fP reads a multi-column ASCII [or binary] data set from file [or standard input] and resamples the
timeseries/profile at locations where the user needs the values.  The user must provide
the column number of the independent (monotonically increasing \fBor\fP decreasing) variable.  Equidistant or arbitrary sampling can
be selected.  All columns are resampled based on the new sampling interval.
Several interpolation schemes are available.
.TP
\fIinfile\fP
This is a multi-column ASCII [of binary, see \fB\-b\fP] file with one column containing the independent variable (which must
be monotonically in/de-creasing) and the remaining columns holding misc. data values.
If no file is provided, sample1d reads from standard input.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-F
Choose from \fBl\fP (Linear), \fBa\fP (Akima spline), and \fBc\fP (natural cubic spline) [Default is \fB\-Fa\fP].
You may change the default interpolant; see INTERPOLANT in your .gmtdefaults file.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
\fIxinc\fP defines the sampling interval. [Default is the separation between the first and
second abcissa point in the \fIinfile\fP]
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
\fIknotfile\fP is an optional ASCII file with the x locations where the data set will be resampled in the first column
.TP
.B \-S
For equidistant sampling, \fIxstart\fP indicates the location of the first output value. [Default
is the smallest even multiple of \fIxinc\fP inside the range of \fIinfile\fP]
.TP
.B \-T
Sets the column number of the independent variable [Default is 0 (first)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 2 (or at least the number of columns implied by \fB\-T\fP].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
.SH EXAMPLES
To resample the file profiles.tdgmb, which contains (time,distance,gravity,magnetics,bathymetry) records,
at 1km equidistant intervals using Akima's spline, try
.br
.sp
sample1d profiles.tdgmb \fB\-I\fP1 \fB\-Fa\fP \fB\-T\fP1 > profiles_equi_d.tdgmb
.br
.sp
To resample the file depths.dt at positions listed in the file grav_pos.dg, using a cubic spline
for the interpolation, try
.br
.sp
sample1d depths.dt \fB\-N\fPgrav_pos.dg \fB\-Fc\fP > new_depths.dt
.SH "SEE ALSO"
.IR gmt (l),
.IR filter1d (l)
