/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#ifndef __DEBUG_H__
#define __DEBUG_H__

#define BS_BUFFLEN 1024

#ifndef BS_DEBUG_FILE
#define BS_DEBUG_FILE stderr
#endif /* BS_DEBUG_FILE */

void bs_printf(unsigned level, char *format, ...);

#ifdef DEBUG

/*#include <glib.h>*/

extern unsigned debug_level;

#define bs_function_enter() if (debug_level >= 1)                                       \
			      fprintf(BS_DEBUG_FILE, "entering function %s, file %s\n", \
				       __PRETTY_FUNCTION__,                             \
				       __FILE__)

#define bs_function_leave() if (debug_level >= 1)                                       \
			      fprintf(BS_DEBUG_FILE, "leaving function %s, file %s\n",  \
				       __PRETTY_FUNCTION__,                             \
				       __FILE__)

#define BS_DEBUG(l,m) if (debug_level >= l) \
		       fprintf(BS_DEBUG_FILE, "%s"m, (l==3 ? "" : \
			    (l==2 ? "\t" : (l==1 ? "\t\t":""))))

#define BS_DEBUG_STR(l,m) if (debug_level >= l) \
		       fprintf(BS_DEBUG_FILE, "%s%s", m, (l==3 ? "" : \
			    (l==2 ? "\t" : (l==1 ? "\t\t":""))))

#define BS_DEBUG_NUM(l,d) if (debug_level >= l) \
		       fprintf(BS_DEBUG_FILE, "%d%s", d, (l==3 ? "" : \
			    (l==2 ? "\t" : (l==1 ? "\t\t":""))))



#else
#define bs_function_enter()
#define bs_function_leave()
#define BS_DEBUG(l,m)
#define BS_DEBUG_STR(l,m)
#define BS_DEBUG_NUM(l,d)

#endif /* DEBUG */

#endif /* __DEBUG_H__ */
