/* Gnome Darxite common code
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

/*Includes*/
#include <gnome.h>

#include "dnd.h"
#include "daemon.h"
#include "connect.h"

#include <dirent.h>
#include <unistd.h>
#include "callbacks.h"

/* Local variables, mostly widgets :) */

typedef struct _DownloadTab DownloadTab;

struct _DownloadTab
{
	GtkWidget *url_label;
	GtkWidget *url_entry;
	
	GtkWidget *button_p;

	GtkWidget *paned;

	GtkWidget *dir_clist;
	GtkWidget *file_clist;
	GtkWidget *dir_label;
	GtkWidget *dir_label2;
	GtkWidget *filename_entry;
	
	GtkWidget *check_p;
	GtkWidget *check_r;
	GtkWidget *check_s;
	GtkWidget *check_m;
	GtkWidget *check_md;
};

typedef struct
{
	gchar *url;
	gchar *dir;
	gchar *file;
	gchar *flags;
}TDownload;

DownloadTab *Dtab = NULL;

GtkWidget *buttonbox;
GtkWidget *button;
GtkWidget *separator;
GtkWidget *frame;
GtkWidget *alignment;

GtkWidget *scroll;

gchar aux_flags[LAST_FLAG]; /* p,r,s,m,b I think... */

char SourceURL[256];
char TargetFile[256];

/*FIXME: This must die*/
int files;

void build_window();
gchar * change_prefix(gchar *url);
gint validate_download(TDownload *download);

static void reget_file(GtkWidget *widget, TDownload *download);
static void overwrite_file(GtkWidget *widget, TDownload *download);

/*FIXME: This 4 must die*/
void toggle_p(GtkWidget * widget, gpointer data);
void toggle_r(GtkWidget * widget, gpointer data);
void toggle_s(GtkWidget * widget, gpointer data);
void toggle_m(GtkWidget * widget, gpointer data);

int add_to_batch(TDownload *download);
void change_dir(GtkWidget *clist, gint row, gint column,
		GdkEventButton *event, gpointer data);
static void create_dir(GtkWidget *widget, gpointer data);
static void remove_files(GtkWidget *widget, gpointer data);
static void ok_button_click(GtkWidget *widget, gpointer data);
void change_filename(GtkWidget *clist, gint row, gint column,
   		GdkEventButton *event, gpointer data);
void close_main_window(GtkWidget *widget, gpointer data);
void paste(GtkWidget *widget, gpointer data);

void LocalLs(void);

void pop_window(TabType tab);

void set_download_flags();
void set_widgets_sensitive();

/****************************************************************************/
void
drag_data_received (GtkWidget *Pwidget, GdkDragContext *context,
   		   gint x, gint y, GtkSelectionData *selection_data,
                   guint info, guint time, gpointer data)
{
     	GList *names;
        gchar *filename;
        gchar *url;

        if (!connected)
	{
	   /* The behaviour has been modified: now the applet won't
	    * warn the user, instead it will start the daemon and
	    * will connect to it, if failed, show the warning.
	    */
	   /*show_warning(NULL);
	   return;*/
	   start_stop_daemon_cb();
	   if (!connected)
	   {
	      show_warning();
	      return;
	   }
	}
	
/*FIXME: this should not be needed!*/
	if (!DND)
	{
g_print("%s", "FATAL ERROR: !DND == TRUE !!!");
	   DND = g_malloc(sizeof(DndWindow));
	   DND->window = NULL;
	}

	/*Use Default Flags?*/
	if (use_flags)
	{
	   if (DX_EnableMirrors)
	      flags[mirrored] = 'm';
	   else 
	      flags[mirrored] = 'M';
	   if (DX_EnableSpooling)
	      flags[spooled] = 's';
	   else
	      flags[spooled] = 'S';
	   if (DX_EnableRenaming)
	      flags[renamed] = 'r';
	   else
	      flags[renamed] = 'R';
	}

	/*Use Default Dir?*/
	if (use_outputdir)
	   sprintf(TargetDir, "%s/", DX_OutputDir);


      	if (show_dialog || (y == -1 && x == -1))
        {
           if (DND->window)
           {
	      gtk_widget_show(DND->window);
/*FIXME: This is currently a BUG, This needs a rework, window should not
dissapear, it should save the size, etc...*/
//	      gtk_widget_unref(DND->window);
              /* raise it */
              gdk_window_raise(GTK_WIDGET(DND->window)->window);
/*FIXME!!!!!: if the window is in another desktop it will seem that nothing
		happens when you drop the url into darxapp*/

	      set_download_flags();
           }
           else
           {
              /* build it*/           
	      build_window();
           }

           chdir(TargetDir);
	   change_dir(NULL, 1, 1, NULL, NULL);

	   set_widgets_sensitive();

           switch (info)
           {
           case TARGET_URI_LIST:
		names = gnome_uri_list_extract_filenames \
			((char *)selection_data->data);
                if (g_list_length(names) == 1)
                {
		   url = change_prefix((char *)names->data);

                   gtk_entry_set_text(GTK_ENTRY(Dtab->url_entry), url);
                   sprintf(TargetFile, "%s", strrchr(url,'/')+1);
                   gtk_entry_set_text(GTK_ENTRY(Dtab->filename_entry), TargetFile);
                   gtk_label_set(GTK_LABEL(Dtab->dir_label2), TargetDir);
                   files = 1;
                   LocalLs();
                }
                else
                {
            	   gtk_widget_set_sensitive(Dtab->url_label, FALSE);
             	   gtk_widget_set_sensitive(Dtab->url_entry, FALSE);
	      	   gtk_widget_set_sensitive(Dtab->filename_entry, FALSE);
              	   gtk_widget_set_sensitive(Dtab->button_p, FALSE);
                   gtk_entry_set_text(GTK_ENTRY(Dtab->filename_entry), "Multiple files");
                   gtk_clist_clear(GTK_CLIST(Dtab->file_clist));
                   while (names)
	           {
		      url = change_prefix((char *)names->data);
                      gtk_clist_append(GTK_CLIST(Dtab->file_clist), &url);
	              names = names->next;
	           }
                   strcpy(TargetFile, "");
/*                   sprintf(TargetPath, "%s/%s", TargetDir, TargetFile);
*/
                   gtk_label_set(GTK_LABEL(Dtab->dir_label2), TargetDir);
                   files = 0;
                   LocalLs();
                }
                gnome_uri_list_free_strings (names);
                break;

           case TARGET_NETSCAPE_URL:
              	if (selection_data != NULL)
                {
              	   filename = (char *)selection_data->data;
                   gtk_entry_set_text(GTK_ENTRY(Dtab->url_entry), filename);
                   sprintf(TargetFile, "%s", strrchr(filename,'/')+1);
		   gtk_entry_set_text(GTK_ENTRY(Dtab->filename_entry), TargetFile);
                }
                else
                {
                 /*if (only_raise) break;*/
                   strcpy(TargetFile,"");
                   if (use_clipboard)
                      paste(NULL,NULL);
                   else
                      gtk_entry_set_text(GTK_ENTRY(Dtab->url_entry), "");
                }
/*                sprintf(TargetPath, "%s/%s", TargetDir, TargetFile);
*/
                gtk_label_set(GTK_LABEL(Dtab->dir_label2), TargetDir);
                files = 1;
                LocalLs();
                break;
           }
        }
/*-----------------*/
        else
        {
	   TDownload *download;
           /* download directamente */
	   if (not_paused)
	      flags[paused] = 'P';
             
           switch (info)
           {
           case TARGET_URI_LIST:
		names = gnome_uri_list_extract_filenames
				((char *)selection_data->data);
	        while (names)
	        {
		   download = g_malloc(sizeof(TDownload));

		   download->url = change_prefix((char *)names->data);
		   download->dir = TargetDir;
		   sprintf(TargetFile, "%s", strrchr(download->url,'/')+1);
		   download->file = TargetFile;
		   download->flags = strdup(flags);
		   validate_download(download);

	           names = names->next;
	        }
                gnome_uri_list_free_strings (names);
                break;

           case TARGET_NETSCAPE_URL:
		download = g_malloc(sizeof(TDownload));

              	download->url = strdup((char *)selection_data->data),
		download->dir = TargetDir;
		sprintf(TargetFile, "%s", strrchr(download->url,'/')+1);
		download->file = TargetFile;
		download->flags = strdup(flags);
		validate_download(download);
/*FIXME: Should g_free(download) here?*/
                break;
           }
        }
	if ((show_flash) && (y != -1))
	{
	   flash_logo();
	   g_print("flash_logo()\n");
	}
}
/****************************************************************************/

gchar *
change_prefix(gchar *url)
{
	gchar buffer[256];
	gchar *filename;

	if (strncasecmp(url, "/#ftp:", 6) == 0)
	{
	   sprintf(buffer, "ftp://%s", url+6);
        }
	else
	   if (strncasecmp(url, "/#http:", 7) == 0)
	   {
	      sprintf(buffer, "http://%s", url+7);
	   }
	   else sprintf(buffer, url); /*FIXME: Not very efficient*/
	filename = strdup(buffer);
return filename;
}

gint
validate_download(TDownload *download)
{
	GtkWidget *message_box;
	gchar buffer[512];
	gchar buffer2[512];

	if (  (strncasecmp(download->url, "ftp://", 6) == 0)
	   || (strncasecmp(download->url, "http://", 7) == 0)
	   || (strncasecmp(download->url, "file://", 7) == 0)
	   )
	{
	   sprintf(buffer, "%s%s", download->dir, download->file);
	   sprintf(buffer2, "%s.darxite", buffer);
/*FIXME: g_print buffer2 to see if it's correct*/
	   if ((use_resume) ||
	       ((open(buffer, O_RDONLY) == -1) && (open(buffer2, O_RDONLY) == -1)))
	   {
	      add_to_batch(download);
	   }
	   else
	   {
	      sprintf(buffer, _("File already exists:\n%s%s\n\n(%s)"),
			download->dir, download->file, download->url);
	      message_box = gnome_message_box_new(buffer,
			GNOME_MESSAGE_BOX_WARNING, "Overwrite", "Continue",
			GNOME_STOCK_BUTTON_CANCEL,NULL);
	      gnome_dialog_button_connect((GnomeDialog *)message_box,
			0, GTK_SIGNAL_FUNC (overwrite_file), download);
	      gnome_dialog_button_connect((GnomeDialog *)message_box,
			1, GTK_SIGNAL_FUNC (reget_file), download);
/*FIXME: poner Reget como default*/
	      gtk_widget_show(message_box);
	   
}
	   return 1;
	}
	else
	{
	   sprintf(buffer, _("Invalid Source URL:\n%s"), download->url);
	   show_warning(buffer);
	   return 0;
	}
}

void pop_window(TabType tab)
{
	/*It calls drag_data_received with no data :)*/
        drag_data_received (NULL, NULL, -1, -1, NULL,
              	TARGET_NETSCAPE_URL, 0, NULL);
	gtk_notebook_set_page((GtkNotebook *)(DND->notebook), tab);
}

void pop_window_d()
{
	pop_window(DOWNLOAD_TAB);
}

void pop_window_u()
{
	pop_window(UPLOAD_TAB);
}

void pop_window_a()
{
	pop_window(ADVANCED_TAB);
}

int add_to_batch(TDownload *download)
{
   	gint rc;
        char buffer[2048];
        gint timeout = 10;

        sprintf(buffer, "Get %s | %s%s | | | %s \n", download->url,
           	download->dir, download->file, download->flags);
	#ifdef DEBUG_MESSAGES
        g_print(buffer);
	#endif
        write(fd, buffer, strlen(buffer));

/*FIXME: HAY QUE COMPROVAR QUE SE HA HECHO BIEN!!!!!*/
        rc = DX_GetResponse(fd, buffer, sizeof(buffer) - 1, timeout);

	#ifdef DEBUG_MESSAGES
	g_print("DX_GetResponse: rc = %i\n", rc);
        g_print(buffer);
	#endif

        if (rc == DX_LIB_OK)
        {
           return 1;
        }
/*FIXME: DX_LIB_TIMEOUT -> show some warning ? ! ... here?, or the function that calls this one??*/
        else
	{
	   return 0;
	}
/*FIXME: FIX ABOVE FIXME: the warning should be shown here!*/

}

void destroy_window(DndWindow *window)
{
//   	gtk_widget_destroy(GTK_WIDGET(window->notebook));
//   	gtk_widget_destroy(GTK_WIDGET(window->window));
//   	window->window = NULL;
//   	g_free(Dtab);
	gtk_widget_ref(window->window);
	gtk_widget_hide(window->window);
}

void
close_main_window(GtkWidget *widget, gpointer data)
{
/*FIXME: ONLY DO THIS ON APP EXIT!!

ON APP EXIT WE SHOULD UNREF THE WINDOW!!!*/
	destroy_window(DND);
}

void
create_dir_cb(gchar *string, gpointer data)
{
	if (string != NULL)
	{
	   if (mkdir(string, 0755) == -1)
	      show_warning("Error creating directory.");
	   else
	      LocalLs();
	}
}

static void
create_dir(GtkWidget *widget, gpointer data)
{
	GtkWidget *dialog;

	dialog = gnome_request_dialog(FALSE, "Enter directory name:",
			NULL, 256, GTK_SIGNAL_FUNC(create_dir_cb),
			NULL, GTK_WINDOW(DND->window));
	gtk_widget_show(dialog);
}


static void
reget_file(GtkWidget *widget, TDownload *download)
{
	add_to_batch(download);
}

static void
overwrite_file(GtkWidget *widget, TDownload *download)
{
/*	gchar buffer[LAST_FLAG];
	sprintf(buffer, flags);*/

/*FIME: I must use a global variable for aux_flags, if not the program will
	receive a sigsegv signal when exiting this function (after gtk_marshall)*/
	sprintf(aux_flags, download->flags);
	aux_flags[overwrite] = 'b'; /*Reget the file from the begining*/
	download->flags = strdup(aux_flags);

	add_to_batch(download);
}

static void
delete_file(gint reply, gchar *data)
{
	if (reply == 0)
	{
	   if (remove(data) == -1)
	      show_warning("Error deleting file.");
	   else
	      LocalLs();
	}
}

static void
remove_files(GtkWidget *widget, gpointer data)
{
   	GList *selected = GTK_CLIST(data)->selection;
        gint row_number;

	if (files && selected)
	{
	GtkWidget *window2;

	gchar *filename;
	char message[256];

        row_number = (int)selected->data;
        gtk_clist_get_text(GTK_CLIST(data), row_number, 0, &filename);

	sprintf(message, "Really delete filename:\n\n%s", filename);	

	window2 = gnome_question_dialog_parented(message,
			GTK_SIGNAL_FUNC(delete_file), filename,
			GTK_WINDOW(DND->window));

        gtk_widget_show(window2);
	}
	else
	{
        while (selected)
           {
           row_number = (int)selected->data;
           selected = selected->next;
           gtk_clist_remove(GTK_CLIST(data), row_number);
           }
	}
}

static void
ok_button_click(GtkWidget *widget, gpointer data)
{
        gchar *source_url;
        gint row;
	TDownload *download;
        
        if (!connected)
	   {
	   show_warning(NULL);
	   return;
	   }

        if (files)
        {
	   download = g_malloc(sizeof(TDownload));

           download->url = strdup(gtk_entry_get_text(GTK_ENTRY(Dtab->url_entry)));
           if (strlen(download->url) != 0)
           {
              download->file = strdup(gtk_entry_get_text(GTK_ENTRY(Dtab->filename_entry)));
              if (strlen(download->file) == 0)
	      {
		 sprintf(TargetFile, "%s", strrchr(download->url,'/')+1);
		 download->file = strdup(TargetFile);
	      gtk_entry_set_text(GTK_ENTRY(Dtab->filename_entry), download->file);
	      }
	      download->dir = strdup(TargetDir);
	      download->flags = strdup(flags);

	      if (validate_download(download))
	      {
	         destroy_window(DND);
	      }
           }
           else
           {
	      destroy_window(DND);
           }
        }
        else
        {
   	   row = 0;
           while (row < GTK_CLIST(data)->rows)
           {
	      download = g_malloc(sizeof(TDownload));

              gtk_clist_get_text(GTK_CLIST(data), row, 0, &source_url);
	      download->url = strdup(source_url);
	      download->dir = strdup(TargetDir);
	      sprintf(TargetFile, "%s", strrchr(download->url,'/')+1);
	      download->file = strdup(TargetFile);
	      download->flags = strdup(flags);

	      if (validate_download(download))
		 gtk_clist_remove(GTK_CLIST(data), row);
	      else
	         row += 1;
           }
           if ((GTK_CLIST(data)->rows) == 0)
           {
	      destroy_window(DND);
           }
        }
}

static int one(struct dirent *unused)
{
    return 1;
}

void LocalLs(void)
{
    struct dirent **eps;
    struct stat stat_buf;
    int n, cnt;
    gchar *name;
    
    gtk_clist_clear(GTK_CLIST(Dtab->dir_clist));
    gtk_clist_freeze(GTK_CLIST(Dtab->dir_clist));
    if (files)
    {
       gtk_clist_freeze(GTK_CLIST(Dtab->file_clist));
       gtk_clist_clear(GTK_CLIST(Dtab->file_clist));
    }
    n = scandir ("./", &eps, one, alphasort);
    if (n >= 0)
    {
        name = "./";
        gtk_clist_append(GTK_CLIST(Dtab->dir_clist), &name);
        name = "../";
        gtk_clist_append(GTK_CLIST(Dtab->dir_clist), &name);
      	
        for (cnt = 0; cnt < n; cnt++)
        {
           name = eps[cnt]->d_name;
           stat(eps[cnt]->d_name, &stat_buf);
           if (S_ISDIR(stat_buf.st_mode))
           {
              if (*name != '.')
              {
                 strcat(name, "/");
                 gtk_clist_append(GTK_CLIST(Dtab->dir_clist), &name);
              }
           }
           else
           {
              if (S_ISREG(stat_buf.st_mode) && files)
              {
		 if (*name != '.')
                    gtk_clist_append(GTK_CLIST(Dtab->file_clist), &name);
              }
           }
        }
    }
    gtk_clist_thaw(GTK_CLIST(Dtab->dir_clist));
    if (files) gtk_clist_thaw(GTK_CLIST(Dtab->file_clist));
    free(*eps);
}

void toggle_p(GtkWidget * widget, gpointer data)
{
   	if (GTK_TOGGLE_BUTTON(widget)->active)
           flags[paused] = 'p';
        else
           flags[paused] = 'P';
}

void toggle_r(GtkWidget * widget, gpointer data)
{
   	if (GTK_TOGGLE_BUTTON(widget)->active)
           flags[renamed] = 'r';
        else
           flags[renamed] = 'R';
}

void toggle_s(GtkWidget * widget, gpointer data)
{
   	if (GTK_TOGGLE_BUTTON(widget)->active)
           flags[spooled] = 's';
        else
           flags[spooled] = 'S';
}

void toggle_m(GtkWidget * widget, gpointer data)
{
   	if (GTK_TOGGLE_BUTTON(widget)->active)
           flags[mirrored] = 'm';
        else
           flags[mirrored] = 'M';
}

void change_dir(GtkWidget *clist, gint row, gint column,
   		GdkEventButton *event, gpointer data)
{
   	gchar *text;
   
   	gtk_clist_get_text(GTK_CLIST(Dtab->dir_clist), row, column, &text);
        chdir(text);
        LocalLs();
        getcwd(TargetDir, sizeof(TargetDir));
        if (strlen(TargetDir) == 1)
           strcpy(TargetDir, "");

        sprintf(TargetDir, "%s/", TargetDir);
        gtk_label_set(GTK_LABEL(Dtab->dir_label2), TargetDir);

}

void change_filename(GtkWidget *clist, gint row, gint column,
   		GdkEventButton *event, gpointer data)
{
   	gchar *text;
	if (files)
	{
   	   gtk_clist_get_text(GTK_CLIST(Dtab->file_clist), row, column, &text);
           gtk_entry_set_text(GTK_ENTRY(Dtab->filename_entry), text);
	}
}

void
paste(GtkWidget *widget, gpointer data)
{
	gtk_entry_set_text(GTK_ENTRY(Dtab->url_entry), "");
	gtk_editable_paste_clipboard(GTK_EDITABLE(Dtab->url_entry));
}

/*************************************************************************/

void
set_download_flags()
{
	if (flags[paused] == 'p')
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_p),TRUE);
	else
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_p),FALSE);
	if (flags[renamed] == 'r')
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_r),TRUE);
	else
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_r),FALSE);
	if (flags[spooled] == 's')
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_s),TRUE);
	else
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_s),FALSE);
	if (flags[mirrored] == 'm')
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_m),TRUE);
	else
	   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_m),FALSE);
}

void
set_widgets_sensitive()
{
	gtk_widget_set_sensitive(Dtab->url_label, TRUE);
	gtk_widget_set_sensitive(Dtab->url_entry, TRUE);
	gtk_widget_set_sensitive(Dtab->filename_entry, TRUE);
	gtk_widget_set_sensitive(Dtab->button_p, TRUE);

}

/*************************************************************************/

GtkWidget *
build_d_tab()
{
	GtkWidget *v_box;
	GtkWidget *v_box2;
	GtkWidget *h_box;
        gchar	*dir_titles[1] = {_("Directories")};
        gchar	*file_titles[2] = {_("File")};

	GtkTooltips *tooltips;

	Dtab = g_malloc(sizeof(DownloadTab));
	
	tooltips = gtk_tooltips_new();

	v_box = gtk_vbox_new(FALSE, FALSE);
        gtk_widget_show(v_box);
	gtk_box_set_spacing(GTK_BOX(v_box), 8);
	gtk_container_border_width(GTK_CONTAINER(v_box), 8);

        h_box = gtk_hbox_new(FALSE, FALSE);
        gtk_box_pack_start(GTK_BOX(v_box), h_box,FALSE,FALSE,0);
        gtk_widget_show(h_box);

	gtk_box_set_spacing(GTK_BOX(h_box), 5);

        Dtab->url_label = gtk_label_new(_("URL:"));
        gtk_box_pack_start(GTK_BOX(h_box), Dtab->url_label, FALSE, FALSE, 0);
        gtk_widget_show(Dtab->url_label);
         
        Dtab->url_entry = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(h_box), Dtab->url_entry,TRUE,TRUE,0);
        gtk_widget_show(Dtab->url_entry);

//	Dtab->button_p = gnome_pixmap_button(gnome_stock_new_with_icon
//			(GNOME_STOCK_PIXMAP_PASTE),_("Paste"));
	Dtab->button_p = gnome_stock_button(GNOME_STOCK_PIXMAP_PASTE);
        gtk_box_pack_start(GTK_BOX(h_box), Dtab->button_p,FALSE,FALSE,0);
        gtk_widget_show(Dtab->button_p);
        gtk_signal_connect(GTK_OBJECT(Dtab->button_p), "clicked",
				GTK_SIGNAL_FUNC (paste), NULL);

	h_box = gtk_hbox_new(TRUE, FALSE);
        gtk_box_pack_start(GTK_BOX(v_box), h_box,FALSE,FALSE,0);
        gtk_widget_show(h_box);

	button = gnome_pixmap_button(gnome_stock_new_with_icon
			(GNOME_STOCK_PIXMAP_OPEN),_("New Dir"));
        gtk_box_pack_start(GTK_BOX(h_box), button,FALSE,FALSE,10);
        gtk_widget_show(button);
        gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       	GTK_SIGNAL_FUNC (create_dir),NULL );

	button = gnome_pixmap_button(gnome_stock_new_with_icon
			(GNOME_STOCK_PIXMAP_TRASH),_("Remove"));
//	button = gnome_stock_button(GNOME_STOCK_PIXMAP_TRASH);
        gtk_box_pack_start(GTK_BOX(h_box), button,FALSE,FALSE,10);
        gtk_widget_show(button);

	Dtab->paned = gtk_hpaned_new();
        gtk_box_pack_start(GTK_BOX(v_box), Dtab->paned, TRUE, TRUE, 0);
        gtk_widget_show(Dtab->paned);

	gtk_paned_set_position((GtkPaned *)Dtab->paned, DND->Dtab_position);

	DND->Dtab_paned = Dtab->paned;

//	gtk_paned_set_handle_size((GtkPaned *)Dtab->paned, 7);
//	gtk_paned_set_gutter_size((GtkPaned *)Dtab->paned, 8);

        scroll = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
                       	       		GTK_POLICY_AUTOMATIC,
                       			GTK_POLICY_AUTOMATIC);
//        gtk_widget_set_usize(GTK_WIDGET(scroll), 200,200);
//        gtk_box_pack_start(GTK_BOX(h_box), scroll,FALSE,FALSE,0);
	gtk_paned_add1 ((GtkPaned *)Dtab->paned, scroll);
        gtk_widget_show(scroll);

        Dtab->dir_clist = gtk_clist_new_with_titles(1, dir_titles);
/*       gtk_widget_set_usize(GTK_WIDGET(dir_clist), 150,200);*/
        gtk_container_add(GTK_CONTAINER(scroll), Dtab->dir_clist);
        gtk_widget_show(Dtab->dir_clist);
        
        gtk_signal_connect(GTK_OBJECT(Dtab->dir_clist), "select_row",
                               	GTK_SIGNAL_FUNC(change_dir), NULL);

//	gtk_tooltips_set_tip((GtkTooltips *)tooltips,
//                 GTK_CLIST(Dtab->dir_clist)->column[0].button,
//                 "Click here to go to default dir", NULL);

        scroll = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
                                       	GTK_POLICY_AUTOMATIC,
                                        GTK_POLICY_AUTOMATIC);
//        gtk_widget_set_usize(GTK_WIDGET(scroll), 300,200);
//        gtk_box_pack_start(GTK_BOX(h_box), scroll,TRUE,TRUE,0);
	gtk_paned_add2 ((GtkPaned *)Dtab->paned, scroll);

        gtk_widget_show(scroll);
        
        Dtab->file_clist = gtk_clist_new_with_titles(1, file_titles);
/*           gtk_widget_set_usize(GTK_WIDGET(Dtab->file_clist), 350,200);*/
        gtk_container_add(GTK_CONTAINER(scroll), Dtab->file_clist);
        gtk_widget_show(Dtab->file_clist);

        gtk_signal_connect(GTK_OBJECT(Dtab->file_clist), "select_row",
                               	GTK_SIGNAL_FUNC(change_filename), NULL);

//	gtk_tooltips_set_tip((GtkTooltips *)tooltips,
//                 GTK_CLIST(Dtab->file_clist)->column[0].button,
//                 "Right Click on the list for file operations", NULL);

/*	gtk_clist_set_column_width((GtkCList *)file_clist, 0, 200);*/


     /* It's here because needs file_clist to exist */
        gtk_signal_connect(GTK_OBJECT(button), "clicked",
                      	GTK_SIGNAL_FUNC (remove_files), Dtab->file_clist);

	v_box2 = gtk_vbox_new(TRUE, FALSE);
        gtk_box_pack_start(GTK_BOX(v_box),v_box2,FALSE,FALSE,0);
        gtk_widget_show(v_box2);

	gtk_box_set_spacing(GTK_BOX(v_box2), 3);

        alignment = gtk_alignment_new(0,1,0,0);
        gtk_box_pack_start(GTK_BOX(v_box2),alignment,TRUE,FALSE,0);
        gtk_widget_show(alignment);
                        
        h_box = gtk_hbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(alignment), h_box);
        gtk_widget_show(h_box);

        Dtab->dir_label = gtk_label_new(_("Save to: "));
        gtk_box_pack_start(GTK_BOX(h_box), Dtab->dir_label,FALSE,FALSE,0);
        gtk_widget_show(Dtab->dir_label);

        Dtab->dir_label2 = gtk_label_new("not initialized!");
        gtk_box_pack_start(GTK_BOX(h_box), Dtab->dir_label2,FALSE,FALSE,0);
        gtk_widget_show(Dtab->dir_label2);

        Dtab->filename_entry = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(v_box2), Dtab->filename_entry,TRUE,TRUE,0);
        gtk_widget_show(Dtab->filename_entry);

        frame = gtk_frame_new(_("Flags"));
        gtk_box_pack_start(GTK_BOX(v_box),frame,FALSE,FALSE,0);
        gtk_widget_show(frame);
        
	buttonbox = gtk_hbox_new(TRUE,FALSE);
        gtk_container_add(GTK_CONTAINER(frame), buttonbox);
        gtk_widget_show(buttonbox);

       	Dtab->check_p = gtk_check_button_new_with_label(_("Pause"));
        gtk_box_pack_start(GTK_BOX(buttonbox),Dtab->check_p,TRUE,FALSE,0);
        gtk_widget_show(Dtab->check_p);
        if (flags[paused] == 'p')
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_p),TRUE);

        gtk_signal_connect(GTK_OBJECT(Dtab->check_p), "toggled",
				(GtkSignalFunc) toggle_p, NULL);

       	Dtab->check_r = gtk_check_button_new_with_label(_("Rename"));
        gtk_box_pack_start(GTK_BOX(buttonbox),Dtab->check_r,TRUE,FALSE,0);
        gtk_widget_show(Dtab->check_r);
        if (flags[renamed] == 'r')
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_r),TRUE);

        gtk_signal_connect(GTK_OBJECT(Dtab->check_r), "toggled",
                           (GtkSignalFunc) toggle_r, NULL);

        Dtab->check_s = gtk_check_button_new_with_label(_("Spool"));
        gtk_box_pack_start(GTK_BOX(buttonbox),Dtab->check_s,TRUE,FALSE,0);
        gtk_widget_show(Dtab->check_s);
        if (flags[spooled] == 's')
              gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_s),TRUE);

        gtk_signal_connect(GTK_OBJECT(Dtab->check_s), "toggled",
                           (GtkSignalFunc) toggle_s, NULL);

        Dtab->check_m = gtk_check_button_new_with_label(_("Mirrors"));
        gtk_box_pack_start(GTK_BOX(buttonbox),Dtab->check_m,TRUE,FALSE,0);
        gtk_widget_show(Dtab->check_m);
        if (flags[mirrored] == 'm')
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(Dtab->check_m),TRUE);

        gtk_signal_connect(GTK_OBJECT(Dtab->check_m), "toggled",
                           (GtkSignalFunc) toggle_m, NULL);

//        Dtab->check_md = gtk_check_button_new_with_label(_("Massive"));
//        gtk_box_pack_start(GTK_BOX(buttonbox),Dtab->check_md,TRUE,FALSE,0);
//        gtk_widget_show(check_m);
//        if (flags[mirrored] == 'm')
//        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_m),TRUE);

//        gtk_signal_connect(GTK_OBJECT(check_m), "toggled",
//                           (GtkSignalFunc) toggle_m, NULL);

        buttonbox = gtk_hbutton_box_new();
        gtk_box_pack_start(GTK_BOX(v_box),buttonbox,FALSE,FALSE,5);
        gtk_hbutton_box_set_layout_default(1);
        gtk_widget_show(buttonbox);

        button = gnome_stock_button(GNOME_STOCK_BUTTON_OK);
        gtk_container_add(GTK_CONTAINER(buttonbox), button);
        gtk_widget_show(button);
        gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       	GTK_SIGNAL_FUNC (ok_button_click), Dtab->file_clist);

        button = gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL);
        gtk_container_add(GTK_CONTAINER(buttonbox), button);
        gtk_widget_show(button);
        gtk_signal_connect(GTK_OBJECT(button), "clicked",
                        	GTK_SIGNAL_FUNC (close_main_window), DND->window);
	
	return v_box;
}

static GtkWidget *
build_label (gint type)
{
        GtkWidget *hbox, *pixmap, *label;

	label = NULL; /*Just to avoid warnings*/
	pixmap = NULL; /*Just to avoid warnings*/
        hbox = gtk_hbox_new(FALSE, 0);
	switch (type) {
        case DOWNLOAD_TAB:
	        label = gtk_label_new("Download");
	        pixmap = gnome_stock_new_with_icon(GNOME_STOCK_PIXMAP_ADD);
                break;
        case UPLOAD_TAB:
	        label = gtk_label_new("Upload");
                pixmap = gnome_stock_new_with_icon(GNOME_STOCK_PIXMAP_REMOVE);
                break;
        case ADVANCED_TAB:
	        label = gtk_label_new("Advanced");
                pixmap = gnome_stock_new_with_icon(GNOME_STOCK_MENU_BOOK_OPEN);
                break;
        }
        gtk_widget_show(label);
        gtk_widget_show(pixmap);
        gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, FALSE, 2);
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
        return hbox;
}


void build_window()
{
	GtkWidget *v_box2;

	DND->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
//FIXME: remember size!!!
	gtk_window_set_default_size(GTK_WINDOW(DND->window),
		DND->width, DND->height);
        gtk_window_set_policy(GTK_WINDOW(DND->window), FALSE, TRUE, TRUE);
        gtk_window_set_title(GTK_WINDOW(DND->window),
				_("Darxite interface window"));
//        gtk_window_set_position(GTK_WINDOW(DND->window), GTK_WIN_POS_CENTER);
        gtk_signal_connect(GTK_OBJECT(DND->window), "delete_event",
                               	GTK_SIGNAL_FUNC(close_main_window), DND->window);

	DND->notebook = gtk_notebook_new();
        gtk_container_add(GTK_CONTAINER(DND->window), DND->notebook);
        gtk_widget_show(DND->notebook);


	gtk_notebook_append_page(GTK_NOTEBOOK(DND->notebook),
		build_d_tab(), build_label(DOWNLOAD_TAB));
//		v_box, build_label(DOWNLOAD_TAB));

	v_box2 = gtk_vbox_new(FALSE, FALSE);
        gtk_widget_show(v_box2);
//	gtk_notebook_append_page(GTK_NOTEBOOK(DND->notebook), v_box2,
//		build_label(UPLOAD_TAB));
//	gtk_notebook_append_page(GTK_NOTEBOOK(DND->notebook), v_box2,
//		build_label(ADVANCED_TAB));

        gtk_widget_show(DND->window);
}
