/* Gnome Darxite common code
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include <gnome.h>
#include "prefs-appearance.h"

#define NUM_MDI_MODES 4
#define NUM_TOOLBAR_MODES 3

guint mdi_types[NUM_MDI_MODES] = {
        GNOME_MDI_DEFAULT_MODE,
        GNOME_MDI_NOTEBOOK,
        GNOME_MDI_TOPLEVEL,
        GNOME_MDI_MODAL
};

gchar *mdi_type_label[NUM_MDI_MODES] = {
        N_("Default"),
        N_("Notebook"),
        N_("Toplevel"),
        N_("Modal"),
};

guint toolbar_types[NUM_TOOLBAR_MODES] =
{
	GTK_TOOLBAR_ICONS,
	GTK_TOOLBAR_TEXT,
	GTK_TOOLBAR_BOTH
};

gchar *toolbar_type_label[NUM_TOOLBAR_MODES] =
{
	N_("Icons"),
	N_("Text"),
	N_("Both")
};


GtkRadioButton *mdi_type[NUM_MDI_MODES]; //for the appearance tab
GtkRadioButton *toolbar_type[NUM_TOOLBAR_MODES]; //for the appearance tab


/*---------------------------------------------------------------------*/
static void properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox);
GtkWidget * appearance_tab_make(GnomePropertyBox *pbox,
			gint *mdi_mode, gint *toolbar_mode);
void appearance_tab_apply_changes(GnomeMDI *mdi, gint *mdi_mode,
				GtkToolbar *toolbar, gint *toolbar_mode);

/*---------------------------------------------------------------------*/

static void
properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox)
{
        gnome_property_box_changed(pbox);
}

GtkWidget *
appearance_tab_make(GnomePropertyBox *pbox, gint *mdi_mode, gint *toolbar_mode)
{
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *frame;
	GSList *group;
	gint i;
	
	hbox = gtk_hbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), GNOME_PAD_SMALL);
        gtk_widget_show(hbox);

	/*MDI*/
	frame = gtk_frame_new(_("MDI Mode"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 2);  
        gtk_widget_show(frame);

        vbox = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(frame), vbox);
        gtk_widget_show(vbox);
        group = NULL;
        for(i = 0; i < NUM_MDI_MODES; i++)
        {
           mdi_type[i] = GTK_RADIO_BUTTON(
           		gtk_radio_button_new_with_label(group, _(mdi_type_label[i])));
           gtk_widget_show(GTK_WIDGET(mdi_type[i]));
           gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(mdi_type[i]), TRUE, TRUE, 2);
           group = gtk_radio_button_group (mdi_type[i]);
        }
        
	/*Toolbar*/
	frame = gtk_frame_new(_("Toolbar Mode"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 2);  
        gtk_widget_show(frame);

        vbox = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(frame), vbox);
        gtk_widget_show(vbox);
        group = NULL;
        for(i = 0; i < NUM_TOOLBAR_MODES; i++)
        {
           toolbar_type[i] = GTK_RADIO_BUTTON(
           		gtk_radio_button_new_with_label(group, _(toolbar_type_label[i])));
	   gtk_widget_show(GTK_WIDGET(toolbar_type[i]));
	   gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(toolbar_type[i]), TRUE, TRUE, 2);
	   group = gtk_radio_button_group (toolbar_type[i]);
        }

//Set preferences:

        for(i = 0; i < NUM_MDI_MODES; i++)
           if(*mdi_mode == mdi_types[i])
           {
              gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(mdi_type[i]), TRUE);
              break;
           }

	for (i = 0; i < NUM_TOOLBAR_MODES; i++)
	   if (*toolbar_mode == toolbar_types[i])
	   {
	      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toolbar_type[i]), TRUE);
	      break;
	   }

        for(i = 0; i < NUM_MDI_MODES; i++)
                gtk_signal_connect(GTK_OBJECT(mdi_type[i]), "clicked",
					properties_modified_cb, pbox);
        for(i = 0; i < NUM_TOOLBAR_MODES; i++)
                gtk_signal_connect(GTK_OBJECT(toolbar_type[i]), "clicked",
					properties_modified_cb, pbox);

	return hbox;
}

void
appearance_tab_apply_changes(GnomeMDI *mdi, gint *mdi_mode,
			GtkToolbar *toolbar, gint *toolbar_mode)
{
	gint i;

        for(i = 0; i < NUM_MDI_MODES; i++)
           if(GTK_TOGGLE_BUTTON(mdi_type[i])->active)
           {
              if(*mdi_mode != mdi_types[i])
              {
                 *mdi_mode = mdi_types[i];
                 gnome_mdi_set_mode(mdi, *mdi_mode);
              }
              break;
           }
	for (i = 0; i < NUM_TOOLBAR_MODES; i++)
	   if (GTK_TOGGLE_BUTTON(toolbar_type[i])->active)
	   {
	      if(*toolbar_mode != toolbar_types[i])
	      {
                 *toolbar_mode = toolbar_types[i];
                 gtk_toolbar_set_style(GTK_TOOLBAR(toolbar),
                 				*toolbar_mode);
	      }
	      break;
	   }
}
