/* Gnome Darxite common code
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include <gnome.h>
#include "daemon.h"
#include "prefs-daemon.h"

GtkWidget *cb_startup_connect;

GtkRadioButton *rb_local;
GtkRadioButton *rb_remote;

GtkWidget *cb_retry_connect_local;
GtkWidget *sb_retry_timeout_local;
GtkWidget *cb_retry_connect_remote;
GtkWidget *sb_retry_timeout_remote;

GtkWidget *cb_file_count_local;
GtkWidget *sb_file_count_timeout_local;
GtkWidget *cb_file_count_remote;
GtkWidget *sb_file_count_timeout_remote;
GtkWidget *cb_file_status_local;
GtkWidget *sb_file_status_timeout_local;
GtkWidget *cb_file_status_remote;
GtkWidget *sb_file_status_timeout_remote;

GtkWidget *cb_auto_start_local;
GtkWidget *cb_always_connected_local;

/*---------------------------------------------------------------------*/
static void properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox);
GtkWidget * daemon_tab_make(GnomePropertyBox *pbox);
void daemon_tab_apply_changes();
void daemon_tab_load_config();
void daemon_tab_save_config();

/*---------------------------------------------------------------------*/

static void
properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox)
{
        gnome_property_box_changed(pbox);
}

GtkWidget *
daemon_tab_make(GnomePropertyBox *pbox)
{
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *frame;
	GtkWidget *hbox;
	GtkWidget *hbox2;
	GSList    *group;
	GtkAdjustment *ad_retry_timeout_local;
	GtkAdjustment *ad_retry_timeout_remote;
	GtkWidget *label;
	GtkAdjustment *ad_file_count_timeout_local;
	GtkAdjustment *ad_file_count_timeout_remote;
	GtkAdjustment *ad_file_status_timeout_local;
	GtkAdjustment *ad_file_status_timeout_remote;
		
	vbox = gtk_vbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), GNOME_PAD_SMALL);
        gtk_widget_show(vbox);

	/*Startup*/
	frame = gtk_frame_new(_("Startup"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 2);  
        gtk_widget_show(frame);

        vbox2 = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(frame), vbox2);
        gtk_widget_show(vbox2);

	cb_startup_connect = gtk_check_button_new_with_label(
			_("Connect to the daemon at startup"));
	gtk_box_pack_start(GTK_BOX(vbox2),
		GTK_WIDGET(cb_startup_connect), FALSE, TRUE, 2);
	gtk_widget_show(cb_startup_connect);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, TRUE, 2);  
        gtk_widget_show(hbox);
        
	group = NULL;
        rb_local = GTK_RADIO_BUTTON(gtk_radio_button_new_with_label
        		(group, _("Connect to local daemon")));
	gtk_widget_show(GTK_WIDGET(rb_local));
	gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(rb_local), TRUE, TRUE, 2);
	group = gtk_radio_button_group (rb_local);

        rb_remote = GTK_RADIO_BUTTON(gtk_radio_button_new_with_label
        		(group, _("Connect to remote daemon")));
	gtk_widget_show(GTK_WIDGET(rb_remote));
	gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(rb_remote), TRUE, TRUE, 2);
	group = gtk_radio_button_group (rb_remote);

        hbox2 = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, TRUE, 0);  
        gtk_widget_show(hbox2);

//Automation: LOCAL
	frame = gtk_frame_new(_("Local"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(hbox2), frame, TRUE, TRUE, 2);  
        gtk_widget_show(frame);

        vbox2 = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(frame), vbox2);
        gtk_widget_show(vbox2);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, TRUE, 2);  
        gtk_widget_show(hbox);

	cb_retry_connect_local = gtk_check_button_new_with_label(
			_("Retry connect every"));
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(cb_retry_connect_local), FALSE, TRUE, 2);
	gtk_widget_show(cb_retry_connect_local);

	ad_retry_timeout_local = (GtkAdjustment *) gtk_adjustment_new
		(retry_timeout_local, 1, 300, 1, 10, 0);
	sb_retry_timeout_local = gtk_spin_button_new
				(ad_retry_timeout_local, 0.1, 0);
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(sb_retry_timeout_local), FALSE, TRUE, 2);
	gtk_widget_show(sb_retry_timeout_local);

        label = gtk_label_new(_("seconds."));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 2);  
        gtk_widget_show(label);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, TRUE, 2);  
        gtk_widget_show(hbox);

	cb_file_count_local = gtk_check_button_new_with_label(
			_("Get statistics every"));
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(cb_file_count_local), FALSE, TRUE, 2);
	gtk_widget_show(cb_file_count_local);

	ad_file_count_timeout_local = (GtkAdjustment *) gtk_adjustment_new
		(file_count_timeout_local, 1, 300, 1, 10, 0);
	sb_file_count_timeout_local = gtk_spin_button_new
				(ad_file_count_timeout_local, 0.1, 0);
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(sb_file_count_timeout_local), FALSE, TRUE, 2);
	gtk_widget_show(sb_file_count_timeout_local);

        label = gtk_label_new(_("seconds."));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 2);  
        gtk_widget_show(label);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, TRUE, 2);  
        gtk_widget_show(hbox);

	cb_file_status_local = gtk_check_button_new_with_label(
			_("Get download list every"));
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(cb_file_status_local), FALSE, TRUE, 2);
	gtk_widget_show(cb_file_status_local);

	ad_file_status_timeout_local = (GtkAdjustment *) gtk_adjustment_new
		(file_status_timeout_local, 1, 300, 1, 10, 0);
	sb_file_status_timeout_local = gtk_spin_button_new
				(ad_file_status_timeout_local, 0.1, 0);
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(sb_file_status_timeout_local), FALSE, TRUE, 2);
	gtk_widget_show(sb_file_status_timeout_local);

        label = gtk_label_new(_("seconds."));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 2);  
        gtk_widget_show(label);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, TRUE, 2);  
        gtk_widget_show(hbox);

	cb_auto_start_local = gtk_check_button_new_with_label(
			_("Start daemon if needed"));
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(cb_auto_start_local), FALSE, TRUE, 2);
	gtk_widget_show(cb_auto_start_local);

	cb_always_connected_local = gtk_check_button_new_with_label(
			_("Always connected to daemon"));
	gtk_box_pack_start(GTK_BOX(vbox2),
		GTK_WIDGET(cb_always_connected_local), FALSE, TRUE, 2);
	gtk_widget_show(cb_always_connected_local);


//Automation: REMOTE
	frame = gtk_frame_new(_("Remote"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(hbox2), frame, TRUE, TRUE, 2);  
	gtk_widget_show(frame);

        vbox2 = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(frame), vbox2);
        gtk_widget_show(vbox2);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, TRUE, 2);  
        gtk_widget_show(hbox);

	cb_retry_connect_remote = gtk_check_button_new_with_label(
			_("Retry connect every"));
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(cb_retry_connect_remote), FALSE, TRUE, 2);
	gtk_widget_show(cb_retry_connect_remote);

	ad_retry_timeout_remote = (GtkAdjustment *) gtk_adjustment_new
		(retry_timeout_remote, 1, 300, 1, 10, 0);
	sb_retry_timeout_remote = gtk_spin_button_new
			(ad_retry_timeout_remote, 0.1, 0);
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(sb_retry_timeout_remote), FALSE, TRUE, 2);
	gtk_widget_show(sb_retry_timeout_remote);

        label = gtk_label_new(_("seconds."));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 2);  
        gtk_widget_show(label);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, TRUE, 2);  
        gtk_widget_show(hbox);

	cb_file_count_remote = gtk_check_button_new_with_label(
			_("Get statistics every"));
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(cb_file_count_remote), FALSE, TRUE, 2);
	gtk_widget_show(cb_file_count_remote);

	ad_file_count_timeout_remote = (GtkAdjustment *) gtk_adjustment_new
		(file_count_timeout_remote, 1, 300, 1, 10, 0);
	sb_file_count_timeout_remote = gtk_spin_button_new
				(ad_file_count_timeout_remote, 0.1, 0);
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(sb_file_count_timeout_remote), FALSE, TRUE, 2);
	gtk_widget_show(sb_file_count_timeout_remote);

        label = gtk_label_new(_("seconds."));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 2);  
        gtk_widget_show(label);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, TRUE, 2);  
        gtk_widget_show(hbox);

	cb_file_status_remote = gtk_check_button_new_with_label(
			_("Get download list every"));
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(cb_file_status_remote), FALSE, TRUE, 2);
	gtk_widget_show(cb_file_status_remote);

	ad_file_status_timeout_remote = (GtkAdjustment *) gtk_adjustment_new
		(file_status_timeout_remote, 1, 300, 1, 10, 0);
	sb_file_status_timeout_remote = gtk_spin_button_new
				(ad_file_status_timeout_remote, 0.1, 0);
	gtk_box_pack_start(GTK_BOX(hbox),
		GTK_WIDGET(sb_file_status_timeout_remote), FALSE, TRUE, 2);
	gtk_widget_show(sb_file_status_timeout_remote);

        label = gtk_label_new(_("seconds."));
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 2);  
        gtk_widget_show(label);



//Set preferences:

	if (startup_connect)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_startup_connect), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_startup_connect), "clicked",
					properties_modified_cb, pbox);

	if (startup_local)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(rb_local), TRUE);
	else
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(rb_remote), TRUE);

	gtk_signal_connect(GTK_OBJECT(rb_local), "clicked",
					properties_modified_cb, pbox);

	gtk_signal_connect(GTK_OBJECT(rb_remote), "clicked",
					properties_modified_cb, pbox);

	//Automation: LOCAL
	if (retry_connect_local)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_retry_connect_local), TRUE);
        gtk_signal_connect (GTK_OBJECT (cb_retry_connect_local), "clicked",
        				properties_modified_cb, pbox);
        gtk_signal_connect (GTK_OBJECT (ad_retry_timeout_local), "value_changed",
        				properties_modified_cb, pbox);

	if (file_count_local)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_file_count_local), TRUE);
        gtk_signal_connect (GTK_OBJECT (cb_file_count_local), "clicked",
        				properties_modified_cb, pbox);
        gtk_signal_connect (GTK_OBJECT (ad_file_count_timeout_local),
        		"value_changed", properties_modified_cb, pbox);

	if (file_status_local)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_file_status_local), TRUE);
        gtk_signal_connect (GTK_OBJECT (cb_file_status_local), "clicked",
        				properties_modified_cb, pbox);
        gtk_signal_connect (GTK_OBJECT (ad_file_status_timeout_local),
        		"value_changed", properties_modified_cb, pbox);

	if (auto_start_local)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_auto_start_local), TRUE);
        gtk_signal_connect (GTK_OBJECT (cb_auto_start_local), "clicked",
        				properties_modified_cb, pbox);

	if (always_connected_local)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_always_connected_local), TRUE);
        gtk_signal_connect (GTK_OBJECT (cb_always_connected_local), "clicked",
        				properties_modified_cb, pbox);

	//Automation: REMOTE
	if (retry_connect_remote)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_retry_connect_remote), TRUE);
        gtk_signal_connect (GTK_OBJECT (cb_retry_connect_remote), "clicked",
        				properties_modified_cb, pbox);
        gtk_signal_connect (GTK_OBJECT (ad_retry_timeout_remote), "value_changed",
        				properties_modified_cb, pbox);
	
	if (file_count_remote)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_file_count_remote), TRUE);
        gtk_signal_connect (GTK_OBJECT (cb_file_count_remote), "clicked",
        				properties_modified_cb, pbox);
        gtk_signal_connect (GTK_OBJECT (ad_file_count_timeout_remote),
        			"value_changed", properties_modified_cb, pbox);

	if (file_status_remote)
	gtk_toggle_button_set_active
	   (GTK_TOGGLE_BUTTON(cb_file_status_remote), TRUE);
        gtk_signal_connect (GTK_OBJECT (cb_file_status_remote), "clicked",
        				properties_modified_cb, pbox);
        gtk_signal_connect (GTK_OBJECT (ad_file_status_timeout_remote),
        			"value_changed", properties_modified_cb, pbox);

	return vbox;
}

void
daemon_tab_apply_changes()
//FIXME:should be ..nges(gboolean has_...)
{
	if (GTK_TOGGLE_BUTTON(cb_startup_connect)->active)
	   startup_connect = TRUE;
	else
	   startup_connect = FALSE;

	if (GTK_TOGGLE_BUTTON(rb_local)->active)
	   startup_local = TRUE;
	else
	   startup_local = FALSE;

//Automation: LOCAL
	if (GTK_TOGGLE_BUTTON(cb_retry_connect_local)->active)
	   retry_connect_local = TRUE;
	else
	   retry_connect_local = FALSE;
	
	retry_timeout_local = gtk_spin_button_get_value_as_int
			((GtkSpinButton *)sb_retry_timeout_local);

	if (GTK_TOGGLE_BUTTON(cb_file_count_local)->active)
	   file_count_local = TRUE;
	else
	   file_count_local = FALSE;
	
	file_count_timeout_local = gtk_spin_button_get_value_as_int
			((GtkSpinButton *)sb_file_count_timeout_local);

	if (GTK_TOGGLE_BUTTON(cb_file_status_local)->active)
	   file_status_local = TRUE;
	else
	   file_status_local = FALSE;
	
	file_status_timeout_local = gtk_spin_button_get_value_as_int
			((GtkSpinButton *)sb_file_status_timeout_local);

	if (GTK_TOGGLE_BUTTON(cb_auto_start_local)->active)
	   auto_start_local = TRUE;
	else
	   auto_start_local = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_always_connected_local)->active)
	   always_connected_local = TRUE;
	else
	   always_connected_local = FALSE;


//Automation: REMOTE
	if (GTK_TOGGLE_BUTTON(cb_retry_connect_remote)->active)
	   retry_connect_remote = TRUE;
	else
	   retry_connect_remote = FALSE;

	retry_timeout_remote = gtk_spin_button_get_value_as_int
			((GtkSpinButton *)sb_retry_timeout_remote);

	if (GTK_TOGGLE_BUTTON(cb_file_count_remote)->active)
	   file_count_remote = TRUE;
	else
	   file_count_remote = FALSE;
	
	file_count_timeout_remote = gtk_spin_button_get_value_as_int
			((GtkSpinButton *)sb_file_count_timeout_remote);

	if (GTK_TOGGLE_BUTTON(cb_file_status_remote)->active)
	   file_status_remote = TRUE;
	else
	   file_status_remote = FALSE;
	
	file_status_timeout_remote = gtk_spin_button_get_value_as_int
			((GtkSpinButton *)sb_file_status_timeout_remote);

//Timeouts handling :)
//Retry connection
	if (retry_connect_timeout)
	{
	   if (local)
	   {
	      if (retry_connect_local)
	      {
	         //remove and launch again
	         gtk_timeout_remove(retry_connect_timeout);
	         retry_connect_timeout = gtk_timeout_add
				(retry_timeout_local*1000, retry_connect_cb, NULL);
	      }
	      else
	      {
	         //remove
	         gtk_timeout_remove(retry_connect_timeout);
	         retry_connect_timeout = 0;
	      }
	   }
	   else // remote!
   	   {
	      if (retry_connect_remote)
	      {
	         //remove and launch again
	         gtk_timeout_remove(retry_connect_timeout);
	         retry_connect_timeout = gtk_timeout_add
				(retry_timeout_remote*1000, retry_connect_cb, NULL);
	      }
	      else
	      {
	         //remove
	         gtk_timeout_remove(retry_connect_timeout);
	         retry_connect_timeout = 0;
	      }
	   }
	}
//file_count
	if (file_count_timeout)
	{
	   if (local)
	   {
	      if (file_count_local)
	      {
	         //remove and launch again
	         gtk_timeout_remove(file_count_timeout);
	         file_count_timeout = gtk_timeout_add
				(file_count_timeout_local*1000, file_count_cb, NULL);
	      }
	      else
	      {
	         //remove
	         gtk_timeout_remove(file_count_timeout);
	         file_count_timeout = 0;
	      }
	   }
	   else // remote!
   	   {
	      if (file_count_remote)
	      {
	         //remove and launch again
	         gtk_timeout_remove(file_count_timeout);
	         file_count_timeout = gtk_timeout_add
				(file_count_timeout_remote*1000, file_count_cb, NULL);
	      }
	      else
	      {
	         //remove
	         gtk_timeout_remove(file_count_timeout);
	         file_count_timeout = 0;
	      }
	   }
	}
	else
	{
	   if (local)
	   {
	      if (connected && file_count_local)
	         file_count_timeout = gtk_timeout_add
				(file_count_timeout_local*1000, file_count_cb, NULL);
	   }
	   else //remote
	   {
	      if (connected && file_count_remote)
	         file_count_timeout = gtk_timeout_add
				(file_count_timeout_remote*1000, file_count_cb, NULL);
	   }
	}
	
//file_status
	if (file_status_timeout)
	{
	   if (local)
	   {
	      if (file_status_local)
	      {
	         //remove and launch again
	         gtk_timeout_remove(file_status_timeout);
	         if (!first_file_status_sent)
	         {
	            SendToDaemon("FileStatus\n");
	            first_file_status_sent = TRUE;	            
	         }
	         file_status_timeout = gtk_timeout_add
				(file_status_timeout_local*1000, file_status_cb, NULL);
	      }
	      else
	      {
	         //remove
	         gtk_timeout_remove(file_status_timeout);
	         file_status_timeout = 0;
	      }
	   }
	   else // remote!
   	   {
	      if (file_status_remote)
	      {
	         //remove and launch again
	         gtk_timeout_remove(file_status_timeout);
	         if (!first_file_status_sent)
	         {
	            SendToDaemon("FileStatus\n");
	            first_file_status_sent = TRUE;	            
	         }
	         file_status_timeout = gtk_timeout_add
				(file_status_timeout_remote*1000, file_status_cb, NULL);
	      }
	      else
	      {
	         //remove
	         gtk_timeout_remove(file_status_timeout);
	         file_status_timeout = 0;
	      }
	   }
	}
	else
	{
	   if (local)
	   {
	      if (connected && file_status_local)
	      {
	         if (!first_file_status_sent)
	         {
	            SendToDaemon("FileStatus\n");
	            first_file_status_sent = TRUE;	            
	         }
	         file_status_timeout = gtk_timeout_add
				(file_status_timeout_local*1000, file_status_cb, NULL);
	      }
	   }
	   else //remote
	   {
	      if (connected && file_status_remote)
	      {
	         if (!first_file_status_sent)
	         {
	            SendToDaemon("FileStatus\n");
	            first_file_status_sent = TRUE;	            
	         }
	         file_status_timeout = gtk_timeout_add
				(file_status_timeout_remote*1000, file_status_cb, NULL);
	      }
	   }
	}
}

void
daemon_tab_load_config()
{
	startup_connect = gnome_config_get_int("Daemon/connect=1");
	startup_local = gnome_config_get_int("Daemon/local=1");
//Automation: LOCAL
	retry_connect_local = gnome_config_get_int("Daemon/retry_local=1");
	retry_timeout_local = gnome_config_get_int("Daemon/retry_timeout_local=2");
	file_count_local = gnome_config_get_int("Daemon/file_count_local=1");
	file_count_timeout_local = gnome_config_get_int("Daemon/fc_timeout_local=1");
	file_status_local = gnome_config_get_int("Daemon/file_status_local=1");
	file_status_timeout_local = gnome_config_get_int("Daemon/fs_timeout_local=2");
	auto_start_local = gnome_config_get_int("Daemon/auto_start_local=1");
	always_connected_local = gnome_config_get_int("Daemon/always_connected_local=1");

//Automation: REMOTE
	retry_connect_remote = gnome_config_get_int("Daemon/retry_remote=1");
	retry_timeout_remote = gnome_config_get_int("Daemon/retry_timeout_remote=15");
	file_count_remote = gnome_config_get_int("Daemon/file_count_remote=1");
	file_count_timeout_remote = gnome_config_get_int("Daemon/fc_timeout_remote=2");
	file_status_remote = gnome_config_get_int("Daemon/file_status_remote=1");
	file_status_timeout_remote = gnome_config_get_int("Daemon/fs_timeout_remote=10");

}
void

daemon_tab_save_config()
{
	gnome_config_set_int("Daemon/connect", startup_connect);
	gnome_config_set_int("Daemon/local", startup_local);

//Automation: LOCAL
	gnome_config_set_int("Daemon/retry_local", retry_connect_local);
	gnome_config_set_int("Daemon/retry_timeout_local", retry_timeout_local);
	gnome_config_set_int("Daemon/file_count_local", file_count_local);
	gnome_config_set_int("Daemon/fc_timeout_local", file_count_timeout_local);
	gnome_config_set_int("Daemon/file_status_local", file_status_local);
	gnome_config_set_int("Daemon/fs_timeout_local", file_status_timeout_local);
	gnome_config_set_int("Daemon/auto_start_local", auto_start_local);
	gnome_config_set_int("Daemon/always_connected_local", always_connected_local);

//Automation: REMOTE
	gnome_config_set_int("Daemon/retry_remote", retry_connect_remote);
	gnome_config_set_int("Daemon/retry_timeout_remote", retry_timeout_remote);
	gnome_config_set_int("Daemon/file_count_remote", file_count_remote);
	gnome_config_set_int("Daemon/fc_timeout_remote", file_count_timeout_remote);
	gnome_config_set_int("Daemon/file_status_remote", file_status_remote);
	gnome_config_set_int("Daemon/fs_timeout_remote", file_status_timeout_remote);
}

void daemon_tab_initializations()
{
	retry_connect_timeout = 0;
	file_count_timeout = 0;
	file_status_timeout = 0;
}