/* Gnome Darxite Monitor applet
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

/* widgets for Gnome Darxite Monitor Applet*/

#include "global.h"
#include "../common/dnd.h"
#include "widgets.h"
#include "../common/callbacks.h"
#include "../common/connect.h"

#include "d.xpm"
#include "d2.xpm"
//#include "red_led.xpm"
//#include "green_led.xpm"

/* Some constants */
#define PIXMAP_WIDTH 37
#define PIXMAP_LITTLE_WIDTH 14

GtkWidget *hvbox;
GtkWidget *hvbox2;
GtkWidget *hvbox2h;
GtkWidget *vhbox;

GtkWidget *logo_button;
GtkWidget *logo_button_pixmap1;
GtkWidget *logo_button_pixmap2;
GtkWidget *logo_button_pixmap3;
GtkWidget *logo_button_pixmap4;
GtkWidget *power_button;
GtkWidget *power_button_pixred;
GtkWidget *power_button_pixgreen;
GtkWidget *percent_button;
GtkWidget *percent_button_label;
GtkWidget *files_button;
GtkWidget *files_button_label;

gboolean flashing = FALSE;

void create_widgets();
gint unflash_logo(gpointer data);

GtkWidget *
monitor_widget_make()
{
	GtkWidget *frame;
	GtkWidget *box;

        static GtkTargetEntry drop_types [] = {
           	{ "text/uri-list", 0, TARGET_URI_LIST },
                { "x-url/http",    0, TARGET_NETSCAPE_URL },
                { "x-url/ftp",     0, TARGET_NETSCAPE_URL },
                { "_NETSCAPE_URL", 0, TARGET_NETSCAPE_URL },
        };
        static gint n_drop_types = sizeof (drop_types) / sizeof(drop_types[0]);
        
	#ifdef USE_FRAME
        frame = gtk_frame_new(NULL);
        gtk_widget_show(frame);

/*gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);*/

        gtk_drag_dest_set (GTK_WIDGET(frame), GTK_DEST_DEFAULT_MOTION |
       		   GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
                   drop_types, n_drop_types, GDK_ACTION_COPY);
        gtk_signal_connect (GTK_OBJECT(frame), "drag_data_received",
           		    GTK_SIGNAL_FUNC (drag_data_received), NULL);


        /*create widgets*/
   	box = gtk_vbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(frame), box);
        gtk_widget_show(box);
	#else
   	box = gtk_vbox_new(FALSE, FALSE);
        gtk_widget_show(box);
        gtk_drag_dest_set (GTK_WIDGET(box), GTK_DEST_DEFAULT_MOTION |
       		   GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
                   drop_types, n_drop_types, GDK_ACTION_COPY);
        gtk_signal_connect (GTK_OBJECT(box), "drag_data_received",
           		    GTK_SIGNAL_FUNC (drag_data_received), NULL);

	#endif

        hbox = gtk_hbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(box), hbox);
        gtk_widget_show(hbox);

        vbox = gtk_vbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(box), vbox);
        gtk_widget_show(vbox);

        hvbox = gtk_vbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(hbox), hvbox);
        gtk_widget_show(hvbox);

        hvbox2 = gtk_vbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(hbox), hvbox2);
        gtk_widget_show(hvbox2);

        hvbox2h = gtk_hbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(hvbox2), hvbox2h);
        gtk_widget_show(hvbox2h);

        vhbox = gtk_hbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(vbox), vhbox);
        gtk_widget_show(vhbox);

	create_widgets();
	
	#ifdef USE_FRAME
        return frame;
	#else
	return box;
	#endif
}

void create_widgets()
{
	GtkWidget *logos_box;

        logo_button = gtk_button_new();
        gtk_button_set_relief(GTK_BUTTON(logo_button), GTK_RELIEF_NONE);
        gtk_box_pack_start_defaults(GTK_BOX(hbox), logo_button);
        gtk_signal_connect(GTK_OBJECT(logo_button), "clicked",
	       		GTK_SIGNAL_FUNC (pop_window_d), NULL);

	logos_box = gtk_hbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(logo_button), logos_box);
	gtk_widget_show(logos_box);

        logo_button_pixmap1 = gnome_pixmap_new_from_xpm_d_at_size (d_xpm, PIXMAP_LITTLE_WIDTH, PIXMAP_LITTLE_WIDTH);
        logo_button_pixmap2 = gnome_pixmap_new_from_xpm_d_at_size(d_xpm,PIXMAP_WIDTH,PIXMAP_WIDTH);
        logo_button_pixmap3 = gnome_pixmap_new_from_xpm_d_at_size (d2_xpm, PIXMAP_LITTLE_WIDTH, PIXMAP_LITTLE_WIDTH);
        logo_button_pixmap4 = gnome_pixmap_new_from_xpm_d_at_size(d2_xpm,PIXMAP_WIDTH,PIXMAP_WIDTH);

        gtk_box_pack_start_defaults(GTK_BOX(logos_box), logo_button_pixmap1);
        gtk_box_pack_start_defaults(GTK_BOX(logos_box), logo_button_pixmap2);
        gtk_box_pack_start_defaults(GTK_BOX(logos_box), logo_button_pixmap3);
        gtk_box_pack_start_defaults(GTK_BOX(logos_box), logo_button_pixmap4);

/*           gtk_widget_show(logo_button_pixmap1);
           gtk_widget_show(logo_button_pixmap2);
           gtk_widget_show(logo_button_pixmap3);
           gtk_widget_show(logo_button_pixmap4);*/

        if (show_logo_button_little)
           gtk_widget_show(logo_button_pixmap1);
	else  
           gtk_widget_show(logo_button_pixmap2);

        gtk_widget_show(logo_button);

        power_button = gtk_button_new();
        gtk_button_set_relief(GTK_BUTTON(power_button), GTK_RELIEF_NONE);
        gtk_box_pack_start_defaults(GTK_BOX(hbox), power_button);
        gtk_signal_connect(GTK_OBJECT(power_button), "clicked",
         		GTK_SIGNAL_FUNC (start_stop_daemon_cb), NULL);

	logos_box = gtk_hbox_new(FALSE, FALSE);
        gtk_container_add(GTK_CONTAINER(power_button), logos_box);
	gtk_widget_show(logos_box);

//        power_button_pixgreen = gnome_pixmap_new_from_xpm_d(green_led_xpm);
        power_button_pixgreen = gnome_stock_pixmap_widget_at_size (NULL,
        	GNOME_STOCK_BUTTON_YES,
        	PIXMAP_LITTLE_WIDTH - 2, PIXMAP_LITTLE_WIDTH - 2);
//        power_button_pixred = gnome_pixmap_new_from_xpm_d(red_led_xpm);
        power_button_pixred = gnome_stock_pixmap_widget_at_size (NULL,
        	GNOME_STOCK_BUTTON_NO,
        	PIXMAP_LITTLE_WIDTH - 2, PIXMAP_LITTLE_WIDTH - 2);
        gtk_box_pack_start_defaults(GTK_BOX(logos_box), power_button_pixgreen);
        gtk_box_pack_start_defaults(GTK_BOX(logos_box), power_button_pixred);

        if (connected)
           gtk_widget_show(power_button_pixgreen);
	else  
           gtk_widget_show(power_button_pixred);
	
	percent_button = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(percent_button), GTK_RELIEF_NONE);
        gtk_box_pack_start_defaults(GTK_BOX(hbox), percent_button);
        gtk_signal_connect(GTK_OBJECT(percent_button), "clicked",
        		GTK_SIGNAL_FUNC (button_status_click), NULL);
	   
	percent_button_label = gtk_label_new("...");
	#ifdef FIX_PERCENT_BUTTON
	gtk_widget_set_usize(GTK_WIDGET(percent_button_label), 0, 14);
	#endif
	gtk_container_add(GTK_CONTAINER(percent_button), percent_button_label);
	gtk_widget_show(percent_button_label);
/*	gtk_widget_show(percent_button);*/
	
	files_button = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(files_button), GTK_RELIEF_NONE);
        gtk_box_pack_start_defaults(GTK_BOX(hbox), files_button);
        gtk_signal_connect(GTK_OBJECT(files_button), "clicked",
           		GTK_SIGNAL_FUNC (button_files_click), NULL);
	   
	files_button_label = gtk_label_new("...");
	#ifdef FIX_FILES_BUTTON
	gtk_widget_set_usize(GTK_WIDGET(files_button_label), 0, 14);
	#endif
        gtk_container_add(GTK_CONTAINER(files_button), files_button_label);
	gtk_widget_show(files_button_label);
/*	gtk_widget_show(files_button);*/
	
/*	update_widgets();*/

}

void update_widgets()
{
	if (show_logo_button)
	   {
           gtk_widget_hide(logo_button_pixmap1);
           gtk_widget_hide(logo_button_pixmap2);
           gtk_widget_hide(logo_button_pixmap3);
           gtk_widget_hide(logo_button_pixmap4);
/*           gtk_widget_hide(GTK_BIN(logo_button)->child);*/

           if (show_logo_button_little)
              gtk_widget_show(logo_button_pixmap1);
	   else
             gtk_widget_show(logo_button_pixmap2);

           gtk_widget_show(logo_button);
	   }
	else
           gtk_widget_hide(logo_button);

	if (!connected)
	{
	   gtk_label_set(GTK_LABEL(percent_button_label), " - ");
           gtk_label_set(GTK_LABEL(files_button_label), " - ");
	}

	if (show_percent_button)
	   gtk_widget_show(percent_button);
	else
	   gtk_widget_hide(percent_button);

	if (show_files_button)
	   gtk_widget_show(files_button);
	else
	   gtk_widget_hide(files_button);

	if (show_power_button)
	{
   	   if (connected)
           {
              gtk_widget_hide(power_button_pixred);
              gtk_widget_show(power_button_pixgreen);
           }
           else
           {
              gtk_widget_hide(power_button_pixgreen);
              gtk_widget_show(power_button_pixred);
           }

	   gtk_widget_show(power_button);
        }
	else
	   gtk_widget_hide(power_button);
}

void distribute_widgets(void)
{

	if (panel_orientation)
	{
	   if (use_two_lines && show_logo_button && show_power_button && show_logo_button_little)
	   {
	      gtk_widget_reparent(logo_button, vhbox);
              gtk_box_reorder_child (GTK_BOX(vhbox), logo_button,0);
	      gtk_widget_reparent(power_button, vhbox);
	   }
	   else
	   {
	      if (show_logo_button)
	      {
 	         gtk_widget_reparent(logo_button, vbox);
	         gtk_box_reorder_child (GTK_BOX(vbox), logo_button,0);
	      }
	      if (show_power_button)
	      {
	         gtk_widget_reparent(power_button, vbox);
	         gtk_box_reorder_child (GTK_BOX(vbox), power_button,1);
	      }
	   }
	   if (show_percent_button)
	      gtk_widget_reparent(percent_button, vbox);
	   if (show_files_button)
	      gtk_widget_reparent(files_button, vbox);
 	}
	else
	{
	   if (use_two_lines)
	   {
	      if (show_logo_button)
	      {
		 if (!show_logo_button_little)
		 {
		    gtk_widget_reparent(logo_button, hbox);
                    gtk_box_reorder_child (GTK_BOX(hbox), logo_button,0);

		    if (show_percent_button && show_files_button)
		    {
		       if (show_power_button)
		          {
		          gtk_widget_reparent(power_button, hbox);
                          gtk_box_reorder_child (GTK_BOX(hbox), power_button,1);
		          }
		    }
		    else
		    {
		       if (show_power_button)
		          {
		          gtk_widget_reparent(power_button, hvbox);
                          gtk_box_reorder_child (GTK_BOX(hvbox), power_button,0);
		          }
		    }
		    if (show_percent_button)
		       gtk_widget_reparent(percent_button, hvbox);
		    if (show_files_button)
		       gtk_widget_reparent(files_button, hvbox);
		 }
		 else
		 {
		    if (show_power_button)
		    {
		       if (show_percent_button && show_files_button)
		       {
		          gtk_widget_reparent(logo_button, hvbox);
                          gtk_box_reorder_child (GTK_BOX(hvbox), logo_button,0);
		          gtk_widget_reparent(power_button, hvbox);
                          gtk_box_reorder_child (GTK_BOX(hvbox), power_button,1);
		       }
		       else
		       {
			  if (show_percent_button || show_files_button)
			  {
		             gtk_widget_reparent(logo_button, hvbox2h);
                             gtk_box_reorder_child (GTK_BOX(hvbox2h), logo_button,0);
		             gtk_widget_reparent(power_button, hvbox2h);
                             gtk_box_reorder_child (GTK_BOX(hvbox2h), power_button,1);
			  }
			  else
			  {
		             gtk_widget_reparent(logo_button, hvbox2);
                             gtk_box_reorder_child (GTK_BOX(hvbox2), logo_button,0);
		             gtk_widget_reparent(power_button, hvbox2);
                             gtk_box_reorder_child (GTK_BOX(hvbox2), power_button,1);
			  }

		       }

		       if (show_percent_button)
		          gtk_widget_reparent(percent_button, hvbox2);
		       if (show_files_button)
		          gtk_widget_reparent(files_button, hvbox2);
		    }
		    else
		    {
		       if (show_percent_button && show_files_button)
		       {
		          gtk_widget_reparent(logo_button, hbox);
                          gtk_box_reorder_child (GTK_BOX(hbox), logo_button,0);
		       }
		       else
		       {
			  gtk_widget_reparent(logo_button, hvbox);
                          gtk_box_reorder_child (GTK_BOX(hvbox), logo_button,0);
		       }
		       if (show_percent_button)
		          gtk_widget_reparent(percent_button, hvbox);
		       if (show_files_button)
		          gtk_widget_reparent(files_button, hvbox);
		    }
		 }
	      }
	      else
	      {
	         if (show_percent_button && show_files_button)
		    {
		    gtk_widget_reparent(power_button, hbox);
                    gtk_box_reorder_child (GTK_BOX(hbox), power_button,0);
		    }
		 else
		    {
		    gtk_widget_reparent(power_button, hvbox);
                    gtk_box_reorder_child (GTK_BOX(hvbox), power_button,0);
		    }
	         if (show_percent_button)
		    gtk_widget_reparent(percent_button, hvbox);
		 if (show_files_button)
		    gtk_widget_reparent(files_button, hvbox);
	      }
	   }
	   else
	   {
              if (show_logo_button)
	         gtk_widget_reparent(logo_button, hbox);
              if (show_power_button)
	         gtk_widget_reparent(power_button, hbox);
              if (show_percent_button)
	         gtk_widget_reparent(percent_button, hbox);
              if (show_files_button)
	         gtk_widget_reparent(files_button, hbox);
	   }
	}
}

void
flash_logo()
{
	gint unflash_timeout;

	if (!flashing)
	{
	   if (show_logo_button_little)
	   {
              gtk_widget_hide(logo_button_pixmap1);
	      gtk_widget_show(logo_button_pixmap3);
	   }
	   else
	   {
              gtk_widget_hide(logo_button_pixmap2);
	      gtk_widget_show(logo_button_pixmap4);
	   }

        unflash_timeout = gtk_timeout_add(1000, unflash_logo, NULL);
	}
	else
	   g_print("Still flashing...");
}

gint
unflash_logo(gpointer data)
{
	if (show_logo_button_little)
	{
              gtk_widget_hide(logo_button_pixmap3);
	      gtk_widget_show(logo_button_pixmap1);
	}
	else  
	{
              gtk_widget_hide(logo_button_pixmap4);
	      gtk_widget_show(logo_button_pixmap2);
	}
	return FALSE;
}


void
start_stop_daemon_applet_cb(AppletWidget *widget, gpointer data)
{
	start_stop_daemon_cb();
}

void
button_status_click(AppletWidget *widget, gpointer data)
{
        char *b;

	b = g_strconcat(DX_BinPath(), "/dsgtk &", NULL);
//	if (!daemon_active) show_warning(NULL);
//	else
//	{
           if (system(b) != 0)
              g_print("An error occurred executing dsgtk!\n");
//	}
	free(b);
}

void
button_files_click(AppletWidget *widget, gpointer data)
{
        char *b;

	b = g_strconcat(DX_BinPath(), "/darxite-control &", NULL);
        if (system(b) != 0)
           g_print("An error ocurred executing darxite-control!\n");
	free(b);
}

void get_data (gpointer data, gint source, GdkInputCondition condition)
{
        char buffer[512];
	gint timeout = 10;
	gint code = -1;
	gint rc;
	gchar *line;

	//And here we go..	
	rc = DX_GetResponse(fd, buffer, sizeof(buffer) - 1, timeout);

#ifdef DEBUG_MESSAGES
	g_print("DX_GetResponse: rc = %i\n", rc);
#endif

#ifdef EXTRA_DEBUG_MESSAGES
        g_print("%s", buffer);
#endif

	if ((rc == DX_LIB_TIMEOUT) || (rc == DX_LIB_ERROR))
	   return;
	else if (rc == DX_LIB_DISCONNECTED)
	   DisconnectClient();

        line = strtok(buffer, "\n");
        while (line)
        {

	code = 0;
	sscanf(line, "%i", &code);
	if (code == DX_FILE_COUNT)
	{
	   gint transfer_size;
	   gint total_size;
	   gint transfer_count;
	   gint total_count;
	   gint percent;

	   line += 4;
	   DX_ParseFileCount(line, &transfer_size, &total_size,
	   					&transfer_count, &total_count);

	   if (show_percent_button)
	   {
	      if (total_count)
	      {
                 if (total_size > 0)
                 {
                    percent = (transfer_size*100)/total_size;
                 }
		 else
		 {
                    percent = 100;
                 }
                 if (inverse_percent)
                    percent = 100 - percent;
                 sprintf(buffer, "%i%%", percent);
	      }
	      else
                 sprintf(buffer, "ok");

	      if (connected)
	         gtk_label_set(GTK_LABEL(percent_button_label), buffer);
	   }
	   if (show_files_button && connected)
	   {
	      sprintf(buffer, "%i/%i", transfer_count, total_count);
	      gtk_label_set(GTK_LABEL(files_button_label), buffer);
	   }

	}
	else if (code == DX_EXIT_EVENT)
	{
#ifdef DEBUG_MESSAGES
	   g_print("Received Event Code %i - EXIT Event!\n", code);
	   g_print("%s\n", line);
#endif
	   DisconnectClient();
	}
	else if (code == DX_OK)
	{
#ifdef DEBUG_MESSAGES
        g_print("OK: %s\n", line);
#endif
	}
	else if (code == DX_CONFIG_RELOADED)
	{
	   DX_ReadConfigFiles();
#ifdef DEBUG_MESSAGES
	   g_print("Received Event Code %i - Configuration has been reloaded!\n", code);
#endif
	}

        line = strtok(NULL, "\n");
	}
}

gint
file_status_cb(gpointer pointer_data)
{
	if (FALSE)
	   SendToDaemon("FastFileStatus\n");

        return TRUE;
}
