/* gnome-napster, a GNOME Napster client.
 * Copyright (C) 1999 Evan Martin <eeyem@u.washington.edu>
 */
#ifndef LNAP_H
#define LNAP_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define NAP_SEARCHHOST_DEF "server.napster.com"
#define NAP_SEARCHPORT 8875
#define NAP_VER "\"v2.0 BETA 3\""
#define NAP_getbesthost_step 5

typedef void (*statusfunc)(char *text, void *d);

#define NM_ERROR 0
#define NM_LOGIN 2
#define NM_LOGINRESP 3
#define NM_NEWUSERLOGIN 6
#define NM_NEWUSER 7 
#define NM_NEWUSER_SUCCESS 8
#define NM_NEWUSER_EXISTS 9
#define NM_NEWUSER_INVALIDNICK 10
#define NM_SEARCH_REQUEST 200
#define NM_SEARCH_RESULT 201
#define NM_SEARCH_COMPLETE 202
#define NM_FILEINFO_REQUEST 203
#define NM_FILEINFO_RESULT 204
#define NM_BROWSE_NOTFOUND 210
#define NM_BROWSE_REQUEST 211
#define NM_BROWSE_RESULT 212
#define NM_BROWSE_COMPLETE 213
#define NM_FILECOUNT 214
#define NM_USERDOESNTEXIST 404
#define NM_REMOTEQUEUEFULL 620
#define NM_SYSMSG 621

typedef struct {
	unsigned short len;
	unsigned short msg;
	char txt[1];
} snap_packet;

typedef enum {
	NAP_CONNTYPE_UNKNOWN,
	NAP_CONNTYPE_14_4,
	NAP_CONNTYPE_28_8,
	NAP_CONNTYPE_33_6,
	NAP_CONNTYPE_57_6,
	NAP_CONNTYPE_ISDN_64K,
	NAP_CONNTYPE_ISDN_128K,
	NAP_CONNTYPE_CABLE,
	NAP_CONNTYPE_DSL,
	NAP_CONNTYPE_T1,
	NAP_CONNTYPE_T3_PLUS,
	NAP_CONNTYPE_COUNT
} enap_conntype;

extern void nap_setstatusfunc(statusfunc s, void* d);
extern void nap_getstatusfunc(statusfunc *s, void** d);
extern void nap_status(char *text);

extern int nap_str_to_sockaddr_in(char *text, struct sockaddr_in *host);
extern enap_conntype nap_str_to_conntype(char *ct);

extern int nap_getbesthost(char *hostbuf, char *serv);
extern int nap_bindlocal(int port);
extern int nap_connect(struct sockaddr_in *host);
extern int nap_sendlogin(char *user, char *pass, int port, enap_conntype conntype);
extern int nap_sendnewuser(char *user);
extern int nap_sendnewuserlogin(char *user, char *pass, int port, enap_conntype conntype,
		char *email);
extern void nap_logout(void);

extern snap_packet* nap_readpacket(int sock);
extern snap_packet* nap_readpacket_nonblock(int sock);
extern int nap_sendpacket(int sock, short int msg, short int len, char *txt);
extern int nap_sendpacketf(int sock, short int msg, char *txt, ...);
extern void nap_dumppacket(snap_packet *p);

int nap_socknap, nap_socklocal;

extern char* nap_conntypes[];

/* byte order conversion:
 * napster uses x86 byte order, so we need to convert
 * only on big endian platforms. */
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define nap_naptohs(x) (x)
#define nap_htonaps(x) (x)
#define nap_naptohl(x) (x)
#define nap_htonapl(x) (x)
#elif __BYTE_ORDER == __BIG_ENDIAN
#define nap_swaps(x) ( ((x&0xFF)<<8) | (x>>8) )
#define nap_swapl(x) ( ((x&0xFF)<<24) | ((x&0xFF00)<<8) | ((x&0xFF0000)>>8) | (x>>24) )
#define nap_naptohs(x) nap_swaps(x)
#define nap_htonaps(x) nap_swaps(x)
#define nap_naptohl(x) nap_swapl(x)
#define nap_htonapl(x) nap_swapl(x)
#elif
#error Unknown byte order!?
#endif /* __BYTE_ORDER */

#endif /* LNAP_H */
