/*
 *  Copyright (C) 1999 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _FILE_LIST_H
#define _FILE_LIST_H

#include "gtm.h"

void file_list_menu_popup_set_state (GtkCList *file_list);

GtkWidget *file_list_create (void);

void file_list_set_row_state (GtkCList *file_list, gint row, DlState state);

void file_list_set_row_statistics (GtkCList *file_list, gint row,
                                   FileData *file_data);

gint file_list_find_url (GtkCList *file_list, gchar *url);

gboolean file_list_add (GtkCList *file_list, FileData *file_data);

void file_list_remove_selection (GtkCList *file_list);

void file_list_remove_file (GtkCList *file_list, FileData *file_data);

void file_list_load_data (GtkCList *file_list);

void file_list_func_on_selection (GtkCList *file_list,
                                  void (*func) (FileData *file_data));

void file_list_start_auto_downloads (GtkCList *file_list);

void file_list_select_all (GtkCList *file_list);

void file_list_unselect_all (GtkCList *file_list);

#endif /* _FILE_LIST_H */
