#ifndef __IGNORE_H
#define __IGNORE_H

typedef struct
{
    gchar *nick;
    gint timeleft;
    gint level;
}
AUTOIGNORE_REC;

extern GList *ignores;

void ignore_init(void);
void ignore_deinit(void);

/* Autoignore nick */
void autoignore_add(SERVER_REC *server, gint type, gchar *nick);
/* Remove autoignore */
gboolean autoignore_remove(SERVER_REC *server, gchar *mask, gchar *level);

/* Add ignore */
LIST_REC *ignore_add(gchar *mask, gchar *level);
/* Remove ignore */
LIST_REC *ignore_remove_rec(LIST_REC *rec, gchar *level);
LIST_REC *ignore_remove(gchar *mask, gchar *level);

/* Check if nick is in ignore list */
gboolean ignore_check(SERVER_REC *server, gchar *nick, gchar *host, gint type);

#endif
