/*
 setup-ircnets.c : Irssi settings

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

GList *ircnets; /* list of available ircnets */

static IRCNET_REC *ircnet_add(proplist_t prop)
{
    IRCNET_REC *rec;
    gchar *name, *nick, *username, *realname;

    g_return_val_if_fail(prop != NULL, NULL);

    name = config_get_str(prop, "name", NULL);
    if (name == NULL) return NULL;

    nick = config_get_str(prop, "nick", NULL);
    username = config_get_str(prop, "username", NULL);
    realname = config_get_str(prop, "realname", NULL);

    rec = g_new0(IRCNET_REC, 1);
    rec->max_kicks = config_get_int(prop, "max_kicks", 4);
    rec->max_msgs = config_get_int(prop, "max_msgs", 3);
    rec->max_modes = config_get_int(prop, "max_modes", 3);

    rec->name = g_strdup(name);
    rec->nick = nick == NULL ? NULL : g_strdup(nick);
    rec->username = username == NULL ? NULL : g_strdup(username);
    rec->realname = realname == NULL ? NULL : g_strdup(realname);

    ircnets = g_list_append(ircnets, rec);
    return rec;
}

void setup_ircnets_init(void)
{
    proplist_t iprop, pvalue;
    gint num, max;

    source_host_ok = FALSE;

    /* read ircnets */
    iprop = config_get_prop(cprop, "ircnets");
    max = iprop == NULL ? 0 : PLGetNumberOfElements(iprop);
    for (num = 0; num < max; num++)
    {
	pvalue = PLGetArrayElement(iprop, num);
        ircnet_add(pvalue);
    }
}

void setup_ircnets_deinit(void)
{
    while (ircnets != NULL)
    {
        IRCNET_REC *rec = ircnets->data;

        ircnets = g_list_remove(ircnets, rec);

        g_free(rec->name);
        if (rec->nick != NULL) g_free(rec->nick);
        if (rec->username != NULL) g_free(rec->username);
        if (rec->realname != NULL) g_free(rec->realname);
        g_free(rec);
    }
}
