#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Vendor.h>
#include <X11/extensions/shape.h>
#include <stdio.h>
#include "PanelP.h"

#define sDisp      XtDisplay(pw)
#define sScreen    XtScreen(pw)
#define sRoot      XRootWindowOfScreen(XtScreen(pw))
#define sWidth     pw->core.width
#define sHeight    pw->core.height
#define sPixmap    pw->panel.pixmap
#define sAttr      pw->panel.attr
#define sLabel     pw->panel.label_pixmap
#define sMask      pw->panel.mask

#define offset(field) XtOffsetOf(PanelRec, field)
static XtResource resources[] = {
  { XtNpanelPixmapData, XtCPanelPixmapData, XtRPointer, sizeof(XtPointer),
            offset(panel.pixmap_data), XtRPointer, NULL },
  { XtNlabelPixmap, XtCLabelPixmap, XtRPixmap, sizeof(Pixmap),
            offset(panel.label_pixmap), XtRImmediate, (XtPointer) 0 },
  { XtNmask, XtCMask, XtRPointer, sizeof(XtPointer),
            offset(panel.mask), XtRPointer, NULL },
};
#undef offset

static void Initialize();
static void Resize();
static Boolean SetValues();
static void Realize();
static void Destroy();
static XtGeometryResult QueryGeometry();

static char defaultTranslation[] = "";
static XtActionsRec actions[] = {{NULL, NULL}};

PanelClassRec panelClassRec = {
  {
  /* superclass             */ (WidgetClass) &compositeClassRec,
  /* class_name             */ "Panel",
  /* widget_size            */ sizeof(PanelRec),
  /* class_initialize       */ NULL,
  /* class_part_initialize  */ NULL,
  /* class_inited           */ FALSE,
  /* initialize             */ Initialize,
  /* initialize_hook        */ NULL,
  /* realize                 XtInheritRealize, */
  /* realize                */ Realize,
  /* actions                */ actions,
  /* num_actions            */ XtNumber(actions),
  /* resources              */ resources,
  /* num_resourece          */ XtNumber(resources),
  /* xrm_class              */ NULLQUARK,
  /* compress_motion        */ TRUE,
  /* compress_exposure      */ TRUE,
  /* compress_enterleave    */ TRUE,
  /* visible_interest       */ FALSE,
  /* destroy                */ Destroy,
  /* resize                 */ Resize,
  /* expose                 */ NULL,
  /* set_values             */ SetValues,
  /* set_values_hook        */ NULL,
  /* set_values_almoset     */ XtInheritSetValuesAlmost,
  /* get_values_hook        */ NULL,
  /* accept_focus           */ NULL,
  /* version                */ XtVersion,
  /* callback_private       */ NULL,
  /* tm_table               */ defaultTranslation,
  /* query_geometry         */ QueryGeometry,
  /* display_accelator      */ XtInheritDisplayAccelerator,
  /* extention              */ NULL
  },{
  XtInheritGeometryManager,
  XtInheritChangeManaged,
  XtInheritInsertChild,
  XtInheritDeleteChild,
  NULL
  },{
  /* foo                    */ 0
  }
};
WidgetClass panelWidgetClass = (WidgetClass)&panelClassRec;

static void
Initialize(Widget wreq, Widget wnew)
{
        PanelWidget pw = (PanelWidget) wnew;
        Pixmap Mask;
        int rst;

        sAttr.valuemask = XpmReturnInfos 
                        | XpmReturnAllocPixels
                        | XpmReturnExtensions;
        rst = XpmCreatePixmapFromData(sDisp, sRoot, pw->panel.pixmap_data, 
                            &sPixmap, &Mask, &sAttr);
        if (rst != 0) XpmError(rst);
        if (Mask) XFreePixmap(sDisp, Mask);

        if (sWidth == 0) {
                sWidth = sAttr.width;
        }
        if (sHeight == 0) {
                sHeight = sAttr.height;
        }
        if (sLabel) {
                XCopyArea(sDisp, sLabel, sPixmap,
                          DefaultGCOfScreen(sScreen),
                          0, 0, 64, 24, 121, 5);
        }
        XtVaSetValues((Widget)pw, XtNbackgroundPixmap, sPixmap, NULL);
}

static void
SetLoadPixmap(Widget w)
{
        PanelWidget pw = (PanelWidget) w;
        Pixmap Mask;
        Colormap cmap;
        int rst;


        cmap=DefaultColormapOfScreen(sScreen);

        if (sPixmap)
                XFreePixmap(sDisp, sPixmap);
        XFreeColors(sDisp, cmap,
                    sAttr.alloc_pixels,
                    sAttr.nalloc_pixels, 0);
        XpmFreeAttributes(&sAttr);

        sAttr.valuemask = XpmReturnInfos 
                        | XpmReturnAllocPixels
                        | XpmReturnExtensions;
        rst = XpmCreatePixmapFromData(sDisp, sRoot, pw->panel.pixmap_data, 
                            &sPixmap, &Mask, &sAttr);
        if (rst != 0) XpmError(rst);
        if (Mask) XFreePixmap(sDisp, Mask);

        if (sLabel) {
                XCopyArea(sDisp, sLabel, sPixmap,
                          DefaultGCOfScreen(sScreen),
                          0, 0, 64, 24, 121, 5);
        }
        XtVaSetValues((Widget)pw, XtNbackgroundPixmap, sPixmap, NULL);
}


static Boolean
SetValues(Widget wcur, Widget wreq, Widget wnew)
{
        PanelWidget cur = (PanelWidget) wcur;
        PanelWidget new = (PanelWidget) wnew;
        Boolean redraw = False;

        if (cur->panel.label_pixmap != new->panel.label_pixmap) {
                SetLoadPixmap((Widget)new);
        }

        return redraw;
}

static void
Realize(Widget w, XtValueMask *v, XSetWindowAttributes *a)
{
	PanelWidget pw = (PanelWidget) w;
	Widget parent;

	panelClassRec.core_class.superclass->core_class.realize(w, v, a);

	if (sMask != 0) {
                for (parent = w; XtParent(parent); parent = XtParent(parent))
                        ;
                XShapeCombineMask(XtDisplay(pw), XtWindow(parent),
                                  ShapeBounding, 0, 0, sMask, ShapeSet);
                XShapeCombineMask(XtDisplay(pw), XtWindow(pw),
                                ShapeBounding, 0, 0, sMask, ShapeSet);
        }
}

static void
Destroy(Widget w)
{
        PanelWidget pw = (PanelWidget) w;
        Colormap cmap;

        cmap=DefaultColormapOfScreen(sScreen);

        if (sPixmap)
                XFreePixmap(sDisp, sPixmap);
        XFreeColors(sDisp, cmap,
                    sAttr.alloc_pixels,
                    sAttr.nalloc_pixels, 0);
        XpmFreeAttributes(&sAttr);
}

static void
Resize(Widget w)
{
        PanelWidget pw = (PanelWidget) w;

        return;
}

static XtGeometryResult
QueryGeometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
        PanelWidget pw = (PanelWidget) w;

        answer->request_mode = CWWidth | CWHeight;
        answer->width  = sWidth;
        answer->height = sHeight;

        return XtGeometryAlmost;
}

