/*
  This code is based on:

	   Encode or decode file as MIME base64 (RFC 1341)

			    by John Walker
		       http://www.fourmilab.ch/

		This program is in the public domain.

*/

#define REVDATE "11th August 1997"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

typedef unsigned char byte;	      /* Byte type */

/*  ENCODE  --	Encode binary file into base64.  */

void
Base64Encode(char *dst, char *src, size_t max)
{
    int i, n=3;
    static byte dtable[64];

    if (!dtable[63]) {
	/*	Fill dtable with character encodings.  */

	for (i = 0; i < 26; i++) {
	    dtable[i] = 'A' + i;
	    dtable[26 + i] = 'a' + i;
	}
	for (i = 0; i < 10; i++) {
	    dtable[52 + i] = '0' + i;
	}
	dtable[62] = '+';
	dtable[63] = '/';
    }

    while (max > 0 && n > 2 && *src) {
	byte igroup[4]={0};

	strncpy(igroup, src, 3);
	n = strlen(igroup);
	dst[0] = dtable[igroup[0] >> 2];
	dst[1] = dtable[((igroup[0] & 3) << 4) | (igroup[1] >> 4)];
	dst[2] = dtable[((igroup[1] & 0xF) << 2) | (igroup[2] >> 6)];
	dst[3] = dtable[igroup[2] & 0x3F];

	if (n < 3) {
	    dst[3] = '=';
	    if (n < 2) {
		dst[2] = '=';
		dst --;
		max ++;
	    }
	}
	src += 3;
	dst += 4;
	max -= 4;
    }
    *dst = '\0';
}

/*  DECODE  --	Decode base64.	*/

void
Base64Decode(char *dst, char *src, size_t max)
{
    int i;
    static byte dtable[256];

    if (!dtable['/']) {
	for (i = 0; i < 255; i++) {
	    dtable[i] = 0x80;
	}
	for (i = 'A'; i <= 'Z'; i++) {
	    dtable[i] = 0 + (i - 'A');
	}
	for (i = 'a'; i <= 'z'; i++) {
	    dtable[i] = 26 + (i - 'a');
	}
	for (i = '0'; i <= '9'; i++) {
	    dtable[i] = 52 + (i - '0');
	}
	dtable['+'] = 62;
	dtable['/'] = 63;
	dtable['='] = 0;
    }

    /*CONSTANTCONDITION*/
    while (max > 0 && *src > ' ') {
	*dst ++ = (dtable[src[0]] << 2) | (dtable[src[1]] >> 4);
	if (src[2] != '=') {
	    *dst ++ = (dtable[src[1]] << 4) | (dtable[src[2]] >> 2);
	    if (src[3] != '=')
		*dst ++ = (dtable[src[2]] << 6) | dtable[src[3]];
	    else break;
	} else break;
	src += 4;
	max -= 4;
    }
    *dst = '\0';
}

#ifdef	DEBUG_BASE64

/*  Main program  */

int main(int argc, char *argv[])
{
    char en[256], de[256];

    printf("<%s>", argv[1]);
    Base64Encode(en, argv[1], sizeof(en));
    printf("-><%s>", en);
    Base64Decode(de, en, sizeof(de));
    printf("-><%s>\n", de);
    return 0;
}

#endif
