#ifndef	_PPXP_IP_IPSUPPORT_H
#define	_PPXP_IP_IPSUPPORT_H

#define	IPRT_DEL	0
#define	IPRT_ADD	1

#define	IPRT_NET	0
#define	IPRT_HOST	2
#define	IPRT_KILL	4

#define	IPRT_ADD_NET	(IPRT_ADD)
#define	IPRT_ADD_HOST	(IPRT_ADD|IPRT_HOST)
#define	IPRT_DEL_NET	(IPRT_DEL)
#define	IPRT_DEL_HOST	(IPRT_DEL|IPRT_HOST)

#define	IPFF_AUTO	0x01
#define	IPFF_EXPIRED	0x02
#define	IPFF_USED	0x04
#define	IPFF_WILLEXPIRE	0x08

#define	IPFF_ICMPID	0x10
#define	IPFF_REBUILD	0x80

#define	MTU_MAX		4096
#define	MTU_DOWNFLAG	MTU_MAX

/*
 * BSD style IP, TCP, UDP, ICMP header structure
 */

struct bsd_ipv4_s {
#if BYTE_ORDER == LITTLE_ENDIAN
    u_int8_t	ip_hl:4,
		ip_v:4;
#elif BYTE_ORDER == BIG_ENDIAN
    u_int8_t	ip_v:4,
		ip_hl:4;
#else
#error	"Please specify byteorder"
#endif
#ifndef	IPVERSION
#define IPVERSION	4
#endif
    u_int8_t	ip_tos;
    u_int16_t	ip_len;
    u_int16_t	ip_id;
    u_int16_t	ip_off;
    u_int8_t	ip_ttl;
    u_int8_t	ip_p;
    u_int16_t	ip_sum;
    struct in_addr	ip_src, ip_dst;
};

struct bsd_tcp_s {
    u_int16_t	th_sport;
    u_int16_t	th_dport;
    u_int32_t	th_seq;
    u_int32_t	th_ack;
#if BYTE_ORDER == LITTLE_ENDIAN
    u_int8_t	th_x2:4,
		th_off:4;
#elif BYTE_ORDER == BIG_ENDIAN
    u_int8_t	th_off:4,
		th_x2:4;
#else
#error	"Please specify byteorder"
#endif
    u_int8_t	th_flags;
#ifndef	TH_FIN
#define	TH_FIN	0x01
#define	TH_SYN	0x02
#define	TH_RST	0x04
#define	TH_PUSH	0x08
#define	TH_ACK	0x10
#define	TH_URG	0x20
#endif
    u_int16_t	th_win;
    u_int16_t	th_sum;
    u_int16_t	th_urp;
};

struct bsd_udp_s {
    u_int16_t	uh_sport;
    u_int16_t	uh_dport;
    u_int16_t	uh_ulen;
    u_int16_t	uh_sum;
};

struct bsd_icmp_s {
    u_int8_t	icmp_type;
#ifndef	ICMP_ECHO
#define	ICMP_ECHO	8
#endif
    u_int8_t	icmp_code;		/* type sub code */
    u_int16_t	icmp_cksum;		/* ones complement cksum of struct */
    union {
	struct in_addr	ih_gwaddr;	/* ICMP_REDIRECT */
	struct ih_idseq {
	    u_int16_t	icd_id;
	    u_int16_t	icd_seq;
	} ih_idseq;
    } icmp_hun;
#define	icmp_gwaddr	icmp_hun.ih_gwaddr
#define	icmp_id		icmp_hun.ih_idseq.icd_id
#define	icmp_seq	icmp_hun.ih_idseq.icd_seq
};

typedef	struct bsd_ipv4_s	ipv4_hdr;
typedef	struct bsd_tcp_s	tcp_hdr;
typedef	struct bsd_udp_s	udp_hdr;
typedef	struct bsd_icmp_s	icmp_hdr;

static inline u_int16_t
ip_calc_csum(ipv4_hdr *iphp)
{
#ifdef	IP_CALC_CSUM
    return(IP_CALC_CSUM(iphp));
#else
    u_int16_t *cp;
    u_int32_t sum;
    int hlen;

    hlen = iphp->ip_hl << 2;
    cp = (u_int16_t *)iphp;
    for (sum = 0; hlen > 0; hlen -= 2) sum += *cp++;
    sum = (sum & 0xffff) + (sum >> 16);
    sum = (sum & 0xffff) + (sum >> 16);
    return((u_int16_t)~sum);
#endif
}

static inline void
ip_check_sum(ipv4_hdr *iphp)
{
    iphp->ip_sum = 0;
    iphp->ip_sum = ip_calc_csum(iphp);
/*
#ifdef	IP_CALC_CSUM
    iphp->ip_sum = 0;
    iphp->ip_sum = IP_CALC_CSUM(iphp);
#else
    u_int16_t *cp;
    u_int32_t sum;
    int hlen;

    hlen = iphp->ip_hl << 2;
    iphp->ip_sum = 0;
    cp = (u_int16_t *)iphp;
    for (sum = 0; hlen > 0; hlen -= 2) sum += *cp++;
    sum = (sum & 0xffff) + (sum >> 16);
    sum = (sum & 0xffff) + (sum >> 16);
    iphp->ip_sum = ~sum;
#endif
*/
}

static inline u_int16_t
tcpudp_check_sum(ipv4_hdr *iphp, u_int8_t proto, int len)
{
    u_int16_t *cp;
    u_int32_t sum=0;
    int i;

#if 0
    sum = csum_tcpudp_magic(iphp->ip_src.s_addr, iphp->ip_dst.s_addr,
			    len, proto, base);
#endif

    cp = (u_int16_t *)&(iphp->ip_src.s_addr);
    for (i = 0; i < (int)sizeof(u_int32_t); i ++) sum += *cp ++;
    sum += htons(proto);
    sum += htons(len);

    cp = (u_int16_t *)((u_char *)iphp + (iphp->ip_hl << 2));
    if (len & 1) {
	len &= ~1;
	sum += (*((u_char *)cp + len) & 0xff);
    }
    for (i = 0; i < len; i += 2) sum += *cp++;
    sum = (sum & 0xffff) + (sum >> 16);
    sum = (sum & 0xffff) + (sum >> 16);
    return((u_int16_t)~sum);
}

extern void IpInit();
extern void VjInit();
extern int SysIpInit();
extern int SysIpSetRoute();
extern int SysIpConfig(u_int32_t, u_int32_t, u_int32_t, u_int16_t,
		       char *);
extern struct rtable_s *SysIpGetRoute();

#endif	/* _PPXP_IP_IPSUPPORT_H */
