#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>

#include <config.h>
#include <support.h>
#include <xcio.h>

#include "option.h"
#include "chat.h"
#include "frame.h"
#include "console.h"
#include "log.h"
#include "phase.h"
#include "dev/device.h"

static struct downlist_s {
    struct downlist_s *next;
    const char *name;
    void (*down)();
} *downHead;

extern void AuthInit();
extern void NetInit();
extern void CbcpInit();

phase_t phaseShift;

static phasestate_t initPhase=PS_DEAD;

static void DownNext();

extern void NetworkStart();
extern int devFd;

void
CloseDevice()
{
    struct downlist_s *dlp;

/*    pppInfo.phase = initPhase;*/
    while (downHead) {
	dlp = downHead;
	downHead = downHead->next;
	dlp->down(FALSE);
	Free(dlp);
    }
    RemoveSelectFdp(&devFd);
    if (devFd >= 0) {
	extern fd_set orgWriteFds;
	int fd=devFd;

	devFd = -1;
	FD_CLR(fd, &orgWriteFds);
	if (DevClose) DevClose(fd);
	else close(fd);
    }
    AccountLogWrite(FALSE);
    LastLogWrite(FALSE);
    TimerReset();
}

void
StartDevice()
{
    AccountLogWrite(TRUE);
    NewSelectLink("DEVICE", &devFd, DevRead, DevClose, TRUE, TRUE);
    LcpMode((pppInfo.l_stat & LSTAT_TTY) ? RUN_PASSIVE: pppOpt.mode);
#ifndef trash_old
    if (!(pppInfo.l_stat & LSTAT_TTY)
	&& ChatStart(pppOpt.chat) != CHAT_DONE) {
	pppInfo.l_stat = LSTAT_CHAT;
    } else {
	pppInfo.l_stat = LSTAT_TTY;
	PhaseUp();
    }
#endif
}

static void
DeadInit()
{
    CloseDevice();
    pppInfo.l_stat &= ~LSTAT_PPP;
    if (pppInfo.m_flag & MFLAG_AUTO) {
	FrameStartLayer(NBO_PROTO_NLPMASK);
    }
/*    IpUp();*/
}

static void
CpInit()
{
    FrameStartLayer(NBO_PROTO_LLPMASK);
/*
    CcpInit();
    IpcpInit();
*/
}

static struct phase_s {
    const char *name;
    void (*init)();
    phasestate_t up;
    phasestate_t down;
} phaseInfo[]={
    {"Dead", DeadInit, PS_ESTABLISH, PS_DEAD},
    {"Establish", CpInit, PS_AUTHENTICATE, PS_DEAD},
    {"Authenticate", AuthInit, PS_CALLBACK, PS_TERMINATE},
    {"Callback", CbcpInit, PS_NETWORK, PS_TERMINATE},
    {"Network", NetworkStart, PS_NETWORK, PS_TERMINATE},
    {"Terminate", DownNext, PS_DEAD, PS_DEAD}
};

void
SetPPxPEnvs()
{
    extern char *ifName;

    setenv("PPXP_PHASE", phaseInfo[pppInfo.phase].name, 1);
    if (pppOpt.name) setenv("PPXP_NAME", pppOpt.name, 1);
    setenv("PPXP_IF", ifName, 1);
}

static void
NewPhase()
{
    if (ISLOG(LOG_PHASE))
	Logf(LOG_PHASE, "%s\n", phaseInfo[pppInfo.phase].name);
    SetPPxPEnvs();
    if (phaseInfo[pppInfo.phase].init) phaseInfo[pppInfo.phase].init();
    ConsoleUpdate(TRUE);
}

static void
DownNext()
{
    struct downlist_s *dlp;

    while (downHead) {
	dlp = downHead;
	downHead = downHead->next;
	dlp->down(devFd < 0 ? FALSE: TRUE);
	Free(dlp);
    }
    if (devFd < 0) {
	pppInfo.phase = initPhase;
	NewPhase();
    }
}

void
PhaseUp()
{
    phaseShift = PHASE_KEEP;
    if (ISLOG(LOG_PHASE))
	Logf(LOG_PHASE, "%s =UP=> ", phaseInfo[pppInfo.phase].name);
    pppInfo.phase = phaseInfo[pppInfo.phase].up;
    NewPhase();
}

void
PhaseDown()
{
    phaseShift = PHASE_KEEP;
    if (ISLOG(LOG_PHASE))
	Logf(LOG_PHASE, "%s =DOWN=> ", phaseInfo[pppInfo.phase].name);
    pppInfo.phase = phaseInfo[pppInfo.phase].down;
    NewPhase();
}

int
CmdAuto(int argc, char *argv[])
{
    if (argc > 1 && !strcasecmp(argv[1], "off")) {
	pppInfo.m_flag &= ~MFLAG_AUTO;
    } else {
	pppInfo.m_flag |= MFLAG_AUTO;
    }
    if (pppInfo.phase == PS_DEAD) {
	pppInfo.phase = initPhase;
	phaseInfo[initPhase].init();
	ConsoleUpdate(TRUE);
    }
    return(0);
}

void
PhaseQuit()
{
    extern void AllExit();
    char *argv[]={"a", "off"};

    CmdAuto(2, argv);
    initPhase = PS_DEAD;
    phaseInfo[PS_TERMINATE].up = phaseInfo[PS_TERMINATE].down
	= PS_DEAD;
    phaseInfo[PS_DEAD].init = AllExit;
}

int
RegisterDownPhase(const char *name, void (*down)())
{
    struct downlist_s *dlp;

    dlp = TALLOC(struct downlist_s);
    dlp->down = down;
    dlp->name = name;
    dlp->next = downHead;
    downHead = dlp;
    ConsoleUpdate(TRUE);
    return(0);
}

int
CmdCpDown(int argc, char *argv[])
{
    struct downlist_s *dlp, *dlp0=NULL;

    if (argc < 2 || pppInfo.phase < PS_NETWORK) return(-1);
    dlp = downHead;
    while (dlp) {
	if (!strcasecmp(dlp->name, argv[1])) {
	    if (dlp0) dlp0->next = dlp->next;
	    else downHead = dlp->next;
	    dlp->down(devFd < 0 ? FALSE: TRUE);
	    Free(dlp);
	    return(0);
	}
	dlp0 = dlp;
	dlp = dlp->next;
    }
    return(-1);
}

/*
 * Local variables:
 * End:
*/
