/*  VER 036   TAB P   $Id: statistics.c,v 1.13 1999/04/02 03:56:59 src Exp $
 *
 *  an NNTP news exchange client
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: statistics.c,v $
 *  Revision 1.13  1999/04/02 03:56:59  src
 *  Patch for proper English by Uli Zappe
 *
 *  Revision 1.12  1999/03/16 17:35:38  src
 *  Version 1.4pre
 *
 *  Revision 1.11  1999/03/16 08:03:31  src
 *  Renamed lock() to do_lock()
 *
 *  Revision 1.10  1998/11/22 08:00:08  src
 *  Option --no-queue
 *
 *  Revision 1.9  1998/11/21 19:14:24  src
 *  Added --filter option
 *
 *  Revision 1.8  1998/09/13 16:52:09  src
 *  Lock for statistics file
 *
 *  Revision 1.7  1998/09/09 07:32:14  src
 *  Version 1.1
 *
 *  Revision 1.6  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.5  1998/07/12 09:39:30  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "statistics.h"
#include "news.h"

/*
 *  neither lies nor damned lies
 */
void        
statistics(time_t starttime,time_t endtime)
{
    FILE *f;
    long total;

    progtitle("statistics");

    total = endtime-starttime;

    if (duplicate_articles || missing_articles || failed_articles) {
	log_msg(L_INFO,"posting errors: %d duplicate, %d missing, %d failed article%s",
			   duplicate_articles, 
			   missing_articles, 
			   failed_articles,
			   failed_articles==1 ? "":"s");
    }
    if (bounced_articles) {
	log_msg(L_INFO,"bounced %d article%s",
			   bounced_articles, bounced_articles==1 ? "":"s");
    }
    if (unavailable_groups) {
	log_msg(L_INFO,"%d group%s not available from this server",
			   unavailable_groups, unavailable_groups==1 ? " was":"s were");
    }
    if (unseen_groups) {
	log_msg(L_INFO,"fetched %d group%s never seen before",
			   unseen_groups, unseen_groups==1 ? "":"s");
    }
    if (already_articles || history_articles || (filter_articles+fake_articles)) {
	if (mfilter || filter || (fake_articles+filter_articles)) {
	    log_msg(L_INFO,"omitted %ld article%s already in spool, %ld as crosspost%s, %ld filtered",
			   history_articles, history_articles==1 ? "":"s",
			   already_articles, already_articles==1 ? "":"s",
			   fake_articles+filter_articles);
	} else {
	    log_msg(L_INFO,"omitted %ld article%s already in spool, %ld as crosspost%s",
			   history_articles, history_articles==1 ? "":"s",
			   already_articles, already_articles==1 ? "":"s");
	}
    }
    if (fetch_aborted) {
	log_msg(L_INFO,"article fetch aborted");
    }

    /* transfer speed statistics */
    if (gross_bytecount > 0) {
	log_msg(L_INFO,
	"posted %ld, fetched %d article%s in %ld group%s at %ld net cps",
			   posted_articles,
			   fetched_articles, fetched_articles==1 ? "":"s",
			   fetched_groups, fetched_groups==1 ? "":"s", 
			   net_bytecount / (total==0 ? 1 : total));
    }

    if (statfile) {
	char lockname[PATH_MAX];
	int lock_id;

	/*
	 * lock other newsxes accessing same file
	 */
	progtitle("locking statistics file");
	build_filename(lockname,statfile,LOCK_SUFFIX,NULL,NULL);
	lock_id = do_lock("",lockname,0);

	if (!(f = fopen(statfile,"a"))) {
	    log_msg(L_ERRno,"can't append to \"%s\"",statfile);
	    unlock_one(lock_id);
	    return;
	}

	if (ftell(f) == 0L) {
	    fprintf(f,
	    "# post fetc dupl alre hist miss grps ua-g us-g grossbyt netbytes totaltim fail\n");
	}
	fprintf(f,     
	    "T %s %s",
	       fetch_aborted ? "Ab":"OK", 
		  asctime(localtime(&starttime))+4); /* skip "Day " */
	fprintf(f,
   "N %4d %4ld %4d %4ld %4ld %4d %4ld %4ld %4ld %8ld %8ld %8ld %4d %4d\n",
      posted_articles,
	   fetched_articles,
		duplicate_articles,
		     already_articles,
			  history_articles,
			       missing_articles,
				    fetched_groups,
					 unavailable_groups,
					      unseen_groups,
						   gross_bytecount,
							net_bytecount,
							     total,          
						       /* new in version 0.7 */
							     failed_articles,
							     bounced_articles);
	if (mfilter || filter || filter_articles)
	    fprintf(f,"F %4ld\n",
			 filter_articles);
	fclose(f);
	unlock_one(lock_id);
    }
}   


