/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __PREFS_H__
#define __PREFS_H__

/***
 *** Global Variables
 ***/

extern gchar *temp_dir;
extern gchar *data_dir;
extern gchar *download_dir;

extern gchar *grouplist_font;
extern gchar *articlelist_font;
extern gchar *message_body_font;

extern gchar *attribution_line;
extern gchar *external_mailer;
extern gchar *external_editor;

/** The maximum number of sockets allowed across all servers */
extern int max_socket_connections;

/** If true, binary attachments should be saved with the subject
    as a filename instead of using the attachment's real filename */
extern gboolean use_subject_as_filename;

/*** 
 *** Function Prototypes
 ***/

extern void prefs_spawn (void);
extern void prefs_init (void);

#endif /* __PREFS_H__ */
