/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __PAN_STATUS_ITEM__H__
#define __PAN_STATUS_ITEM__H__

#include <glib.h>
#include "pan-callback.h"
#include "pan-object.h"

#define STATUS_ITEM(a) ((StatusItem *)a)

typedef struct _StatusItem StatusItem;
typedef gchar* (*StatusItemDescribeFunc)(const StatusItem*);

struct _StatusItem
{
	/*Parent*/
	PanObject pan_object;

	/*Callbacks*/
	PanCallback* init_steps;     /* obj arg is int 'steps' */
	PanCallback* next_step;      /* obj arg is NULL */
	PanCallback* progress;       /* obj arg is int [0...100] */
	PanCallback* set_activity;   /* obj arg is int */
	PanCallback* status;         /* obj arg is const gchar* (don't free) */
	PanCallback* error;          /* obj arg is const gchar* (don't free) */
	PanCallback* done;           /* obj arg is status int */

	/* virtual functions */
	StatusItemDescribeFunc describe;
};

/* protected */
extern void status_item_constructor (StatusItem*, PanObjectDestructor, StatusItemDescribeFunc);
extern void status_item_destructor (PanObject*);

/* public */
extern StatusItem* status_item_new (StatusItemDescribeFunc);
extern gchar* status_item_describe (const StatusItem*);
extern void status_item_emit_status (StatusItem*, const gchar* fmt, ...);
extern void status_item_emit_error (StatusItem*, const gchar* fmt, ...);
extern void status_item_emit_progress (StatusItem*, gint out_of_100);
extern void status_item_emit_init_steps (StatusItem*, gint steps);
extern void status_item_emit_next_step (StatusItem*);
extern void status_item_emit_activity (StatusItem*, gint n);
extern void status_item_emit_done (StatusItem*, gint status);

extern void status_item_next_step_gfunc (gpointer gdata, gpointer p_status_item);

#endif /* __PAN_STATUS_ITEM__H__ */
