#include <time.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include "npcompose.h"

void NP_Compose::load( int external )
{
   NP_File spool;
   char buffer[ 1024 ];

   if ( external )
      snprintf( buffer, sizeof buffer, "%s/.peruser4-edit", home );
   else
      snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s", home,
                server, group );

   if ( spool.openr( buffer ))
   {
      show_message( spool.get_error());
      return;
   }

   if ( !external )
      if ( spool.seek( offset, SEEK_SET ))
      {
         show_message( spool.get_error());
         return;
      }

   char *line;
   int header = 1;

   gtk_text_freeze( GTK_TEXT( header_widget ));
   gtk_text_freeze( GTK_TEXT( text_widget ));

   if ( !external )
   {
      int len = gtk_text_get_length( GTK_TEXT( header_widget ));
      if ( len > 0 )
      {
         gtk_text_set_point( GTK_TEXT( header_widget ), 0 );
         gtk_text_forward_delete( GTK_TEXT( header_widget ), len );
      }
   }
   
   int len = gtk_text_get_length( GTK_TEXT( text_widget ));
   if ( len > 0 )
   {
      gtk_text_set_point( GTK_TEXT( text_widget ), 0 );
      gtk_text_forward_delete( GTK_TEXT( text_widget ), len );
   }

   while(( line = spool.get_string()) != NULL )
   {
      if ( !strncmp( line, ".\r\n", 3 ))
         break;

      if ( !external && header && !strncmp( line, "\r\n", 2 ))
      {
         header = 0;
         continue;
      }

      if ( !external )
      {
         if ( !strcmp( line, "\r\n" ))
         {
            *line = '\n';
            *( line + 1 ) = '\0';
         }
         else
         {
            strtok( line, "\r\n" );
            strcat( line, "\n" );
         }
      }
      
      if ( !external && header )
         gtk_text_insert( GTK_TEXT( header_widget ), NULL, NULL, NULL, line,
                          strlen( line ));
      else
         gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL, line,
                          strlen( line ));
   }

   spool.close();

   gtk_text_thaw( GTK_TEXT( header_widget ));
   gtk_text_thaw( GTK_TEXT( text_widget ));

   return;
}


void NP_Compose::create_original( int jimmy )
{
   char *subject = "Subject: (no subject)\n";

   create_base( jimmy );

   if (( text = ( char *)realloc( text, strlen( text ) +
                                  strlen( subject ) + 1 )) == NULL )
   {
      perror( "realloc" );
      exit( 1 );
   }

   strcat( text, subject );
   
   return;
}

void NP_Compose::create_base( int jimmy )
{
   char date[ 1024 ], message_id[ 1024 ], path[ 128 ], from[ 1024 ];

   /* date */

   time_t unix_time = time( NULL );
   struct tm *lt = localtime( &unix_time );
   char buffer[ 1024 ];
   strcpy( buffer, asctime( lt ));
   char *wkdy      = strtok( buffer, " " );
   char *month     = strtok( NULL, " " );
   char *day       = strtok( NULL, " " );
   char *hms       = strtok( NULL, " " );
   char *year      = strtok( NULL, "\n" );

   ldiv_t div_result = ldiv( timezone, 3600 );
   long tzhh = div_result.quot;
   div_result = ldiv( div_result.rem, 60 );
   long tzmm = div_result.quot;

   char zone_buf[ 32 ];
   snprintf( zone_buf, sizeof zone_buf, "%c%0.2u%0.2u",
             (( tzhh <= 0 ) ? '+' : '-' ), labs( tzhh ), labs( tzmm ));

   snprintf( date, sizeof date, "Date: %s, %s %s %s %s %s\n",
             wkdy, day, month, year, hms, zone_buf );

   /* From */

   NP_File config;
   snprintf( buffer, sizeof buffer, "%s/.peruser4-config", home );
   if ( config.openr( buffer ))
   {
      show_message( config.get_error() );
      return;
   }

   char *line;
   if (( line = config.get_string()) == NULL )
   {
      show_message( config.get_error() );
      return;
   }

   snprintf( from, sizeof from, "From: %s\n", strtok( line, "\n" ));
   config.close();

   /* Path */

   if ( !jimmy || ( jimmy == 2 ))
   {
      strcpy( buffer, from );
      char *pointer = strchr( buffer, '@' );
      while( !isspace( *pointer ) && *pointer != '<' )
         --pointer;
   
      strtok( pointer, "@" );
      snprintf( path, sizeof path, "Path: %s\n", ++pointer );
   }
   
   /* Message-ID */

   pid_t pid;
   srand( pid = getpid() );

   snprintf( message_id, sizeof message_id,
             "Message-ID: <NewsPeruser-4.0-%x-%x.%x@%s>\n",
             ( long unsigned int)( 100 * rand() * pid ), 
             unix_time, pid, server );

   /* newsgroups */
   char newsgroups[ 1024 ];

   if ( !jimmy && jimmy != 2 )
   {
      snprintf( newsgroups, sizeof newsgroups, "Newsgroups: %s\n", group );
   }
   
   int len = strlen( path ) + strlen( from ) + strlen( date ) +
      strlen( message_id ) + strlen( newsgroups ) + 1;

   if (( text = ( char *)malloc( len )) == NULL )
   {
      perror( "malloc" );
      exit( 1 );
   }

   snprintf( text, len, "%s%s%s%s%s",
             (( jimmy == 1 ) ? "" : path ), message_id,
             ( jimmy ? "" : newsgroups ), from, date );

   return;
}

void NP_Compose::create_follow_up()
{
   create_base( 0 );

   NP_File spool;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s",
             home, server, group );
   if ( spool.openr( buffer ))
   {
      show_message( spool.get_error() );
      return;
   }

   if ( spool.seek( offset, SEEK_SET ))
   {
      show_message( spool.get_error() );
      return;
   }

   char *line, *pointer,
      pre_subject[ 1024 ], pre_id[ 1024 ], pre_refs[ 4096 ], temp[ 6144 ];
   
   int sub_found = 0, refs_found = 0, ids_found = 0;

   do
   {
      if (( line = spool.get_string()) == NULL )
         break;

   LOOP:
      
      if ( !sub_found && !strncasecmp( line, "Subject:", 8 ))
      {
         sub_found = 1;
         pointer = line + 8;

         while( isspace( *pointer ))
            ++pointer;

         strcpy( pre_subject, pointer );
         continue;
      }

      if ( !ids_found && !strncasecmp( line, "Message-ID:", 11 ))
      {
         ids_found = 1;

         pointer = line + 11;
         while( isspace( *pointer ))
            ++pointer;

         strcpy( pre_id, pointer );
         continue;
      }

      if ( !refs_found && !strncasecmp( line, "References:", 11 ))
      {
         refs_found = 1;

         pointer = line + 11;
         while( isspace( *pointer ))
            ++pointer;

         strcpy( pre_refs, pointer );
         
         while(( pointer = spool.get_string()) != NULL && isspace( *pointer ))
         {
            while(( sizeof pre_refs - strlen( pre_refs )) <
                  ( strlen( pointer ) + 2 ))
            {
               pointer = strchr( pre_refs, '\n' ) + 1;
               if ( !( *pointer ))
                  break;

               strcpy( temp, pointer );
               strcpy( pre_refs, temp );
               strcat( pre_refs, " " );
            }

            strcat( pre_refs, pointer );
         }

         if ( line == NULL )
            break;

         goto LOOP;
      }
   }
   while( strncmp( line, ".\r\n", 3 ));

   spool.close();

   pointer = pre_subject;
   if ( !strncasecmp( pre_subject, "Re:", 3 ))
      pointer += 3;

   while( isspace( *pointer ))
      ++pointer;

   char subject[ 1024 ];
   snprintf( subject, sizeof subject, "Subject: Re: %s\n",
             strtok( pointer, "\r\n" ));

   if ( refs_found )
   {
      char *last;
      pointer = strrchr( ( last = pre_refs + strlen( pre_refs ) - 2 ),
                         '\n' ) + 1;
      if (( strlen( pointer ) + strlen( pre_id ) + 1 ) < 1000 )
      {
         *last = ' ';
         *++last = '\0';
      }

      snprintf( temp, sizeof temp, "References: %s%s\n", pre_refs,
                strtok( pre_id, "\r\n" ));
   }
   else
      snprintf( temp, sizeof temp, "References: %s\n",
                strtok( pre_id, "\r\n" ));

   int len = strlen( text ) + strlen( subject ) + strlen( temp ) + 1;
   if (( text = ( char *)realloc( text, len )) == NULL )
   {
      perror( "realloc" );
      exit( 1 );
   }

   strcat( text, subject );
   strcat( text, temp );

   return;
}

void NP_Compose::create_reply()
{
   create_follow_up();

   NP_File spool;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s", home,
             server, group );
   if ( spool.openr( buffer ))
   {
      show_message( spool.get_error() );
      return;
   }

   if ( spool.seek( offset, SEEK_SET ))
   {
      show_message( spool.get_error() );
      return;
   }

   int author = 0, from = 0;
   char *line, source[ 1024 ];

   while(( line = spool.get_string()) != NULL )
   {
      if ( !strncmp( line, "\r\n", 2 ))
         break;

      if ( !from && !author && !strncasecmp( line, "From:", 5 ))
      {
         from = 1;
         strcpy( source, line + 5 );
         continue;
      }

      if ( !author && !strncasecmp( line, "Author:", 7 ))
      {
         author = 1;
         strcpy( source, line + 7 );
         continue;
      }

      if ( !strncasecmp( line, "Reply-To:", 9 ))
      {
         strcpy( source, line + 9 );
         break;
      }
   }

   char *pointer = source;

   if ( line != NULL )
   {
      while( isspace( *pointer ))
         ++pointer;

      char to[ 1024 ];
      snprintf( to, sizeof to, "To: %s", pointer );
      int len = strlen( text ) + strlen( to ) + 1;
      if (( text = ( char *)realloc( text, len )) == NULL )
      {
         perror( "realloc" );
         exit( 1 );
      }

      strcat( text, to );
   }

   spool.close();
   
   return;
}

void NP_Compose::create_jimmy()
{
   create_original( 1 );

   char *to = "To: James Bailie <jazzturk@home.com>\n";

   if (( text = ( char *)realloc( text,
                                  strlen( text ) + strlen( to ) + 1 ))
       == NULL )
   {
      perror( "realloc" );
      exit( 1 );
   }

   strcat( text, to );

   return;
}

void NP_Compose::create_cancel( int cancel )
{
   create_original( 2 );

   NP_File spool;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s", home,
             server, group );
   if ( spool.openr( buffer ))
   {
      show_message( spool.get_error() );
      return;
   }

   if ( spool.seek( offset, SEEK_SET ))
   {
      show_message( spool.get_error() );
      return;
   }

   char *line, *id_pointer = NULL, *group_pointer = NULL;
   int found = 0;
   
   while(( line = spool.get_string()) != NULL )
   {
      if ( !strncasecmp( line, "Message-ID:", 11 ))
      {
         ++found;
         if (( id_pointer = strdup( line + 11 )) == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }
      }
      
      if ( !strncasecmp( line, "Newsgroups:", 11 ))
      {
         ++found;  
         if (( group_pointer = strdup( line + 11 )) == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }
      }

      if ( found == 2 )
         break;
   }

   spool.close();

   if ( line != NULL )
   {
      char *pointer = id_pointer;
      
      while( isspace( *pointer ))
         ++pointer;

      char control[ 1024 ];
      snprintf( control, sizeof control, "%s: %s%s",
                ( cancel ? "Control" : "Supersedes" ),
                ( cancel ? "cancel " : "" ), pointer );

      pointer = group_pointer;
      while( isspace( *pointer ))
         ++pointer;

      char newsgroups[ 1024 ];
      snprintf( newsgroups, sizeof newsgroups, "Newsgroups: %s",
                pointer );

      int len = strlen( text ) + strlen( control ) + strlen( newsgroups ) + 1;
      if (( text = ( char *)realloc( text, len )) == NULL )
      {
         perror( "realloc" );
         exit( 1 );
      }

      strcat( text, control );
      strcat( text, newsgroups );
   }

   if ( id_pointer != NULL )
      free( id_pointer );

   if ( group_pointer != NULL )
      free( group_pointer );

   return;
}
