/* The track editor */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "int.h"

#include "main.h"
#include "tracks.h"
#include "selectlist.h"
#include "tracklist.h"
#include "streams.h"
#include "fileman.h"
#include "trackedit.h"
#include "preferences.h"
#include "precachetrack.h"
#include "stdfiletrack.h"
#include "dircache.h"
#include "helpings.h"
#include "updatehandlers.h"
#include "fsedit.h"
#include "internal.h"
#include "tracklist.h"
#include "menusys.h"
#include "trackdoubleclick.h"

/* uncomment for debugging */
/* #define DEBUG */

void trackedit_removehandler(GtkWidget *w,selectlist_info *info);
static menusys_menu trackedit_popupmenu[]=
{
   MENUSYS_ITEM_NONE(N_("Delete Track"),N_("Remove selected track(s) from the tracklist"),trackedit_removehandler),
   MENUSYS_ITEM_END
};

tracklist_info *trackedit;

/* FIXME:
 * the same problem as when moving tracks around in the tracklist:
 * without tracking all remove actions unexpected things happen if we
 * step to all selections. */
void trackedit_removehandler(GtkWidget *w,selectlist_info *info)
{
   char *files;
   GList *c;
   
   files=selectlist_getselection(info);
#ifdef DEBUG
   printf ("trackedit_removehandler: removing tracks %s\n",files);
#endif
   
   /* delete all selected tracks */
   for (c=trackedit->selectlistinfo->selected_lines;
	c!=NULL;
	c=trackedit->selectlistinfo->selected_lines) 
     tracklist_removetrack(trackedit,
			   (int)c->data);
};

int trackedit_streamdrop(char *s,int pos)
{
	int success;
	
	tracks_trackinfo *newtrack;
	
	newtrack=streams_getstreambyid((char*)(strchr(s,":"[0])+1));
	if (newtrack!=NULL)
	  {
	     /* add the track to the list */
	     tracklist_inserttrack(trackedit,pos,newtrack);
	     success=1;
#ifdef DEBUG
	     printf ("trackedit_streamdrop: added stream to tracklist at position %i\n",
		     pos);
#endif DEBUG
	  }
	else
	  {
		  printf ("processing remote streams is currently not supported.\n");
		  printf ("This message occurred because you tried to drop a stream handled by\n");
		  printf ("another instance of Gnome Toaster to the tracklist.\n");
		  printf ("Contact A.Eckleder@bigfoot.com if you think this was not the case.\n");
		  success=0;
	  }
	;	
	return success;	
}
;

int trackedit_filedrop(char *s,int pos)
{
	int success;
	
	tracks_trackinfo *newtrack;
	
	success=0; 	
	if (!dircache_isdir((char*)strchr(s,":"[0])+1)) /* test if file is a directory,fail if it is */
	  {		  
		  newtrack=stdfiletrack_create((char*)(strchr(s,":"[0])+1));
		  if (newtrack!=NULL)
		    {
		       tracklist_inserttrack(trackedit,pos,newtrack);
		       /* unclaim() the track,keeping only the reference
			* stored in the tracklist */
		       tracks_unclaim(newtrack);
		       success=1;
		    };
	  }
	else
	    printf ("trackedit.c: no handler defined for directories\n");
	return success;	
}
;


int trackedit_trackdrop(char *t,char *p)
{
	int success;
	
	success=0;
	if (trackedit->entries<MAX_TRACKS)
	  {		  
		  if (!strncmp("stream:",t,7))
		      success=trackedit_streamdrop(t,(int)p);
		  if (!strncmp("file:",t,5))
		      success=trackedit_filedrop(t,(int)p);
	  }
	;
	return success;
}
;	

/* maybe we should extract all those precaching functions from trackedit.c
 * and into a separate file. */
int prereading;         /* TRUE if prereading process running */
int preread_current;
/* holds the desired precaching mode (atadd,atwrite) */
tracks_precache preread_mode;
/* this var holds a pointer to the callback function to be called 
 * when precaching is done */
trackedit_finished_precache_cb preread_donecallback;

int trackedit_cachenexttrack(gpointer data);

void trackedit_prereadcb(tracks_trackinfo *finished,int success)
{
   /* checking the return state of the precaching function is more
    * important than ever now - if precaching wasnt successful,
    * the track returned in finished is simply invalid */
   if (success)
     {
	/* update data in tracklist */
	tracklist_replacetrack(trackedit,preread_current,finished);	
     }	
   ;
   /* process remaining tracks */
   gtk_timeout_add(500,trackedit_cachenexttrack,NULL);
}
;
	
int trackedit_cachenexttrack(gpointer data)
{		  
   int nextfound;
	
   preread_current++;
   nextfound=0;
   while ((preread_current<trackedit->entries)&&(!nextfound))
     {
	/* precache everything that matches the mode of the current precaching
	 * cycle or should already have been processed in a previous one */
	if (tracklist_gettrack(trackedit,preread_current)->precacherequired>=preread_mode)
	  {
	     /* replacing the track by its precache track is no
	      * longer handled in trackedit.c,hence we do not
	      * need to do anything to the tracklist at the moment
	      * its cleaner so anyway */			    
	     precachetrack_create(tracklist_gettrack(trackedit,preread_current),
				  trackedit_prereadcb);
	     nextfound=1;
	  }
	else
	  preread_current++;
     }
   ;
   prereading=nextfound; /* clear prereading flag if no further tracks */
   /* do a callback once done */
   if ((!nextfound)&&(preread_donecallback!=NULL))
     preread_donecallback();
   
   return 0;
}
;
		 
/* precache tracks specified by mode and call callback once done */
void trackedit_doprereading(tracks_precache mode,
			    trackedit_finished_precache_cb callback)
{
   if (!prereading)
     {
	preread_current=-1;	     
	preread_mode=mode;
	preread_donecallback=callback;
	gtk_timeout_add(0,trackedit_cachenexttrack,NULL);
     }
   else
     if (preread_donecallback!=NULL)
       preread_donecallback();
}
;
	
void trackedit_drophandler(char *s,int x,int y)
{
   int listpos;
   /* apparently we need a dummy because clist_get_selection_info
    * does not accept NULL pointers for arguments we dont need */
   int dummy;
   /* check the result of the get_selection_info call. If result is false
    * the position of the drop was not within the current tracklist.
    * The dropped track is simply appended to the list in that case */
   int result;
   
   /* get drop position within the tracklist */
   result=gtk_clist_get_selection_info(trackedit->selectlistinfo->self,				       
				       x,y,
				       &listpos,
				       &dummy);
   listpos--;
   /* -1: append track(s) to the list */
   if ((!result)||(listpos>trackedit->entries))
     listpos=-1;
   
   #ifdef DEBUG
     printf ("trackedit_drophandler: got selectlist position for (%i,%i): %i\n",
	     x,y,listpos);
   #endif     
   
   /* check if this was an internal drop first */
   if (!tracklist_handleinternaldrop(trackedit,listpos))
     {	   
	/* were doing a little trick here.
	 * The second argument of fileman_selection handler is not used in most
	 * cases anyway,so were just handing in our tracklist position
	 * here for our handler */
	fileman_selectionhandler(s,(char*)listpos,trackedit_trackdrop);
	
	trackedit_doprereading(atadd,NULL);
	/* call the prereading process which steps
	 * through the whole tracklist and
	 * prereads tracks that have to be preread */
     };
}
;

/* if the iso filesystem is edited with fsedit and nothing has been done
 * and the tracklist of trackedit is empty,add the isotrack to the 
 * tracklist */
void trackedit_addisofs(gpointer data)
{
   	/* add iso track here but do not initiate prereading as this could
	 * well be annoying in that situation */
	if (trackedit->entries==0)
	     tracklist_addtrack(trackedit,iso);
}
;

/* we essentially create the tracklist structure here,all internal 
 * handling functions of the tracklist have been moved to tracklist.c */
GtkWidget *trackedit_create()
{
   trackedit=tracklist_info_create(trackedit_drophandler,
				   1,
				   trackedit_popupmenu,
				   GTK_SIGNAL_FUNC(trackdoubleclick_handler));
   
   updatehandlers_register(&fsedit_updatehandlers,
			   trackedit_addisofs,
			   NULL);
   
   return trackedit->widget;
}
;

void trackedit_destroy()
{
   tracklist_info_destroy(trackedit);
};
