#
#  $Id: Install.py,v 1.16 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Installation Conduit.
"""

__version__ = '$Id: Install.py,v 1.16 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'

import Pyrite
import Pyrite.Conduit
from Pyrite import _

import os, string, sys, stat

install_dir = None

def copyfile(src, dst):
    """Copy data from src to dst"""
    # copied from shutil.py
    fsrc = None
    fdst = None
    try:
	fsrc = open(src, 'rb')
	fdst = open(dst, 'wb')
	while 1:
	    buf = fsrc.read(16*1024)
	    if not buf:
		break
	    fdst.write(buf)
    finally:
	if fdst:
	    fdst.close()
	if fsrc:
	    fsrc.close()

class Conduit(Pyrite.Conduit.Conduit):
    name = 'Install'
    version = Pyrite.version
    author = Pyrite.author
    url = ''
    description = _("Installs databases on the PalmOS device.")

    def __init__(self):
	Pyrite.Conduit.Conduit.__init__(self)

    def presync(self, app):
	store = app.user_directory('install')
	if not store.list():
	    return None
	else:
	    return 1
	
    def __call__(self, app):
	store = app.user_directory('install')

	install_list = store.list()

	if not install_list:
	    self.log(_("nothing to install."))
	    return None

	for name in install_list:
	    try:
		self.log(_("installing '%s'") % name)
		app.remote.install(store, name)
		self.log(_("install of '%s' successful.") % name)
		store.delete(name)
	    except RuntimeError, s:
		self.log(_("install of '%s' failed: %s") % (name, s))
		continue
	    except:
		self.log(_("install of '%s' failed.") % name)
		continue

	self.log(_("done."))
	    
	
    def install(self, username, fname, move=0):
	"""Install the specified file into install_dir.  If move=true,
	moves the file, otherwise copies it.  Later this function may be
	expanded to deal with ZIPs, gzipped PDBs, etc."""
	path = os.path.join(self.registry.user_directory(username),'install')
	    
	os.stat(path)  # raise exception if install directory not found
	
	st = os.stat(fname)  # raises exception if file not found

	if not stat.S_ISREG(st[stat.ST_MODE]):
	    raise IOError, _("can only install a normal file")

	target = os.path.join(path, os.path.split(fname)[1])

	if move:
	    os.rename(fname, target)
	else:
	    copyfile(fname, target)
	

#########

