# PCC Makefile for abcMIDI package
# 
#
# compilation #ifdefs - you need to compile with these defined to get
#                       the code to compile with PCC.
#
# NOFTELL in midifile.c and tomidi.c selects a version of the file-writing
#         code which doesn't use file seeking.
#
# PCCFIX in mftext.c midifile.c midi2abc.c
#        comments out various things that aren't available in PCC
#        and applies a fix needed for file writing

all : abc2midi.exe midi2abc.exe abc2abc.exe mftext.exe

abc2midi.exe : parseabc.o store.o genmidi.o queues.o midifile.o
	pccl -Oabc2midi -Lc:\bin\pcc\ parseabc.o store.o genmidi.o queues.o midifile.o

abc2abc.exe : parseabc.o toabc.o
	pccl -Oabc2abc -Lc:\bin\pcc\ parseabc.o toabc.o

midi2abc.exe : midifile.o midi2abc.o 
	pccl midifile.o midi2abc.o -Lc:\bin\pcc\ -Omidi2abc

mftext.exe : midifile.o mftext.o crack.o
	pccl midifile.o mftext.o crack.o -Lc:\bin\pcc\ -Omftext

parseabc.o : parseabc.c abc.h
	pcc parseabc.c 

toabc.o : toabc.c abc.h
	pcc toabc.c 

genmidi.o : genmidi.c abc.h midifile.h
	pcc genmidi.c -nNOFTELL

store.o : store.c abc.h midifile.h
	pcc store.c -nNOFTELL

queues.o : queues.c
	pcc queues.c

midifile.o : midifile.c midifile.h
	pcc midifile.c -nPCCFIX -nNOFTELL

midi2abc.o : midi2abc.c midifile.h
	pcc midi2abc.c -nPCCFIX

crack.o : crack.c
	pcc crack.c 

mftext.o : mftext.c midifile.h
	pcc mftext.c -nPCCFIX

clean:
	del *.exe
	del *.o
