#ifndef SND_H
#define SND_H

/* 
 * there are several compile-time options:
 *
 *   HAVE_GUILE    define if the guile library is available (adds lisp extension/customization language)
 *                 see http://www.gnu.org/software/guile (this is now a standard part of the Gnu distribution)
 *                 if you have Guile 1.3.4 or later, include -DHAVE_MAKE_SMOB_TYPE
 *
 *   HAVE_XmHTML   define if the XmHTML widget available (used by help functions) 
 *                 see http://www.xs4all.nl/~ripley/XmHTML
 *
 *   XPM           define if you have the XPM library (the default in Linux)
 *                 (used to make cute icons in various places)
 *
 *   USR_LIB_OSS    
 *   USR_LOCAL_LIB_OSS 
 *                 define if OSS library/header files are in /usr/lib or /usr/local/lib.
 *                 These are sometimes needed to find the correct version of soundcard.h
 *                 OSS is one of the main sound support providers for Linux.
 *                 http://www.4front-tech.com/ or maybe www.4front.com
 *   HAVE_ALSA     In Linux, OSS is the default audio system; HAVE_ALSA overrides this.
 *
 *   SND_CONF      global initialization file; under CCRMA switch defaults to /etc/snd.conf.
 *
 *   HAVE_CONFIG_H define if you're trying to build Snd via autoconf config files
 *                 (automatic if you use ./configure followed by make)
 *
 *   WITH_BIG_COLORMAP
 *                 if your video setup can handle 16 or more bits of color, define
 *                 this flag (via -DWITH_BIG_COLORMAP in CFLAGS for example), and
 *                 the sonogram colormaps will involve 512 colors, rather than 64.
 *
 *   NO_FPU_CONTROL_H
 *                 In Linux, we sometimes get NaNs which we would rather just set
 *                 to 0.0; if you don't want this to happen, or don't have the
 *                 file fpu_control.h or the function __setfpucw, define this
 *                 flag.
 *
 *   WITH_MUS_MODULE
 *                 The files clm.c, clm.h, and clm2scm.c mark the beginning of 
 *                 a port of CLM to Guile.  
 *
 *   SND_AS_WIDGET This causes the entire Snd editor to become a module loadable
 *                 into some other program as a kind of enormous widget.
 *
 *  Many others are set by configure -- see config.h.in.  The main useful set
 *  chooses which audio system to load (OSS, SGI, etc).  The most problematic
 *  is FSTATFS_ARGS -- if your system supports fstatfs, this macro sets
 *  the number of arguments it takes.
 */

#if defined(HAVE_CONFIG_H)
  #include "config.h"
  #if (!defined(HAVE_STRTOK))
    #error Snd code needs strtok which is apparently missing
  #endif
  #if (!defined(HAVE_VPRINTF))
    #error Snd code needs vsprintf which is apparently missing
  #endif
#endif
#ifdef BEOS
  #error Snd no longer hopes to run on the Be
#endif

#include <ctype.h>
#include <stddef.h>
#include <math.h>
#include <stdio.h>
#if (!defined(HAVE_CONFIG_H)) || (defined(HAVE_FCNTL_H))
  #include <fcntl.h>
#endif
#include <signal.h>
#if (!defined(HAVE_CONFIG_H)) || (defined(HAVE_LIMITS_H))
  #include <limits.h>
#endif
#include <errno.h>
#include <stdlib.h>

#if (defined(NEXT) || (defined(HAVE_LIBC_H) && (!defined(HAVE_UNISTD_H))))
  #include <libc.h>
#else
  #ifndef _MSC_VER
    #include <unistd.h>
  #endif
#endif

#include <string.h>
#include <stdarg.h>
#include <time.h>

#if MACOS
  #include <stat.h>
#else
  #include <sys/types.h>
  #include <sys/stat.h>
#endif

#include "sndlib.h"
#include "sndio.h"

#ifdef _MSC_VER
  #include <windows.h>
#endif

#include "snd-0.h"
#include "snd-x0.h"
#include "snd-1.h"
#include "snd-x1.h"
#include "snd-strings.h"

#define SND_VERSION "8-Nov-99"
#define SND_RPM_VERSION "3.4"

#endif

