
#include <sys/types.h>
#include <unistd.h>

#include <stdio.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include "dga.h"

#ifndef XF86DGA

gboolean xmms_dga_init(Display * dpy) { return 0; }
gboolean xmms_dga_available() { return 0; }
gboolean xmms_dga_enter(xmms_dga_info_t * info_return) { return 0; }
void xmms_dga_leave() { return; }
void xmms_dga_draw_32_image(gint destx, gint desty, gint width, gint height,
			    guint32 * src, gint rowstride)
{ return; }
void xmms_dga_draw_indexed_image(gint destx, gint desty, gint width,
				 gint height, guchar * src, gint rowstride,
				 GdkRgbCmap * cmap)
{ return; }

#else /* XF86DGA */

#include <X11/extensions/xf86dga.h>

static Display *dga_display = NULL;

static guchar *dga_mem = NULL;
static gint dga_pitch = 0, dga_depth = 0, dga_bytes_per_pixel = 0;
static gint dga_banksize = 0, dga_memsize = 0;
static gboolean dga_dga = FALSE;

static gboolean dga_initialized = FALSE, dga_available = FALSE;

static GdkVisual *dga_visual;

gboolean xmms_dga_init(Display * dpy)
{
	char *mem;
	int width, banksize, memsize, dga_major, dga_minor;

	if (dga_initialized)
		return dga_available;

	dga_display = dpy;
	dga_visual = gdk_visual_get_system();

	if (!XF86DGAQueryVersion(dga_display, &dga_major, &dga_minor))
	{
		dga_available = FALSE;
		dga_initialized = TRUE;
		return FALSE;
	}

	/* This is a dirty hack.  Complain to the DGA people. */
#ifdef __LINUX__
	{
		int fd;

		if ((fd = open("/dev/mem", O_RDWR)) < 0)
		{
			dga_available = FALSE;
			dga_initialized = TRUE;
			return FALSE;
		}
		else
		{
			close(fd);
		}
	}
#else
	if (geteuid() != 0)
	{
		dga_available = FALSE;
		dga_initialized = TRUE;
		return FALSE;
	}
#endif

	if (XF86DGAGetVideo(dga_display, DefaultScreen(dga_display),
			    &mem, &width, &banksize, &memsize))
	{

		dga_mem = (guchar *) mem;

		/* The things we must go through to get a proper depth...
		   If I find the idiot that thought making 32bit report 24bit
		   was a good idea, there may be one less `programmer' in this
		   world... */
		{
			XImage *img;

			img = XGetImage(dga_display, RootWindow(dga_display,
					DefaultScreen(dga_display)), 0, 0, 1, 1,
					AllPlanes, ZPixmap);
			dga_depth = img->bits_per_pixel;
			XDestroyImage(img);
		}
		dga_bytes_per_pixel = (dga_depth + 7) / 8;
		dga_pitch = width * dga_bytes_per_pixel;
		dga_banksize = banksize;
		dga_memsize = memsize;
		dga_available = TRUE;
	}
	else
	{
		dga_available = FALSE;
	}

	dga_initialized = TRUE;
	return dga_available;
}

gboolean xmms_dga_available(Display * dpy)
{
	return (dga_initialized && dga_available);
}

gboolean xmms_dga_enter(xmms_dga_info_t * info_return)
{
	int vwidth = 0, vheight = 0;

	if (dga_dga)
		return FALSE;
	if (!dga_initialized || !dga_available)
		return FALSE;

	XF86DGADirectVideo(dga_display, DefaultScreen(dga_display),
			   XF86DGADirectGraphics);
	XF86DGAGetViewPortSize(dga_display, DefaultScreen(dga_display),
			       &vwidth, &vheight);

	info_return->width = vwidth;
	info_return->height = vheight;
	info_return->pitch = dga_pitch;
	info_return->depth = dga_depth;
	info_return->bytes_per_pixel = dga_bytes_per_pixel;
	info_return->banksize = dga_banksize;
	info_return->memsize = dga_memsize;
	info_return->mem = dga_mem;

	dga_dga = TRUE;
	return dga_dga;
}

void xmms_dga_leave()
{
	if (!dga_dga)
		return;

	dga_dga = FALSE;
	XF86DGADirectVideo(dga_display, DefaultScreen(dga_display), 0);
}

/* WARNING: This function assumes there is one extra byte on the end
            in 24bpp modes. */
void xmms_dga_draw_32_image(gint destx, gint desty, gint width, gint height,
			    guint32 * src, gint rowstride)
{
	gint x, y, memleft, srcleft;
	guchar *p;

	srcleft = (rowstride/4) - width;
	p = dga_mem + ((desty * dga_pitch) + (destx * dga_bytes_per_pixel));

	switch (dga_bytes_per_pixel)
	{
		case 4:
			if (dga_visual->red_prec != 8
			    || dga_visual->green_prec != 8
			    || dga_visual->blue_prec != 8)
				return;

			memleft = dga_pitch - (width * 4);
			for (y = 0; y < height; y++, p += memleft, src += srcleft)
			{
				for (x = 0; x < width; x++, p += 4, src++)
				{
	*(guint32 *) p = ((*src << dga_visual->red_shift) & dga_visual->red_mask) |
			(((*src >> 8) << dga_visual->green_shift) & dga_visual->green_mask) |
			(((*src >> 16) << dga_visual->blue_shift) & dga_visual->blue_mask);
				}
			}
			return;
		case 2:
			memleft = dga_pitch - (width * 2);
			for (y = 0; y < height; y++, p += memleft, src += srcleft)
			{
				for (x = 0; x < width; x++, p += 2, src++)
				{
	*(guint16 *) p = (((*src >> (8 - dga_visual->red_prec)) << dga_visual->red_shift) & dga_visual->red_mask) |
			 (((*src >> (16 - dga_visual->green_prec)) << dga_visual->green_shift) & dga_visual->green_mask) |
			 (((*src >> (24 - dga_visual->blue_prec)) << dga_visual->blue_shift) & dga_visual->blue_mask);
				}
			}
			return;
		case 3:
			if (dga_visual->red_prec != 8
			    || dga_visual->green_prec != 8
			    || dga_visual->blue_prec != 8)
				return;

			memleft = dga_pitch - (width * 3);
#		if G_BYTE_ORDER == G_LITTLE_ENDIAN
			for (y = 0; y < height; y++, p += memleft, src += srcleft)
			{
				for (x = 0; x < width; x++, p += 3, src++)
				{
	*(guint32 *) p = (((*src << dga_visual->red_shift) & dga_visual->red_mask) |
			 (((*src >> 8) << dga_visual->green_shift) & dga_visual->green_mask) |
			 (((*src >> 16) << dga_visual->blue_shift) & dga_visual->blue_mask)) << 8;
				}
			}
#		else
			for (y = 0; y < height; y++, p += memleft, src += srcleft)
			{
				for (x = 0; x < width; x++, p += 3, src++)
				{
	*(guint32 *) p = ((*src << dga_visual->red_shift) & dga_visual->red_mask) |
			(((*src >> 8) << dga_visual->green_shift) & dga_visual->green_mask) |
			(((*src >> 16) << dga_visual->blue_shift) & dga_visual->blue_mask);
				}
			}
#		endif
			return;
	}
}

/* This is horrible.  Please make it better if you can. */
void xmms_dga_draw_indexed_image(gint destx, gint desty, gint width,
				 gint height, guchar * src, gint rowstride,
				 GdkRgbCmap * cmap)
{
	guint32 c;
	gint x, y, memleft, srcleft;
	void *p;

	srcleft = rowstride - width;

	switch (dga_bytes_per_pixel)
	{
		case 4:
			memleft = dga_pitch - (width * 4);
			p = dga_mem + destx * 4 + desty * dga_pitch;
			for (y = 0; y < height;
			     y++, p += memleft, src += srcleft)
			{
				for (x = 0; x < width; x++, p += 4, src++)
				{
	*(guint32 *) p = (((cmap->colors[*src] >> (24 - dga_visual->red_prec)) << dga_visual->red_shift) & dga_visual->red_mask) |
			 (((cmap->colors[*src] >> (16 - dga_visual->green_prec)) << dga_visual->green_shift) & dga_visual->green_mask) |
			 (((cmap->colors[*src] >> (8 - dga_visual->blue_prec)) << dga_visual->blue_shift) & dga_visual->blue_mask);
				}
			}
			break;
		case 2:
			memleft = dga_pitch - (width * 2);
			p = dga_mem + destx * 2 + desty * dga_pitch;
			for (y = 0; y < height;
			     y++, p += memleft, src += srcleft)
			{
				for (x = 0; x < width; x++, p += 2, src++)
				{
	*(guint16 *) p = (((cmap->colors[*src] >> (24 - dga_visual->red_prec)) << dga_visual->red_shift) & dga_visual->red_mask) |
			 (((cmap->colors[*src] >> (16 - dga_visual->green_prec)) << dga_visual->green_shift) & dga_visual->green_mask) |
			 (((cmap->colors[*src] >> (8 - dga_visual->blue_prec)) << dga_visual->blue_shift) & dga_visual->blue_mask);
				}
			}
			break;
		case 3:
			memleft = dga_pitch - (width * 3);
			p = dga_mem + destx * 3 + desty * dga_pitch;
			for (y = 0; y < height;
			     y++, p += memleft, src += srcleft)
			{
				for (x = 0; x < width; x++, p += 3, src++)
				{
		c = (((cmap->colors[*src] >> (24 - dga_visual->red_prec)) << dga_visual->red_shift) & dga_visual->red_mask) |
		    (((cmap->colors[*src] >> (16 - dga_visual->green_prec)) << dga_visual->green_shift) & dga_visual->green_mask) |
		    (((cmap->colors[*src] >> (8 - dga_visual->blue_prec)) << dga_visual->blue_shift) & dga_visual->blue_mask);
					*(guchar *) (p) = c >> 16;
					*(guchar *) (p + 1) = c >> 8;
					*(guchar *) (p + 2) = c;
				}
			}
			break;
		default:
			memleft = dga_pitch - (width * dga_bytes_per_pixel);
			p =
				dga_mem + destx * dga_bytes_per_pixel +
				desty * dga_pitch;
			if (!dga_visual->red_prec && !dga_visual->red_shift
			    && !dga_visual->red_mask)
			{
				if (dga_depth == 8)
				{
					/* 8bpp, use the color lut gdk provides us with */
					for (y = 0; y < height;
					     y++, p += memleft, src += srcleft)
					{
						for (x = 0; x < width;
						     x++, p++, src++)
						{
							*(guchar *) p =
								cmap->lut[*src];
						}
					}
				}
				else
				{
					/* Crap. */
					fprintf(stderr,
						"This depth is not supported by xmms DGA in paletted mode.\n");
					return;
				}
			}
			else
			{
				gint i;

				/* Hmmm.. This is an odd mode... This shouldn't happen.. */
				for (y = 0; y < height;
				     y++, p += memleft, src += srcleft)
				{
					for (x = 0; x < width;
					     x++, p +=
					     dga_bytes_per_pixel, src++)
					{
		c = (((cmap->colors[*src] >> (24 - dga_visual->red_prec)) << dga_visual->red_shift) & dga_visual->red_mask) |
		    (((cmap->colors[*src] >> (16 - dga_visual->green_prec)) << dga_visual->green_shift) & dga_visual-> green_mask) |
		    (((cmap->colors[*src] >> (8 - dga_visual->blue_prec)) << dga_visual->blue_shift) & dga_visual->blue_mask);

						for (i = 0;
						     i < dga_bytes_per_pixel;
						     i++)
						{
							*(guchar *) (p) =
								c >> ((dga_bytes_per_pixel - i - 1)*8);
						}
					}
				}
			}
	}
}

#endif /* XF86DGA */
