#include "xmms.h"

#ifndef fixed
#define fixed short
#endif

struct EffectPluginData *ep_data;

EffectPlugin *get_current_effect_plugin(void)
{
	return ep_data->current_effect_plugin;
}

void effect_about(void)
{
	if (ep_data->current_effect_plugin && ep_data->current_effect_plugin->about)
		ep_data->current_effect_plugin->about();
}

void effect_configure(void)
{
	if (ep_data->current_effect_plugin && ep_data->current_effect_plugin->configure)
		ep_data->current_effect_plugin->configure();
}

void set_current_effect_plugin(int i)
{
	ep_data->current_effect_plugin = (EffectPlugin *) g_list_nth(ep_data->effect_list, i)->data;
}

GList *get_effect_list(void)
{
	return ep_data->effect_list;
}

int effects_enabled(void)
{
	return cfg.use_eplugins;
}
