%{
#include <stdio.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <unistd.h>
#include "bibview.h"


#define YYSTYPE char

#define __RUNTIME_YYMAXDEPTH
#define YYMAXDEPTH 1000

char uebergabe[MAX_UEBERGABE];
char ue2[MAX_UEBERGABE];
int ueIdx = 0;

FILE *tempDatei;
extern FILE *yyin;
extern YY_NEW_FILE;
extern int yy_init;

extern int fld_indent, cont_indent, newline_indent, max_fields;

typedef struct _Snode {
                       char inh;
                       int slen;
                       struct _Snode *next;
} Snode;

/*******************************************/
/* Globale Variablen                       */
/*******************************************/

int yynline;
int yynflexcalls;
int yynerrs;
char errorstr[MAX_ERRORSTRLEN];

/*******************************************/
/* Lokale Variablen                        */
/*******************************************/

static Snode *key = NULL;            
static Snode *fldname = NULL;       

static char errstr[MAX_ERRLINELENGTH];
#ifdef GERMAN
static char *anfhelpstr = 
  "Es wurden leider Fehler entdeckt\n\n\t%15s\t\t%10s\t%10s\n";
static char *endhelpstr = 
  "\n%40s: %3d Fehler";
#else
static char *anfhelpstr = 
  "Sorry, but there were syntax errors:\n\n\t%15s\t\t%10s\t%10s\n";
static char *endhelpstr = 
  "\n%40s: %3d errors";
#endif
static CardType cardtype;
static CardData *card = NULL;
static UserFld *helpufield = NULL;
static String helpFldName = NULL;
static String errkey;
static Errcode err;
static BibPtr glbbp;
static int beginIdx;
static int keyline;
static int errorline;

/*******************************************/
/* Lokale Funktionen                       */
/*******************************************/

static void PushSign(Snode **w, char a);
static void FreeStack(Snode **s);
static void StringToString(char *text1, char **text); 
static void StackToString(Snode *s, char **text); 
static void GetKey();
static void GetFldNameCont();
static void SecStrcat(int maxlen, char *str1, char *str2);

static int SetInputFile(char *file);
static int SkipSpace(char *text, char *text2);
static int SkipNewLineSpace(char *text);
static int SkipApe(char *text);
static int StringIsPeteEmpty(char *text);
static void WriteRecToFile(CardData *card, FILE *datei);
static long WriteLineToFile(FILE *datei, char *feld, char *inh);
%}
%token  COMMENT
%token  STRING
%token  PREAMBLE
%token  TYPE
%token  KOMMA
%token  EQ
%token  AFFE
%token  LGKL
%token  RGKL
%token  LRKL
%token  RRKL
%token  DAZ
%token  ZAUN
%token  PROZENT
%token  ZEICHEN
%token  WHITE_SPACE
%token  NEW_LINE
%token  BUCHSTABE_ZAHL


%%

datei  
         :  between datei
         |  entry datei
         |  entry
         |  between

between
	 : alles
	     {
               uebergabe[0] = '\0';
	       ueIdx = 0;
	     }
	 | kommentar
	     {
               uebergabe[0] = '\0';
	       ueIdx = 0;
	     }
	 | NEW_LINE
	     {
               uebergabe[0] = '\0';
	       ueIdx = 0;
	     }

alles
	 : KOMMA
	 | EQ
	 | LGKL
	 | RGKL
	 | LRKL
	 | RRKL
	 | DAZ
	 | ZAUN
	 | ZEICHEN
	 | WHITE_SPACE
	 | BUCHSTABE_ZAHL

kommentar
	 :  PROZENT kommaffe NEW_LINE   
	 |  PROZENT NEW_LINE

kommaffe
	 :  alles kommaffe
	 |  TYPE kommaffe
	 |  AFFE kommaffe
	 |  PROZENT kommaffe
	 |  alles
	 |  TYPE
	 |  AFFE
	 |  PROZENT

entry
	 :  comment
	 |  string
	 |  preamble
	 |  eintrag
         |  error RGKL
	      {StackToString(key, &errkey);
	       FreeStack(&key);
	       if ((errkey!=NULL) && (errkey[0]!='\0')){
		 sprintf(errstr, "\t%15s:\t%10d\t%10d\n", 
				 errkey, errorline-keyline, errorline-1);
                 XtFree(errkey);
		 errkey = NULL;
		 }
               else
		 sprintf(errstr, "\t%15s:\t%10d\t%10d\n", "key unknown", 
				     errorline-keyline, errorline-1);
               SecStrcat(MAX_ERRORSTRLEN, errorstr, errstr);
	       }
	    
string
         :  STRING LGKL allstringG RGKL
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  STRING leerraum LGKL allstringG RGKL
              {          
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  STRING LRKL allstringR RRKL 
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  STRING leerraum LRKL allstringR RRKL
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
comment
         :  COMMENT LGKL allstringG RGKL
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  COMMENT leerraum LGKL allstringG RGKL
              {          
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  COMMENT LRKL allstringR RRKL 
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  COMMENT leerraum LRKL allstringR RRKL
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 


preamble
         :  PREAMBLE LGKL allstringG RGKL
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  PREAMBLE leerraum LGKL allstringG RGKL 
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  PREAMBLE LRKL allstringR RRKL
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 
         |  PREAMBLE leerraum LRKL allstringR RRKL
              {         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } 

allstringG
         :  WHITE_SPACE allstringG
         |  NEW_LINE allstringG
         |  ZEICHEN  allstringG
         |  PROZENT  allstringG
         |  BUCHSTABE_ZAHL allstringG
         |  KOMMA allstringG
         |  EQ allstringG
         |  ZAUN allstringG
         |  DAZ allstringG
         |  LGKL allstringG RGKL allstringG
         |  LGKL RGKL allstringG
         |  LGKL allstringG RGKL
         |  LGKL RGKL
         |  LRKL allstringG
         |  RRKL allstringG
         |  TYPE allstringG
         |  STRING allstringG
         |  PREAMBLE allstringG
         |  COMMENT allstringG
         |  AFFE allstringG
         |  WHITE_SPACE
         |  NEW_LINE
         |  ZEICHEN
         |  PROZENT
         |  BUCHSTABE_ZAHL
         |  KOMMA
         |  EQ
         |  ZAUN
         |  DAZ
         |  LRKL
         |  RRKL 
         |  TYPE 
         |  AFFE 
         |  STRING 
         |  PREAMBLE
         |  COMMENT

allstringR
         :  WHITE_SPACE allstringR
         |  NEW_LINE allstringR
         |  ZEICHEN  allstringR
         |  PROZENT  allstringR
         |  BUCHSTABE_ZAHL allstringR
         |  KOMMA allstringR
         |  EQ allstringR
         |  ZAUN allstringR
         |  DAZ allstringR
         |  LGKL allstringR RGKL allstringR
         |  LGKL RGKL allstringR
         |  LGKL allstringR RGKL
         |  LGKL RGKL
         |  LRKL allstringR RRKL allstringR
         |  LRKL allstringR RRKL
         |  TYPE allstringR
         |  STRING allstringG
         |  PREAMBLE allstringR
         |  COMMENT allstringR
         |  AFFE allstringR
         |  LRKL RRKL
	 |  WHITE_SPACE
         |  NEW_LINE
         |  ZEICHEN
         |  PROZENT
         |  BUCHSTABE_ZAHL
         |  KOMMA
         |  EQ
         |  ZAUN
         |  DAZ
         |  TYPE 
         |  AFFE 
         |  STRING 
         |  PREAMBLE
         |  COMMENT
eintrag 
         :  eingabetyp LGKL schluessel KOMMA felder leerraum RGKL 
                {                 
                  GetKey();
                }
         |  eingabetyp leerraum LGKL schluessel KOMMA felder leerraum RGKL 
                {
                  GetKey();
                }
         |  eingabetyp LGKL schluessel KOMMA felder RGKL 
                {
                  GetKey();
                }
         |  eingabetyp leerraum LGKL schluessel KOMMA felder RGKL
                {
                  GetKey();
                }
         |  eingabetyp LRKL schluessel KOMMA felder leerraum RRKL 
                {
                  GetKey();
                }
         |  eingabetyp leerraum LRKL schluessel KOMMA felder leerraum RRKL
                {
                  GetKey();
                }
         |  eingabetyp LRKL schluessel KOMMA felder RRKL 
                {
                  GetKey();
                }
         |  eingabetyp leerraum LRKL schluessel KOMMA felder RRKL
                {
                  GetKey();
                }

eingabetyp
	  :  TYPE
                {
		  err = dbtMakeCard(&card);
		  beginIdx = SkipApe(uebergabe);
		  card->cardtype = cardtype = 
		     glbNameToType(strlower(&uebergabe[beginIdx])); 
		  if (cardtype == -1)
		     card->cardtype = cardtype = MAX_BIBTEX_TYPES;
		  Scalloc(&card->cardtypestr, &uebergabe[beginIdx]);
		  ueIdx = 0;
                }

schluessel 
            :  leerraum schl
            |  schl leerraum
            |  leerraum schl leerraum
            |  schl


schl
            :  BUCHSTABE_ZAHL schl
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  ZEICHEN schl
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  DAZ schl
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  EQ schl
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  LRKL schl
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  RRKL schl
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  BUCHSTABE_ZAHL 
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  ZEICHEN 
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  EQ
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  DAZ 
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  LRKL
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }
            |  RRKL
                {
                  PushSign(&key, $1);
		  keyline = yynline;
                }

felder 
          :  leerraum feld KOMMA felder
          |  feld KOMMA felder
          |  leerraum feld KOMMA
          |  leerraum feld KOMMA leerraum
          |  feld KOMMA 
          |  feld KOMMA  leerraum
          |  leerraum feld
          |  feld
          |  feld leerraum
          

feld 
          :  feldname leerraum EQ 
		{
		  ueIdx = 0;
                }
	     konkatenation
                {
                  GetFldNameCont();
                }
          |  feldname EQ 
		{
		  ueIdx = 0;
                }
	     konkatenation
                {
                  GetFldNameCont();
                }

feldname
          :  BUCHSTABE_ZAHL feldname
                {
                  PushSign(&fldname, $1);
                  ueIdx = 0;
                }
          |  ZEICHEN feldname
                {
                  PushSign(&fldname, $1);
                  ueIdx = 0;
                }
          |  BUCHSTABE_ZAHL
                {
                  PushSign(&fldname, $1);
                  ueIdx = 0;
                }
          |  ZEICHEN 
                {
                  PushSign(&fldname, $1);
                  ueIdx = 0;
                }

leerraum
          :  WHITE_SPACE  leerraum
          |  NEW_LINE  leerraum
          |  WHITE_SPACE
          |  NEW_LINE
      
konkatenation
             :  konkatenation ZAUN konkatenation
             |  feldinhalt
             |  feldinhalt leerraum
             |  leerraum feldinhalt 
             |  leerraum feldinhalt leerraum

feldinhalt
          :  LGKL allstringG RGKL
          |  DAZ dazfeldinhalt DAZ 
          |  DAZ DAZ 
          |  LGKL RGKL
          |  makro

makro
            :  BUCHSTABE_ZAHL makro
            |  ZEICHEN makro
            |  BUCHSTABE_ZAHL 
            |  ZEICHEN 

dazfeldinhalt
          :  WHITE_SPACE dazfeldinhalt
          |  NEW_LINE dazfeldinhalt
          |  BUCHSTABE_ZAHL dazfeldinhalt
          |  ZEICHEN dazfeldinhalt
          |  PROZENT dazfeldinhalt
          |  KOMMA dazfeldinhalt
          |  EQ dazfeldinhalt
          |  ZAUN dazfeldinhalt
          |  LRKL dazfeldinhalt
          |  RRKL dazfeldinhalt
          |  LGKL dazdaz RGKL
          |  LGKL dazdaz RGKL dazfeldinhalt
          |  LGKL RGKL
          |  LGKL RGKL dazfeldinhalt
          |  TYPE dazfeldinhalt
          |  STRING dazfeldinhalt
          |  PREAMBLE dazfeldinhalt
          |  COMMENT dazfeldinhalt
          |  AFFE dazfeldinhalt
          |  WHITE_SPACE
          |  NEW_LINE
          |  BUCHSTABE_ZAHL
          |  ZEICHEN
          |  PROZENT
          |  KOMMA
	  |  EQ
          |  ZAUN
          |  LRKL
          |  RRKL
	  |  AFFE
	  |  TYPE
	  |  STRING
	  |  PREAMBLE
	  |  COMMENT

dazdaz
          :  WHITE_SPACE dazdaz
          |  NEW_LINE dazdaz
          |  BUCHSTABE_ZAHL dazdaz
          |  ZEICHEN dazdaz
          |  PROZENT dazdaz
          |  ZAUN dazdaz
          |  LRKL dazdaz
          |  RRKL dazdaz
          |  LGKL dazdaz RGKL
          |  LGKL dazdaz RGKL dazdaz
          |  LGKL RGKL
          |  LGKL RGKL dazdaz
          |  TYPE dazdaz
          |  STRING dazdaz
          |  PREAMBLE dazdaz
          |  COMMENT dazdaz
          |  AFFE dazdaz
          |  WHITE_SPACE
          |  NEW_LINE
          |  BUCHSTABE_ZAHL
          |  KOMMA dazdaz
          |  DAZ dazdaz
          |  EQ dazdaz
          |  ZEICHEN
          |  PROZENT
          |  ZAUN
          |  EQ
          |  LRKL
          |  RRKL
          |  KOMMA
          |  DAZ
	  |  AFFE
	  |  TYPE
	  |  STRING
	  |  PREAMBLE
	  |  COMMENT

%%


static int SkipApe(char *text)
{ 
 int erg, back;

 erg = 0;
 while (erg < ueIdx) {
   if (*text == '@') 
     return erg+1;
   text++;
   erg++;
 }
 return 0;
}


static int SkipNewLineSpace(char *text)
{ 
 int erg, back;

 erg = 0;
 while (erg < MAX_UEBERGABE) {
   if (*text == '{' ||  *text == '(') {
     back = strlen(text);
     text = text + back;
     while (*text != '}' && *text != ')') { 
       *text = '\0';
       text--;
     }
     return erg;
   }
   text++;
   erg++;
 }
 return 0;
}

static int SkipSpace(char *text, char *text2)
{
 int erg, lgkl, daz, index, inmakro, anfang;
 char *zaehler, *suchzeiger;

 index = 0;
 lgkl = 0;
 daz = 0;
 inmakro = 0;
 anfang = 0;
 zaehler = text2;
 *zaehler = '\0';


 while ((*text == ' ' || *text == '=' || *text == '\t') && index < ueIdx) { 
   text++; 
   index++;
   }
 erg = index;
 while (index < ueIdx) {
   if (*text == '{') {
     if ((lgkl >= 1) || daz || cotOrig())  /* Klammer in String */
       *zaehler++ = *text;
     lgkl += 1;
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == '}') {
     if ((lgkl > 1) || daz || ((lgkl == 1) && cotOrig()))
       *zaehler++ = *text;
     lgkl -= 1;
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == '"') {
     if (lgkl >= 1) 
       *zaehler++ = *text;
     else {
       daz = !daz;
       if (cotOrig())
          *zaehler++ = *text;
     }
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == ',') {        /* Komma am Ende */
     if ((lgkl >= 1) || daz)
       *zaehler++ = *text;
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == '#') {        /* Space vor/nach Konkatenation */
     if ((lgkl < 1) && !daz) {
       if (!cotOrig()) {
	 if (text[index-1] != ' ')
            *zaehler++ = ' ';
         *zaehler++ = '@';
	 }
       *zaehler++ = *text;
       if (!cotOrig() && (text[index+1] != ' '))
          *zaehler++ = ' ';
     }
     else {                        /* Konkatenation in String */
       *zaehler++ = *text;
     }
     inmakro = 0;
     anfang = 0;
   } 
   else if (*text == '\n') {
     if (lgkl >= 1 || daz)
       *zaehler++ = '\n';
     else { 
       suchzeiger = text+1;
       while ((*suchzeiger == ' ') || (*suchzeiger == '\t') ||
	      (*suchzeiger == '\n'))
	  suchzeiger++;
       if ((*suchzeiger != '}') && (*suchzeiger != ')')){
	  *zaehler++ = '\n';
	  }
       inmakro = 0;
       }
     anfang = 1;
   } 
   else if ((*text == ' ') || (*text == '\t')) {
     if (!anfang)
	*zaehler++ = *text;
     inmakro = 0;
   }
   else if (*text == ')') {        /* runde Klammer am Ende */
     if (lgkl >= 1 || daz)
       *zaehler++ = *text;
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == '@') {        /* @ */
     *zaehler++ = *text;
     if (!cotOrig())
        *zaehler++ = *text;
     inmakro = 0;
     anfang = 0;
   } 
   else {
     if ((lgkl < 1) && (daz < 1) && (inmakro==0)) {
       if (!cotOrig()){
          if ((*zaehler != '\0') && (text[index-1] != ' '))
	     *zaehler++ = ' ';
          *zaehler++ = '@';
       }
       *zaehler++ = *text;
       inmakro = 1;
       anfang = 0;
     }
     else {                        /* Zeichen in String */
       *zaehler++ = *text;
       anfang = 0;
       }
   } 
   text++;
   index++;
 }
 *zaehler++ = '\0';
 return erg;
}

static void PushSign(Snode **w, char a)
{
 Snode *hnode, *oldw;

 if (*w == NULL) {
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = 1;
   hnode->next = NULL;
   *w = hnode;
 }
 else {
   oldw = *w; 
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = oldw->slen + 1;
   hnode->next = oldw;
   *w = hnode;
}
}


static void FreeStack(Snode **s)
{
 Snode *h, *del;

 del = *s;
 while (del != NULL) {
   h = del->next;
   XtFree((char *)del);
   del = h;
 }
 *s = NULL;
} 


static void StringToString(char *text1, char **text) 
  
  {
   *text = (char *)XtCalloc(1,strlen(text1)+1);
   strcpy(*text, text1);
   }


static void StackToString(Snode *s, char **text) 
{
  char *help;
  
  if (s==NULL)
     help = (char *)XtCalloc(1,1);
  else
     help = (char *)XtCalloc(1,s->slen+1);
  *text = help;
  while (s != NULL) {
    *help = s->inh; 
    s = s->next;
    help++;
  }
  *help = '\0';
  help--;
  while (*help == '\n') {    /* NL am Ende vom Wort loeschen */
    *help = '\0';
    help--;
  }
}



static void GetKey()
{
  StackToString(key, &card->mainkey);
  FreeStack(&key);
  err = dbtInsert(glbbp, card);
  err = dbtDeleteCard(&card);
  ueIdx = 0;
}


static void GetFldNameCont()
{
  int found;
  FieldName i;
  
  if (helpFldName != NULL) {
    XtFree((char *)helpFldName);
    helpFldName = NULL;
  }
  StackToString(fldname, &helpFldName);
  strlower(helpFldName); 
  SkipSpace(uebergabe, ue2);
  found = 0;
  for (i=0;i<max_fields && (!found);i++) {
      if (strcmp(helpFldName, glbFldToName(i)) == 0) {
         if (isstandardfield(i, cardtype))
            StringToString(ue2, &card->field[i]);
         else {
            err = dbtMakeUserFld(&helpufield);
            Scalloc(&helpufield->fldName, helpFldName);
            StringToString(ue2, &helpufield->fldData); 
            err = dbtAppendUserFld(&card->ufield, helpufield);
            }
         found = 1; 
         break;
      }
  }
  if (!found){
     err = dbtMakeUserFld(&helpufield);
     Scalloc(&helpufield->fldName, helpFldName);
     StringToString(ue2, &helpufield->fldData); 
     err = dbtAppendUserFld(&card->ufield, helpufield);
     }
  FreeStack(&fldname);
}

static void SecStrcat(int maxlen, char *str1, char *str2)
{
 if (strlen(str1)+strlen(str2) < maxlen)
    strcat(str1, str2);
}

static int SetInputFile(char *file)
{
 char *infilename; 
    
 if (file)
 {
  infilename = file;

  if (access(infilename, F_OK) != 0)
     return BIF_ENOTEXISTS;

  yyin = fopen(infilename, "r" );

  if ( yyin == NULL ) {
    return BIF_EOPEN;  
  }
  return BIF_OK;  
 }
 else
 {
   yyin = stdin;
   infilename = "<stdin>";
   return BIF_OK;  
 }
}


/*********************************************
 * BibTeX-Datei lesen                        *
 *********************************************/
Errcode bifFileRead(BibPtr bp)
{
  int erg;
  char *tempName;

  yynline = 1; 
  yynflexcalls = 0;
  hlpQuitHelpError(7);

  sprintf(errorstr, anfhelpstr, "KEY", "OFFSET", "LINE");
#ifdef NO_TEMPNAM
  tempName = (char *)tmpnam(NULL);
  bp->tempfile = (char *)XtMalloc(strlen(tempName)+1);
  strcpy(bp->tempfile,tempName);
  tempName = (char *)tmpnam(NULL);
  bp->macrofile = (char *)XtMalloc(strlen(tempName)+1);
  strcpy(bp->macrofile,tempName);
#else
  bp->tempfile = (char *)tempnam(NULL, NULL);
  bp->macrofile = (char *)tempnam(NULL, NULL);
#endif
  tempDatei = fopen(bp->macrofile, "w" );

  if ((erg = SetInputFile(bp->filepath)) == BIF_ENOTEXISTS){
     glbbp = bp;
     fclose(tempDatei);
     return BIF_OK;
     }
  
  if ((erg = glbContIllegalChar(bp->filepath)) == 2) return ERR_NOBIB;
  if (erg == 1) return BIF_EOPEN;
  glbbp = bp; 
  erg = yyparse();
  fclose(tempDatei);
  uebergabe[0] = '\0';
  sprintf(errstr, endhelpstr, bp->filepath, yynerrs);
  SecStrcat(MAX_ERRORSTRLEN, errorstr, errstr);
  ueIdx = 0;
  if (erg == 0) {
    if (yyin) fclose(yyin);
    erg = yynline;
    if (yynerrs > 0)
       return yynline-1;
    else
       return BIF_OK;
  }
  else {
    erg = -yynline;
    yy_init = 1;
    if (yyin) fclose(yyin);
    FreeStack(&key);
    FreeStack(&fldname);
    return (Errcode)erg;
  }
}



Errcode bifFileWrite(BibPtr bp)
{
 char sysStr[2*MAX_FILEPATHLEN];
 CardListNode *cl1 = NULL;
 CardListNode *cl2 = NULL;
 Errcode status;

 if (bp->macrofile!=NULL){
    sprintf(sysStr, "cp  %s %s", bp->macrofile, bp->tempfile);
    system(sysStr);
    tempDatei = fopen(bp->tempfile, "r+");
    }
 else
    {tempDatei = fopen(bp->tempfile, "w+");
     }

 if (tempDatei == NULL) return BIF_EWRITE;

   /* build list */
   if ((status = dbtBuildList(bp->treeIdx, &cl1, bp->sortedby)) != OK) {
      guwError(status); 
      return(status);
   }

 cl2 = cl1;

 while (cl1 != NULL) {
   if (!glbIsStringEmpty(cl1->data->field[ncrossref]))
      WriteRecToFile(cl1->data, tempDatei);
   cl1 = cl1->next;
 } 

 while (cl2 != NULL) {
   if (glbIsStringEmpty(cl2->data->field[ncrossref]))
      WriteRecToFile(cl2->data, tempDatei);
   cl2 = cl2->next;
 } 

 fclose(tempDatei);
 sprintf(sysStr, "cp  %s %s", bp->tempfile, bp->filepath);
 system(sysStr);
 return BIF_OK;
}


Errcode bifFileListWrite(BibPtr bp, CardListNode *list, String fname)
{
 CardListNode *hlist;
 Errcode erg;
 char sysStr[2*MAX_FILEPATHLEN];
 
 if (bp->macrofile!=NULL){
    sprintf(sysStr, "cp  %s %s", bp->macrofile, fname);
    system(sysStr);
    tempDatei = fopen(fname, "r+");
    }
 else
    {tempDatei = fopen(fname, "w+");
     }

 if (tempDatei == NULL) return BIF_EWRITE;
 hlist = list;
 while (hlist != NULL) {
   if (!glbIsStringEmpty(hlist->data->field[ncrossref]))
      WriteRecToFile(hlist->data, tempDatei);
   hlist = hlist->next;
 } 
 hlist = list;
 while (hlist != NULL) {
   if (glbIsStringEmpty(hlist->data->field[ncrossref]))
      WriteRecToFile(hlist->data, tempDatei);
   hlist = hlist->next;
 } 
 fclose(tempDatei);
 return BIF_OK;
}


static void WriteOrigLine(FILE *datei, char *inh)
{ 
  int zaehler;
  char *zeiger;

  zeiger = inh;
  while (*zeiger != '\0'){
     if (*zeiger != '\n')
	fputc(*zeiger, datei);
     else {
	fputc(*zeiger, datei);
        for (zaehler = 0; zaehler < newline_indent; zaehler++)
	   fputc(' ', datei);
     }
     zeiger++;
  }
}

static long WriteLineToFile(FILE *datei, char *feld, char *inh)
{
  int inmakro = 0;    /* weder Makro, noch String */
  int instring = 0;
  int isempty = 1;
  int zaehler;
  long pos; 
  char *blank, *blankptr, *zeichen; 

  
  for (zaehler = 0; zaehler < fld_indent; zaehler++)
     fprintf(datei," ");
  fprintf(datei,"%s", feld);
  zaehler += strlen(feld);
  for (;zaehler < cont_indent - 3; zaehler++)
     fprintf(datei," ");
  fprintf(datei," = ");

  if (cotOrig()){
     WriteOrigLine(datei, inh);
     pos = ftell(datei);
     fprintf(datei,",\n");
     return pos;
  }

  zeichen = inh;
  blank = (char *)XtMalloc(100);
  blankptr = blank;

  while (*zeichen!='\0'){
   switch (*zeichen){
     case ' ':
     case '\t':
	  if (instring)
	     *blankptr++ = *zeichen;
          else if (inmakro){
	     fprintf(datei, " ");
	     inmakro = 0;
	     }
          break;
     case '\n':
	  if (instring){ 
	     *blankptr++ = *zeichen;
	     for (zaehler = 0; zaehler < newline_indent; zaehler++)
	        *blankptr++ = ' ';
             } 
          else {
	     fprintf(datei, "\n");
	     for (zaehler = 0; zaehler < newline_indent; zaehler++)
	        fprintf(datei, " ");
	     inmakro = 0;
	     } 
	  inmakro = 0;
          break;
     case '@':
          if (inmakro)
	     fprintf(datei, " ");
          else if (*(zeichen+1) == '@'){
	     if (instring){
		*blankptr++ = '\0';
		fprintf(datei, "%s", blank);
		blankptr = blank;
		}
             else {
	        fprintf(datei, "{");
		instring=1;
		}
	     fprintf(datei, "@");
	     zeichen++;
	     }
          else if (instring){
	     fprintf(datei, "} ");
	     inmakro = 1;
	     instring = 0;
	     }
          else {
	     inmakro = 1;
	     instring = 0;
	     }
          break;
     case '#':
          if (isempty && inmakro) {
	     fprintf(datei, "{ } #");
             blankptr = blank;
	     *blankptr = '\0';
	     inmakro = 0;
	     }
          else if (inmakro){
	     fprintf(datei, "# ");
             blankptr = blank;
	     *blankptr = '\0';
	     inmakro = 0;
	     }
          else if (instring) 
	     fprintf(datei, "#");
          else {
	     fprintf(datei, "{#");
	     instring = 1;
	     }
          break;
      default:
          isempty = 0;
          if (inmakro)
	     fprintf(datei, "%c", *zeichen);
          else if (instring){
	     *blankptr++ = '\0';
	     fprintf(datei, "%s", blank);
	     blankptr = blank;
	     fprintf(datei, "%c", *zeichen);
	     }
          else{
	     fprintf(datei, "{%c", *zeichen);
	     instring = 1;
	     inmakro = 0;
	     }
          break;
      } /* case */
  zeichen++;
  } /* while */
	   
  if ((isempty==1) && (inmakro==0) && (instring==0))
    fprintf(datei,"{ }");    
  else if (instring) {
    fprintf(datei,"}");    
  }
        
  pos = ftell(datei);
  fprintf(datei,",\n");
  XtFree(blank);
  return pos;
}

static void WriteRecToFile(CardData *card, FILE *datei)
{
 UserFld *h;
 String newType;
 long pos;
 FieldName i;

 fseek(datei, 0L, SEEK_END); 
 fprintf(datei,"\n");
 pos = ftell(datei);
 newType = glbNewString(card->cardtypestr);
 fprintf(datei,"@%s{%s",newType, card->mainkey);
 XtFree(newType);
 pos = ftell(datei);
 fprintf(datei,",\n");

 for (i=0; i<max_fields; i++) {
    if (!StringIsPeteEmpty(card->field[i]))
       pos = WriteLineToFile(datei, glbFldToName(i), card->field[i]);
 }
 h = card->ufield; 
 while (h) {
   if (!StringIsPeteEmpty(h->fldData)) 
      pos = WriteLineToFile(datei,h->fldName,h->fldData);    
   h = h->next;
 }   
 fseek(datei, pos, SEEK_SET);
 fprintf(datei,"\n}\n\n");
}



static int StringIsPeteEmpty(char *text)
{
 if (text == NULL || *text == '\0') return 1;
 return 0;
}



yyerror(char *s)
{

 fputs(s, stderr);
 putc('\n', stderr);
}

#ifdef BIFMAIN

int main(int argc, char *argv[])
{
 Bib bp;
 int erg, b1, i;
 Errcode err;

#ifdef YYDEBUG
       extern int yydebug;

       yydebug = 1;
#endif

 strcpy(bp.filepath, argv[1]);
 dbtGetFreeTreeIdx(&b1);
 bp.treeIdx = b1;
 err = bifFileRead(&bp);
 err = bifFileWrite(&bp);
}

#endif
