#ifndef __sgml_skip__
#define __sgml_skip__

#include "skip.hh"
#include "refcount.hh"
#include "tl_string_map.hh"

namespace afilter {

  template <typename T>
  class SgmlSkip : public RegionSkipTypes<T> {
  private:
    bool in_markup;
    char in_quote;
    bool new_token;
    string tag_name;
    string parm_name;
    enum InWhat {InKey, InValue, InValueNoSkip, InOther};
    InWhat in_what;

    RefCount<ToLowerStringMap> noskip_tags;
  public:
    SgmlSkip() {abort();}
    SgmlSkip(const ConfigData &); 
  
    string name() const {return "sgml";}
    double order_num() const {return .35;} 
  
    bool skip(char c, const Itr *);
  };
}

#endif
