//
// Notice the char buf[2]; the types must be correct to make this work right
//

#include "repl.hh"
#include "map_repl.hh"
#include "refcount.hh"

namespace afilter {

  template <typename InValue,  typename Value, 
    typename InString, typename String>
  class SubstrReplPair {
  public:
    InString key;
    String   value;
    typedef vector<InValue>::const_iterator            Iterator;
    typedef itr_equal<vector<InValue>::const_iterator> Endf;
    Iterator begin() const {return key.begin();}
    Endf     endf()  const {return key.end();}
    SubstrReplPair(const InValue * k, const Value * v)
    {for(;*k;++k)key.push_back(*k); for(;*v;++v)value.push_back(*v);}
  };

  template <typename T>
  class SubstrRepl : public CharReplTypes<T>, 
		     public MapReplBase<typename T::InValue, typename T::Value> 
  {
    typedef SubstrReplPair<InValue,Value,InString,String> Pair;
    typedef vector<Pair>                                  Con;
    RefCount<Con> con;

  public:
    SubstrRepl(const ConfigData *, const ReplOpts *) {}
    Base * clone() const {return new SubstrRepl(*this);}
    void assign(const Base * other) {*this = *(const SubstrRepl *)(other);}
  
    bool fill(InValue c, Itr * i, Buffer * buffer);
  
    void add (const InValue * key, const Value * value) 
    {con->push_back(Pair(key,value));}

    typedef Con::iterator       iterator;
    typedef Con::const_iterator const_iterator;
    const_iterator begin() const {return con->begin();}
    const_iterator end()   const {return con->end();}
  };

}
  
