#ifndef __autil_copy_ptr__
#define __autil_copy_ptr__

namespace autil {

  template <typename Class> 
  class CopyPtr {
  public:
    Class * ptr;
    bool    own;
    CopyPtr() : ptr(0), own(true) {}
    CopyPtr(Class * p, bool o = true) : ptr(p), own(o) {}
    CopyPtr(const CopyPtr & other);
    CopyPtr & operator= (const CopyPtr & other);
    Class & operator*  () const {return *ptr;}
    Class * operator-> () const {return ptr;}
    operator Class * () const {return ptr;}
    CopyPtr & operator=(Class * p) {ptr = p; return *this;}
    operator bool () const {return ptr;}
    ~CopyPtr();
  };

}

#endif

