/*   grep-dctrl - grep Debian control files
     Copyright (C) 1999  Antti-Juhani Kaijanaho
  
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
  
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details. 
  
     You should have received a copy of the GNU General Public License
     along with this program; see the file COPYING.  If not, write to
     the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
  
     The author can be reached via mail at (ISO 8859-1 charset for the city)
        Antti-Juhani Kaijanaho
        Helvintie 2 e as 9
        FIN-40500 JYVSKYL
        FINLAND
        EUROPE
     and via electronic mail from
        gaia@iki.fi
     If you have a choice, use the email address; it is more likely to
     stay current.

*/

#ifndef BUFFER_H__
#define BUFFER_H__

#include <stddef.h>

/* An ADT for a character buffer.  This buffer handles its own storage
   allocation.  */

#define BUFFER_MC 547

struct buffer_t {
  int magic_cookie;
  size_t buffer_len;
  size_t data_len;
  char * data;
};

typedef struct buffer_t * buffer;

#ifndef BUFFER_C__
extern buffer buffer_nomem;
#endif /* BUFFER_C__ */

/* Return a new buffer, initially containing an empty string.  If
   memory could not be allocated, buffer_nomem is returned.  */
buffer
new_buffer (void);

/* Append a character into buffer.  Return value is nonzero iff all
   went well.  Otherwise there was not enough memory for complying,
   and buf is unchanged.  */
inline static int
buffer_append (buffer buf, char c)
{
  int buffer_enlarge (buffer);

  assert (buf != 0);
  assert (buf->magic_cookie == BUFFER_MC);

  assert (buf->data_len <= buf->buffer_len);

  if (buf->data_len == buf->buffer_len)
    if (!buffer_enlarge (buf))
      return 0;

  assert (buf->data_len < buf->buffer_len);
  
  buf->data [buf->data_len++] = c;
  return 1;
}

/* Free all storage reserved for buf.  It will become invalid here.
   buf can be buffer_nomem, if necessary.  */
void
buffer_free (buffer buf);

/* Empty the buffer.  All storage allocated for its content will
   deallocated.  The buffer itself will remain valid, though.  */
void
buffer_empty (buffer buf);

/* Clear the buffer.  The buffer will be left taking as much space as
   before the call (this saves malloc/free calls), but the content
   will no longer be available.  */
void
buffer_clear (buffer buf);

/* Trim the buffer so that if its size is much larger than its
   content, the size gets trimmed into an ample space to hold the
   content.  This will not affect the content of buf, only the memory
   requirements of the buffer.  */
void
buffer_trim (buffer buf);

/* Return buf's contents as a null-terminated string that may get
   overwritten by the other buffer routines.  */
const char *
buffer_c_str (buffer buf);

/* Return buffer data length.  */
size_t
buffer_len (buffer buf);

/* Copy the contents of the buffer to cvec, which must have enough
   room for it.  */
void
buffer_data (buffer buf, char * cvec);

#endif /* BUFFER_H__ */
