/* test.c - MemTest-86  Version 2.2
 *
 * Copyright 1999,  Chris Brady
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee
 * is granted provided that the above copyright notice appears in all copies.
 * It is provided "as is" without express or implied warranty.
 */
#include "test.h"

extern int slock;
extern int segs, bail;
extern volatile long *p;
extern struct vars *v;

char spin[] = {'/', '-', '\\', '|'};

/*
 * Memory address test, walking ones
 */
void addr_tst1()
{
	register int i, j, k;
	volatile register long *p, *pt;
	volatile long *end;
	long bad, p1, mask, bank;

	do_spin(1);

	/* Test the global address bits */
	for (p1=0, j=0; j<2; j++) {
        	hprint(LINE_PAT, 9, p1);

		/* Set pattern in address 0x20000 */
		p = (long *)0x20000;
		*p = p1;
	
		/* Now write pattern complment */
		p1 = ~p1;
		end = v->map[segs-1].end;
		for (i=0; i<1000; i++) {
			mask = 4;
			while (mask < (long)end) {
				pt = (long *)((long)p | mask);
				if (pt == p) {
					mask = mask << 1;
					continue;
				}
				*pt = p1;
				if ((bad = *p) != ~p1) {
					ad_err1((long)p, (long)mask, bad, ~p1);
					i = 1000;
				}
				mask = mask << 1;
			}
		}
		do_spin(2);
		do_spin(0);
		
	}

	/* Now check the address bits in each bank */
	/* If we have more than 8mb of memory then the bank size must be */
	/* bigger than 256k.  If so use 1mb for the bank size. */
	if (v->lim_upper > 0x800000) {
		bank = 0x100000;
	} else {
		bank = 0x40000;
	}
	for (p1=0, k=0; k<2; k++) {
        	hprint(LINE_PAT, 9, p1);

		for (j=0; j<segs; j++) {
			if (!v->map[j].v) {
				continue;
			}
			p = (long *)v->map[j].start;
			/* Force start address to be a multiple of 256k */
			if (p && p < (long *)bank) {
				p = (long *)bank;
			}
			end = v->map[j].end;
			while (p < end) {
				*p = p1;

				p1 = ~p1;
				for (i=0; i<200; i++) {
					mask = 4;
					while (mask < (long)end) {
						pt = (long *)((long)p | mask);
						if (pt == p) {
							mask = mask << 1;
							continue;
						}
						*pt = p1;
						if ((bad = *p) != ~p1) {
							ad_err1((long)p,
							  (long)mask, bad, ~p1);
							i = 200;
						}
						mask = mask << 1;
					}
				}
				do_spin(2);
				p += bank;
				p1 = ~p1;
			}
		}
		do_spin(0);
		p1 = ~p1;
	}
}

/*
 * Memory address test, own address
 */
void addr_tst2()
{
	int j, done;
	volatile register long *p, *pe;
	volatile long *end, *start;
	long bad;

	do_spin(1);
       	cprint(LINE_PAT, 9, "           ");

	/* Write each address with it's own address */
	for (j=0; j<segs; j++) {
		if (!v->map[j].v) {
			continue;
		}
		start = v->map[j].start;
		end = v->map[j].end;
		pe = (long *)start;
		p = start;
		done = 0;
		do {
			/* Check for overflow */
			if (pe + SPINSZ > pe) {
				pe += SPINSZ;
			} else {
				pe = end;
			}
			if (pe >= end) {
				pe = end;
				done++;
			}
			for (; p < pe; p++) {
				*p = (long)p;
			}
			do_spin(2);
			BAILR
		} while (!done);
	}
	do_spin(0);

	/* Each address should have its own address */
	for (j=0; j<segs; j++) {
		if (!v->map[j].v) {
			continue;
		}
		start = v->map[j].start;
		end = v->map[j].end;
		pe = (long *)start;
		p = start;
		done = 0;
		do {
			/* Check for overflow */
			if (pe + SPINSZ > pe) {
				pe += SPINSZ;
			} else {
				pe = end;
			}
			if (pe >= end) {
				pe = end;
				done++;
			}
			for (; p < pe; p++) {
				if((bad = *p) != (long)p) {
					ad_err2((long)p, bad);
				}
			}
			do_spin(2);
			BAILR
		} while (!done);
	}
}

/*
 * Test all of memory using a "moving inversions" algorithm using the
 * pattern in p1 and it's complement in p2.
 */
void movinv1(int iter, long p1, long p2)
{
	int i, j, done;
	volatile long *p, *pe;
	volatile long *start,*end;
	long bad;

	/* Display the current pattern */
        hprint(LINE_PAT, 9, p1);

	/* Initialize memory with the initial pattern.  */
	do_spin(1);
	for (j=0; j<segs; j++) {
		if (!v->map[j].v) {
			continue;
		}
		start = v->map[j].start;
		end = v->map[j].end;
		pe = (long *)start;
		p = start;
		done = 0;
		do {
			/* Check for overflow */
			if (pe + SPINSZ > pe) {
				pe += SPINSZ;
			} else {
				pe = end;
			}
			if (pe >= end) {
				pe = end;
				done++;
			}
			for (; p < pe; p++) {
				*p = p1;
			}
			do_spin(2);
			BAILR
		} while (!done);
	}

	/* Do moving inversions test. Check for initial pattern and then
	 * write the complement for each memory location. Test from bottom
	 * up and then from the top down.  */
	for (i=0; i<iter; i++) {
		do_spin(0);
		for (j=0; j<segs; j++) {
			if (!v->map[j].v) {
				continue;
			}
			start = v->map[j].start;
			end = v->map[j].end;
			pe = (long *)start;
			p = start;
			done = 0;
			do {
				/* Check for overflow */
				if (pe + SPINSZ > pe) {
					pe += SPINSZ;
				} else {
					pe = end;
				}
				if (pe >= end) {
					pe = end;
					done++;
				}
				for (; p < pe; p++) {
					if ((bad=*p) != p1) {
						error((long*)p, p1, bad);
					}
					*p = p2;
				}
				do_spin(2);
				BAILR
			} while (!done);
		}
		do_spin(0);
		for (j=segs-1; j>=0; j--) {
			if (!v->map[j].v) {
				continue;
			}
			start = v->map[j].start;
			end = v->map[j].end;
			pe = end;
			p = --end;
			done = 0;
			do {
				/* Check for underflow */
				if (pe - SPINSZ < pe) {
					pe -= SPINSZ;
				} else {
					pe = start;
				}
				if (pe <= start) {
					pe = start;
					done++;
				}
				do {
					if ((bad=*p) != p2) {
						error((long*)p, p2, bad);
					}
					*p = p1;
				} while (p-- > pe);
				do_spin(2);
				BAILR
			} while (!done);
		}
	}
}

void movinv32(int iter, long p1, long lb, long hb, int sval, int off)
{
	register int i, j, k=0, n = 0, done;
	volatile register long *p, *pe;
	volatile long *start,*end;
	unsigned long pat, bad, p3;

	p3 = sval << 31;

	/* Display the current pattern */
	hprint(LINE_PAT, 9, p1);

	/* Initialize memory with the initial pattern.  */
	do_spin(1);
	for (j=0; j<segs; j++) {
		if (!v->map[j].v) {
			continue;
		}
		start = v->map[j].start;
		end = v->map[j].end;
		pe = (long *)start;
		p = start;
		done = 0;
		k = off;
		pat = p1;
		do {
			/* Check for overflow */
			if (pe + SPINSZ > pe) {
				pe += SPINSZ;
			} else {
				pe = end;
			}
			if (pe >= end) {
				pe = end;
				done++;
			}
			/* Do a SPINSZ section of memory */
			while (p < pe) {
				*p = pat;
				if (++k >= 32) {
					pat = lb;
					k = 0;
				} else {
					pat = pat << 1;
					pat |= sval;
				}
				p++;
			}
			do_spin(2);
			BAILR
		} while (!done);
	}

	/* Do moving inversions test. Check for initial pattern and then
	 * write the complement for each memory location. Test from bottom
	 * up and then from the top down.  */
	for (i=0; i<iter; i++) {
		do_spin(0);
		for (j=0; j<segs; j++) {
			if (!v->map[j].v) {
				continue;
			}
			start = v->map[j].start;
			end = v->map[j].end;
			pe = start;
			p = start;
			done = 0;
			k = off;
			pat = p1;
			do {
				/* Check for overflow */
				if (pe + SPINSZ > pe) {
					pe += SPINSZ;
				} else {
					pe = end;
				}
				if (pe >= end) {
					pe = end;
					done++;
				}
				while (p < pe) {
					if ((bad=*p) != pat) {
						error((long*)p, pat, bad);
					}
					*p = ~pat;
					if (++k >= 32) {
						pat = lb;
						k = 0;
					} else {
						pat = pat << 1;
						pat |= sval;
					}
					p++;
				}
				do_spin(2);
				BAILR
			} while (!done);
		}

		/* Since we already adjusted k and the pattern this
		 * code backs both up one step
		 */
		if (--k < 0) {
			k = 31;
		}
		for (pat = lb, n = 0; n < k; n++) {
			pat = pat << 1;
			pat |= sval;
		}
		k++;
		do_spin(0);
		for (j=segs-1; j>=0; j--) {
			if (!v->map[j].v) {
				continue;
			}
			start = v->map[j].start;
			end = v->map[j].end;
			p = --end;
			pe = end;
			done = 0;
			do {
				/* Check for underflow */
				if (pe - SPINSZ < pe) {
					pe -= SPINSZ;
				} else {
					pe = start;
				}
				if (pe <= start) {
					pe = start;
					done++;
				}
				do {
					if ((bad=*p) != ~pat) {
						error((long*)p, ~pat, bad);
					}
					*p = pat;
					if (--k <= 0) {
						pat = hb;
						k = 32;
					} else {
						pat = pat >> 1;
						pat |= p3;
					}
				} while (p-- > pe);
				do_spin(2);
				BAILR
			} while (!done);
		}
	}
}

/*
 * Test all of memory using modulo X access pattern.
 */
void modtst(int offset, int iter, long p1, long p2)
{
	int j, k, l, done;
	volatile register long *p, *pe;
	volatile long *start,*end;
	long bad;

	/* Display the current pattern */
        hprint(LINE_PAT, 9, p1);
	cprint(LINE_PAT, 17, "-");
        dprint(LINE_PAT, 18, offset, 2, 1);

	/* Write every nth location with pattern */
	do_spin(1);
	for (j=0; j<segs; j++) {
		if (!v->map[j].v) {
			continue;
		}
		start = v->map[j].start;
		end = v->map[j].end;
		pe = (long *)start;
		p = start+offset;
		done = 0;
		do {
			/* Check for overflow */
			if (pe + SPINSZ*16 > pe) {
				pe += SPINSZ*16;
			} else {
				pe = end;
			}
			if (pe >= end) {
				pe = end;
				done++;
			}
			for (; p < pe; p += 32) {
				*p = p1;
			}
			do_spin(2);
			BAILR
		} while (!done);
	}

	/* Write the rest of memory "iter" times with the pattern complement */
	for (l=0; l<iter; l++) {
		do_spin(0);
		for (j=0; j<segs; j++) {
			if (!v->map[j].v) {
				continue;
			}
			start = v->map[j].start;
			end = v->map[j].end;
			pe = (long *)start;
			p = start;
			done = 0;
			k = 0;
			do {
				/* Check for overflow */
				if (pe + SPINSZ > pe) {
					pe += SPINSZ;
				} else {
					pe = end;
				}
				if (pe >= end) {
					pe = end;
					done++;
				}
				for (; p < pe; p++) {
					if (k != offset) {
						*p = p2;
					}
					if (++k > 31) {
						k = 0;
					}
				}
				do_spin(2);
				BAILR
			} while (!done);
		}
	}

	/* Now check every nth location */
	do_spin(0);
	for (j=0; j<segs; j++) {
		if (!v->map[j].v) {
			continue;
		}
		start = v->map[j].start;
		end = v->map[j].end;
		pe = (long *)start;
		p = start+offset;
		done = 0;
		do {
			/* Check for overflow */
			if (pe + SPINSZ*16 > pe) {
				pe += SPINSZ*16;
			} else {
				pe = end;
			}
			if (pe >= end) {
				pe = end;
				done++;
			}
			for (; p < pe; p += 32) {
				if ((bad=*p) != p1) {
					error((long*)p, p1, bad);
				}
			}
			do_spin(2);
			BAILR
		} while (!done);
	}
}

/*
 * Display data error message. Don't display repeat duplicate errors.
 */
void error(long *adr, long good, long bad)
{
	static int cnt = 0;
	long xor;
	char buf[20];

	/* Check for keyboard input */
	check_input();

	xor = good ^ bad;

	/* Don't display duplicate errors */
	if (adr == v->eadr && xor == v->exor) {
		dprint(LINE_ERR, 72, ++(v->ecount), 6, 1);
		dprint(v->msg_line, 72, ++cnt, 5, 1);
		return;
	}

        /* Advance line for error message
         * If at the bottom of the screen, scroll */
        if (v->msg_line < 23) {
                v->msg_line++;
        } else {
		/* If scroll lock is on, loop till it is cleared */
		while (slock) {
			check_input();
		}
                scroll();
		ttyprint(23,0,"\n");
        }

	cnt = 1;
	strcpy(buf,"Err   - Addr:");
	buf[4] = v->test + '0';
	cprint(v->msg_line, 0, buf);
	hprint(v->msg_line, 13, (long)adr);
	cprint(v->msg_line, 23, "Good:");
	hprint(v->msg_line, 28, good);
	cprint(v->msg_line, 38, "Bad:");
	hprint(v->msg_line, 42, bad);
	cprint(v->msg_line, 52, "Xor:");
	hprint(v->msg_line, 56, xor);
	cprint(v->msg_line, 66, "Count:");
	dprint(v->msg_line, 72, cnt, 5, 1);
	v->eadr = adr;
	v->exor = xor;
	dprint(LINE_ERR, 72, ++(v->ecount), 6, 1);
}
	
/*
 * Display address error message.
 */
void ad_err1(long adr1, long adr2, long good, long bad)
{
	/* Check for keyboard input */
	check_input();

        /* Advance line for error message
         * If at the bottom of the screen, scroll */
        if (v->msg_line < 23) {
                v->msg_line++;
        } else {
		/* If scroll lock is on, loop till it is cleared */
		while (slock) {
			check_input();
		}
                scroll();
		ttyprint(23,0,"\n");
        }

	cprint(v->msg_line, 0, "Addrs Error - Addr:");
	hprint(v->msg_line, 19, (long)adr1);
	cprint(v->msg_line, 29, "Err_bit:");
	hprint(v->msg_line, 37, adr1 ^ adr2);
	cprint(v->msg_line, 47, "Good:");
	hprint(v->msg_line, 52, good);
	cprint(v->msg_line, 62, "Bad:");
	hprint(v->msg_line, 66, bad);
	dprint(LINE_ERR, 72, ++(v->ecount), 6, 1);
}

/*
 * Display address error message.
 */
void ad_err2(long adr, long bad)
{
	/* Check for keyboard input */
	check_input();

        /* Advance line for error message
         * If at the bottom of the screen, scroll */
        if (v->msg_line < 23) {
                v->msg_line++;
        } else {
		/* If scroll lock is on, loop till it is cleared */
		while (slock) {
			check_input();
		}
                scroll();
		ttyprint(23,0,"\n");
        }

	cprint(v->msg_line, 0, "Addrs Error - Addr:");
	hprint(v->msg_line, 19, (long)adr);
	cprint(v->msg_line, 29, "Good:");
	hprint(v->msg_line, 34, adr);
	cprint(v->msg_line, 44, "Bad:");
	hprint(v->msg_line, 48, bad);
	cprint(v->msg_line, 58, "Xor:");
	hprint(v->msg_line, 62, adr ^ bad);
	dprint(LINE_ERR, 72, ++(v->ecount), 6, 1);
}
	
/*
 * Display a spinning pattern to show progress
 */
void do_spin(int dots)
{
	static int s = 0, seq = 0;
	int i;
	long h, l, t;

	char *dptr = (char *)(SCREEN_ADR+(TITLE_WIDTH+1)*2);

	switch (dots) {
	case 0:
		seq++;
		cprint(0, TITLE_WIDTH+3+seq, ".");
		break;
	case 1:
		cprint(0, TITLE_WIDTH+3, ".         ");
		seq = 0;
		break;
	case 2:
		*dptr = spin[s]&0x7f;
		ttyprintc(0,18,spin[s]&0x7f);
		if (++s > 3) {
			s = 0;
		}
	}

	/* We can't do the elapsed time unless the rdtsc instruction
	 * is supported
	 */
	if (v->rdtsc) {
		asm __volatile__(
			"rdtsc":"=a" (l),"=d" (h));
		asm __volatile__ (
			"subl %2,%0\n\t"
			"sbbl %3,%1"
			:"=a" (l), "=d" (h)
			:"g" (v->startl), "g" (v->starth),
			"0" (l), "1" (h));
		t = h * ((unsigned)0xffffffff / v->clks_msec) / 1000;
		t += (l / v->clks_msec) / 1000;
		i = t % 60;
		dprint(0, TIMEX+10, i%10, 1, 0);
		dprint(0, TIMEX+9, i/10, 1, 0);
		t /= 60;
		i = t % 60;
		dprint(0, TIMEX+7, i % 10, 1, 0);
		dprint(0, TIMEX+6, i / 10, 1, 0);
		t /= 60;
		dprint(0, TIMEX, t, 5, 0);
	}

	/* Check for keyboard input */
	check_input();
}
