/*
 * dstore.c - Pyramid DC/OSx and Reliant UNIX global storage for lsof
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.10 99/06/22 08:11:51 abe Exp $";
#endif


#include "lsof.h"


int CloneMaj;				/* clone major device number (see
					 * HaveCloneMaj) */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *             (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {

#if	defined(RELIANTV)
	{ "cdev",	"cdevsw"		},
	{ "ncdev",	"cdevcnt"		},
#else	/* !defined(RELIANTV) */
	{ "clmaj",	"clone_no"		},
#endif	/* defined(RELIANTV) */

	{ X_NCACHE,	"ncache"		},
	{ X_NCSIZE,	"ncsize"		},
	{ "sgvnops",	"segvn_ops"		},
	{ "ttyfs",	"ttyfs_vnodeops"	},
	{ "",		""			},
	{ NULL,		NULL			}
};

char **Fsinfo = NULL;			/* file system information */
int Fsinfomax = 0;			/* maximum file system type */
int HaveCloneMaj = 0;			/* CloneMaj status */

#if	defined(RELIANTV) && defined(HASMIPCH)
int HaveMipcMaj = 0;			/* MipcMaj status */
int MipcMaj;				/* cdevsw["mibc"] major device number */
#endif	/* defined(RELIANTV) */ && defined(HASMIPCH)

int Kd = -1;				/* /dev/kmem file descriptor */

#if	defined(HASFSTRUCT)
/*
 * Pff_tab[] - table for printing file flags
 */

struct pff_tab Pff_tab[] = {
	{ (long)FREAD,		FF_READ		},
	{ (long)FWRITE,		FF_WRITE	},
	{ (long)FNDELAY,	FF_NDELAY	},
	{ (long)FAPPEND,	FF_APPEND	},
	{ (long)FSYNC,		FF_SYNC		},
	{ (long)FASYNC,		FF_ASYNC	},

# if	defined(FLARGEFILE)
	{ (long)FLARGEFILE,	FF_LARGEFILE	},
# endif	/* defined(FLARGEFILE) */

# if	defined(FSOCKET)
	{ (long)FSOCKET,	FF_SOCKET	},
# endif	/* defined(FSOCKET) */

# if	defined(FNOCTTY)
	{ (long)FNOCTTY,	FF_NOCTTY	},
# endif	/* defined(FNOCTTY) */

# if	defined(FRAIOSIG)
	{ (long)FRAIOSIG,	FF_RAIOSIG	},
# endif	/* defined(FRAIOSIG) */

	{ (long)FNONBLOCK,	FF_NBLOCK	},

# if	defined(FNBDRM)
	{ (long)FNBDRM,		FF_NBDRM	},
# endif	/* defined(FNBDRM) */

# if	defined(FBLKSEEK)
	{ (long)FBLKSEEK,	FF_BLKSEEK	},
# endif	/* defined(FBLKSEEK) */

# if	defined(FOLRMIRROR)
	{ (long)FOLRMIRROR,	FF_OLRMIRROR	},
# endif	/* defined(FOLRMIRROR) */

	{ (long)0,		NULL		}
};


/*
 * Pof_tab[] - table for print process open file flags
 */

struct pff_tab Pof_tab[] = {

# if	defined(FD_CLOEXEC)
	{ (long)FD_CLOEXEC,	POF_CLOEXEC	},
# endif	/* defined(FD_CLOEXEC) */

# if	defined(UF_FDLOCK)
	{ (long)UF_FDLOCK,	POF_FDLOCK	},
# endif	/* defined(UF_FDLOCK) */

	{ (long)0,		NULL		}
};
#endif	/* defined(HASFSTRUCT) */
