/*
    libparted - a library for manipulating disk partitions
    Copyright (C) 1998-2000  Andrew Clausen, Lennert Buytenhek and Red Hat Inc.

	Andrew Clausen			<clausen@gnu.org>
	Lennert Buytenhek		<buytenh@gnu.org>
	Matt Wilson, Red Hat Inc.	<msw@redhat.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include <parted/parted.h>

#include <libintl.h>
#if ENABLE_NLS
#  define _(String) gettext (String)
#else
#  define _(String) (String)
#endif /* ENABLE_NLS */

int
ped_assert (int cond, char* cond_text, char* file, int line, char* function)
{
	PedExceptionOption	opt;

	if (cond)
		return 1;

	/* FIXME: should force this exception */
	opt = ped_exception_throw (
		PED_EXCEPTION_BUG,
		PED_EXCEPTION_IGNORE_CANCEL,
		_("Assertion (%s) at %s:%d in function %s() failed."),
		cond_text, file, line, function);

	if (opt == PED_EXCEPTION_UNHANDLED) {
		printf (_("Assertion (%s) at %s:%d in function %s() failed."),
			cond_text, file, line, function);
		return 0;
	}

	return opt == PED_EXCEPTION_IGNORE;
}

