/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1998-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#include <assert.h>
#include "sets.h"

#ifndef ASSERT
#define ASSERT assert
#endif

    CharSet
    operator + ( const CharSet& set1, const CharSet& set2 )
    {
      CharSet set;
      set.set( (char*)&set1 );
      set.set( (char*)&set2 );
      return set;
    }

    void CharSet::setall()
    {
      for( int z = 0; z <= UCHAR_MAX; z++ ) data[z] = '*';
      data[UCHAR_MAX+1] = 0;
    };

    void CharSet::delall()
    {
      for( int z = 0; z <= UCHAR_MAX; z++ ) data[z] = '-';
      data[UCHAR_MAX+1] = 0;
    };


    void CharSet::set( const char* str )
    {
      int z;
      int sl = strlen( str );
      for( z = 0; z < sl; z++ )
        data[(unsigned char)(str[z])] = '*';
    };

    void CharSet::set( char ch )
    {
      data[(unsigned char)(ch)] = '*';
    };

    void CharSet::setr( char start, char end ) // set range
    {
      char s = ( start < end ) ? start : end;
      char e = ( start > end ) ? start : end;
      int z;
      for( z = s; z <= e; z++) data[z] = '*';
    }


    int CharSet::get( const char *str ) // return 1 if all str's chars are in the set
    {
      int z;
      int sl = strlen( str );
      for( z = 0; z < sl; z++ )
        if ( data[(unsigned char)(str[z])] == '*' ) return 0;
      return 1;
    };

    int CharSet::get( char ch ) // return 1 if `ch' is in the set
    {
      return ( data[(unsigned char)(ch)] == '*' );
    };


    void CharSet::del( const char* str )
    {
      int z;
      int sl = strlen( str );
      for( z = 0; z < sl; z++ )
        data[(unsigned char)(str[z])] = '-';
    };

    void CharSet::del( char ch )
    {
      data[(unsigned char)(ch)] = '-';
    };

    void CharSet::delr( char start, char end ) // set range
    {
      char s = ( start < end ) ? start : end;
      char e = ( start > end ) ? start : end;
      int z;
      for( z = s; z <= e; z++) data[z] = '-';
    }

    int CharSet::in( int pos ) // this can check outrange
    {
      if ( pos >= 0 && pos <= UCHAR_MAX ) return get( pos );
      return 0;
    }

 // eof sets.cpp
