/* Bluefish HTML Editor
 * bluefish.h - global prototypes live here
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __BLUEFISH_H_
#define __BLUEFISH_H_

#include <glib.h>
#include <gtk/gtkwidget.h>

/* The current version !!!!!! */
#define CURRENT_VERSION_NUMBER "0.3.5"
/* don't remove the version number out of this name again
   or I'll kill you.... ;-]
 */
#define CURRENT_VERSION_NAME "Bluefish 0.3.5 HTML editor"
/* You should probably edit configure.in too, when you update the
   version number. */

/* This is the type of each document */
typedef struct
  {
    gchar *filename;
    gint modified;
    unsigned del_txt_id;	/* Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com> */
    unsigned ins_txt_id;	/* undo/redo part is copied from gnotepad code */
    GList *undolist;
    GList *undotail;
    GList *redolist;
    GList *redotail;
    GtkWidget *textbox;
    GtkWidget *tab_label;
  }
filestruct;

/* This is the current project */
typedef struct
  {
    gint modified;
    gchar *filename;
    gchar *basedir;
    gchar *webdir;
    gchar *template;
    GList *fontlist;
    GList *urllist;
    GList *targetlist;
    GList *colorlist;
	 GList *dtdlist;
	 GList *classlist;
	 GList *metalist;
    GList *filenames;
  }
projectstruct;

typedef struct
  {
    projectstruct current_project;
    filestruct *current_document;	/* This is always the current visible one */
    GList *documentlist;	/* The documents are now placed in a Glist */
    GtkWidget *notebook;
    GtkWidget *statusbar;
    GtkWidget *main_window;
  }
mainstruct;

extern mainstruct *main_v;

/* for exiting bluefish */
void cya_later (GtkWidget * widget, gpointer data);

/* changes the current working directory to the directory of this filename */
gboolean change_dir (gchar * filename);

/* removes the first of a char in a string, making it a \0 */
gchar *trunc_on_char (gchar * string, gchar which_char);

/* strips the path of the filename */
char *strip_filename (gchar * string);

/* strips the path that is common for both files */
gchar *strip_common_path (char *image_fn, char *html_fn);
void window_close (GtkWidget * button, gpointer windowname);

/* returns 1 if the file is readable */
gint file_exists_and_readable (gchar * filename);

/* runs through all the events in the gtk and gdk queue */
void flush_queue (void);

/* this function starts a file select dialog, and returns the selected file
   or returns NULL if non selected */
gchar *return_file (gchar * set_file);

#endif	/* __BLUEFISH_H_ */

