/* Bluefish HTML Editor
 * menu.h - uhh, duh.
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MENU_H_
#define __MENU_H_

#include <locale.h>
#include <libintl.h>

#define _(STRING) gettext(STRING)
#ifdef gettext_noop
# define N_(Str) gettext_noop (Str)
#else
# define N_(Str) (Str)
#endif



#include <glib.h>
#include <gtk/gtkitemfactory.h>
/* add some internal include, where define file_open/file_new/etc */

/* I wish there was a better way to show he names of the different chars */
/* as in actually show them in parenthesis */
static GtkItemFactoryEntry menu_items[] =
{
  {N_("/_File"), NULL, NULL, 0, "<Branch>"},
  {N_("/File/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/File/_New"), "<control>N", file_new, 0, NULL},
  {N_("/File/_Open"), "<control>O", files_open, 0, NULL},
  {N_("/File/Open from the web"), NULL, open_from_web, 0, NULL},
  {N_("/File/Insert"), NULL, file_insert, 0, NULL},
  {N_("/File/sep1"), NULL, NULL, 0, "<Separator>"},
  {N_("/File/Weblint"), NULL, run_weblint, 0, NULL},
  {N_("/File/sep2"), NULL, NULL, 0, "<Separator>"},
  {N_("/File/_Save"), "<control>S", file_save, 0, NULL},
  {N_("/File/Save _as"), NULL, file_save_as, 0, NULL},
  {N_("/File/Save all"), NULL, file_save_all, 0, NULL},
  {N_("/File/sep3"), NULL, NULL, 0, "<Separator>"},
  {N_("/File/Close"), NULL, file_close, 0, NULL},
  {N_("/File/Close all"), NULL, file_close_all, 0, NULL},
  {N_("/File/sep4"), NULL, NULL, 0, "<Separator>"},
  {N_("/File/Quit"), "<control>Q", cya_later, 0, NULL},
  {N_("/_Project"), NULL, NULL, 0, "<Branch>"},
  {N_("/Project/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Project/Open"), "<control>P", project_open, 0, NULL},
  {N_("/Project/Close"), NULL, project_close, 0, NULL},
  {N_("/Project/Save"), NULL, project_save, 0, NULL},
  {N_("/Project/Save as"), NULL, project_save_as, 0, NULL},
  {N_("/Project/sep1"), NULL, NULL, 0, "<Separator>"},
  {N_("/Project/Edit"), NULL, project_edit, 0, NULL},
  {N_("/Project/sep2"), NULL, NULL, 0, "<Separator>"},
  {N_("/Project/Add current document"), NULL, project_add_document, 0, NULL},
  {N_("/Project/Add all open documents"), NULL, project_add_document, 1, NULL},
  {N_("/_Project/Files"), NULL, NULL, 0, "<Branch>"},
  {N_("/Project/Files/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/_Edit"), NULL, NULL, 0, "<Branch>"},
  {N_("/_Edit/Tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Edit/Cut"), "<control>x", cut_callback, 0, NULL},
  {N_("/Edit/Copy"), "<control>c", copy_callback, 0, NULL},
  {N_("/Edit/Paste"), "<control>v", paste_callback, 0, NULL},
  {N_("/Edit/sep1"), NULL, NULL, 0, "<Separator>"},
  {N_("/Edit/Select all"), NULL, sel_all_callback, 0, NULL},
  {N_("/Edit/sep2"), NULL, NULL, 0, "<Separator>"},
  {N_("/Edit/Go to line"), NULL, go_to_line_win, 0, NULL},
  {N_("/Edit/sep3"), NULL, NULL, 0, "<Separator>"},
  {N_("/Edit/Find"), "F6", search_search_cmd_callback, 0, NULL},
  {N_("/Edit/Find again"), "<shift>F6", search_again_cmd_callback, 0, NULL},
  {N_("/Edit/Replace"), "F7", search_replace_cmd_callback, 0, NULL},
  {N_("/Edit/sep3"), NULL, NULL, 0, "<Separator>"},
  {N_("/Edit/Undo"), "<control>z", undo_cb, 0, NULL},
  {N_("/Edit/Redo"), "<control>r", redo_cb, 0, NULL},
  {N_("/Edit/Undo all"), NULL, undo_all_cb, 0, NULL},
  {N_("/Edit/Redo all"), NULL, redo_all_cb, 0, NULL},
  {N_("/_View"), NULL, NULL, 0, "<Branch>"},
  {N_("/_View/Tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/View/View in _Netscape"), NULL, view_in_netscape, 0, NULL},
  {N_("/View/sep1"), NULL, NULL, 0, "<Separator>"},
  {N_("/View/Main toolbar"), NULL, toggle_main_toolbar, 0, "<ToggleItem>"},
  {N_("/View/HTML toolbar"), NULL, toggle_html_toolbar, 0, "<ToggleItem>"},
  {N_("/View/Custom toolbar"), NULL, toggle_cust_menubar, 0, "<ToggleItem>"},
  {N_("/View/sep2"), NULL, NULL, 0, "<Separator>"},
  {N_("/View/Preferences"), NULL, configure, 0, NULL},
  {N_("/_Tags"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Headings"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Headings/Tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Headings/H1"), NULL, general_html, 18, NULL},
  {N_("/Tags/Headings/H2"), NULL, general_html, 19, NULL},
  {N_("/Tags/Headings/H3"), NULL, general_html, 20, NULL},
  {N_("/Tags/Headings/H4"), NULL, general_html, 21, NULL},
  {N_("/Tags/Headings/H5"), NULL, general_html, 22, NULL},
  {N_("/Tags/Headings/H6"), NULL, general_html, 23, NULL},
  {N_("/Tags/Special"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Accent"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Accent/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Special/Accent/Uppercase"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Accent/Uppercase/A-I"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Accent/Uppercase/A-I/tearoff1"), NULL, NULL, 0,   "<Tearoff>"},
  {N_("/Tags/Special/Accent/Uppercase/A-I/A grave"), NULL, insert_char,   0, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/A acute"), NULL, insert_char,   1, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/A circumflex"), NULL,   insert_char, 2, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/A tilde"), NULL, insert_char,   3, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/AE ligature"), NULL,   insert_char, 4, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/A diaeresis"), NULL,   insert_char, 5, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/A ring"), NULL, insert_char,   6, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/C cedilla"), NULL, insert_char,   7, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/E grave"), NULL, insert_char,   8, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/E acute"), NULL, insert_char,   9, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/E circumflex"), NULL,   insert_char, 10, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/E diaeresis"), NULL,   insert_char, 11, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/I grave"), NULL, insert_char,   12, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/I acute"), NULL, insert_char,   13, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/I circumflex"), NULL,   insert_char, 14, NULL},
  {N_("/Tags/Special/Accent/Uppercase/A-I/I diaeresis"), NULL,   insert_char, 15, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/tearoff1"), NULL, NULL, 0,   "<Tearoff>"},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/N tilde"), NULL, insert_char,   16, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/O grave"), NULL, insert_char,   17, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/O acute"), NULL, insert_char,   18, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/O circumflex"), NULL,   insert_char, 19, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/O tilde"), NULL, insert_char,   20, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/O diaeresis"), NULL,   insert_char, 21, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/O slash"), NULL, insert_char,   22, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/U grave"), NULL, insert_char,   23, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/U acute"), NULL, insert_char,   24, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/U circumflex"), NULL,   insert_char, 25, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/U diaeresis"), NULL,
   insert_char, 26, NULL},
  {N_("/Tags/Special/Accent/Uppercase/J-Z/Y acute"), NULL, insert_char,
   27, NULL},
  {N_("/Tags/Special/Accent/Lowercase"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Accent/Lowercase/A-I"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Accent/Lowercase/A-I/tearoff1"), NULL, NULL, 0,
   "<Tearoff>"},
  {N_("/Tags/Special/Accent/Lowercase/A-I/a grave"), NULL, insert_char,
   28, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/a acute"), NULL, insert_char,
   29, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/a circumflex"), NULL,
   insert_char, 30, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/a tilde"), NULL, insert_char,
   31, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/a ring"), NULL, insert_char,
   32, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/ae ligature"), NULL,
   insert_char, 33, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/a diaeresis"), NULL,
   insert_char, 34, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/c cedilla"), NULL, insert_char,
   35, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/e grave"), NULL, insert_char,
   36, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/e acute"), NULL, insert_char,
   37, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/e circumflex"), NULL,
   insert_char, 38, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/e diaeresis"), NULL,
   insert_char, 39, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/i grave"), NULL, insert_char,
   40, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/i acute"), NULL, insert_char,
   41, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/i circumflex"), NULL,
   insert_char, 42, NULL},
  {N_("/Tags/Special/Accent/Lowercase/A-I/i diaeresis"), NULL,
   insert_char, 43, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/tearoff1"), NULL, NULL, 0,
   "<Tearoff>"},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/n tilde"), NULL, insert_char,
   44, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/o grave"), NULL, insert_char,
   45, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/o acute"), NULL, insert_char,
   46, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/o circumflex"), NULL,
   insert_char, 47, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/o tilde"), NULL, insert_char,
   48, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/o diaeresis"), NULL,
   insert_char, 49, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/o slash"), NULL, insert_char,
   50, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/u grave"), NULL, insert_char,
   51, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/u acute"), NULL, insert_char,
   52, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/u circumflex"), NULL,
   insert_char, 53, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/u diaeresis"), NULL,
   insert_char, 54, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/y acute"), NULL, insert_char,
   55, NULL},
  {N_("/Tags/Special/Accent/Lowercase/J-Z/y diaeresis"), NULL,
   insert_char, 56, NULL},
  {N_("/Tags/Special/Accent/separator"), NULL, NULL, 0, "<Separator>"},
  {N_("/Tags/Special/Accent/Umlaut"), NULL, insert_char, 57, NULL},
  {N_("/Tags/Special/Accent/Acute"), NULL, insert_char, 58, NULL},
  {N_("/Tags/Special/Accent/Cedilla"), NULL, insert_char, 59, NULL},
  {N_("/Tags/Special/Currency"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Currency/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Special/Currency/Cent sign"), NULL, insert_char,
   60, NULL},
  {N_("/Tags/Special/Currency/Pound sterling"), NULL, insert_char,
   61, NULL},
  {N_("/Tags/Special/Currency/Currency sign"), NULL, insert_char,
   62, NULL},
  {N_("/Tags/Special/Currency/Yen sign"), NULL, insert_char, 63, NULL},
  {N_("/Tags/Special/Math-Science"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Math-Science/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Special/Math-Science/Logical not sign"), NULL, insert_char,
   64, NULL},
  {N_("/Tags/Special/Math-Science/Multiplication sign"), NULL,
   insert_char, 65, NULL},
  {N_("/Tags/Special/Math-Science/Division sign"), NULL, insert_char,
   66, NULL},
  {N_("/Tags/Special/Math-Science/Plus-minus sign"), NULL, insert_char,
   67, NULL},
  {N_("/Tags/Special/Math-Science/Less-than sign"), NULL, insert_char,
   68, NULL},
  {N_("/Tags/Special/Math-Science/Greater-than sign"), NULL, insert_char,
   69, NULL},
  {N_("/Tags/Special/Math-Science/Superscript 1"), NULL, insert_char,
   70, NULL},
  {N_("/Tags/Special/Math-Science/Superscript 2"), NULL, insert_char,
   71, NULL},
  {N_("/Tags/Special/Math-Science/Superscript 3"), NULL, insert_char,
   72, NULL},
  {N_("/Tags/Special/Math-Science/One quarter"), NULL, insert_char,
   73, NULL},
  {N_("/Tags/Special/Math-Science/One half"), NULL, insert_char,
   74, NULL},
  {N_("/Tags/Special/Math-Science/Three quarters"), NULL, insert_char,
   75, NULL},
  {N_("/Tags/Special/Math-Science/Degree sign"), NULL, insert_char,
   76, NULL},
  {N_("/Tags/Special/Non Latin"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Non Latin/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Special/Non Latin/ETH (Icelandic)"), NULL, insert_char,
   77, NULL},
  {N_("/Tags/Special/Non Latin/THORN (Icelandic)"), NULL, insert_char,
   78, NULL},
  {N_("/Tags/Special/Non Latin/eth (Icelandic)"), NULL, insert_char,
   79, NULL},
  {N_("/Tags/Special/Non Latin/thorn"), NULL, insert_char, 80, NULL},
  {N_("/Tags/Special/Non Latin/Sharp s"), NULL, insert_char, 81, NULL},
  {N_("/Tags/Special/Non Latin/Micro sign"), NULL, insert_char,
   82, NULL},
  {N_("/Tags/Special/Other"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Special/Other/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Special/Other/Non-breaking space"), NULL, insert_char,
   83, NULL},
  {N_("/Tags/Special/Other/Section sign"), NULL, insert_char,
   84, NULL},
  {N_("/Tags/Special/Other/Copyright sign"), NULL, insert_char,
   85, NULL},
  {N_("/Tags/Special/Other/Left angle quotes"), NULL, insert_char,
   86, NULL},
  {N_("/Tags/Special/Other/Right angle quotes"), NULL, insert_char,
   87, NULL},
  {N_("/Tags/Special/Other/Registered trademark"), NULL, insert_char,
   88, NULL},
  {N_("/Tags/Special/Other/Inverted exclamation"), NULL, insert_char,
   89, NULL},
  {N_("/Tags/Special/Other/Inverted question mark"), NULL, insert_char,
   90, NULL},
  {N_("/Tags/Special/Other/Feminine ordinal"), NULL, insert_char,
   91, NULL},
  {N_("/Tags/Special/Other/Masculine ordinal"), NULL, insert_char,
   92, NULL},
  {N_("/Tags/Special/Other/Pilcrow (paragraph sign)"), NULL, insert_char,
   93, NULL},
  {N_("/Tags/Special/Other/Broken bar"), NULL, insert_char, 94, NULL},
  {N_("/Tags/Special/Other/Soft hypen"), NULL, insert_char, 95, NULL},
  {N_("/Tags/Special/Other/Spacing macron"), NULL, insert_char,
   96, NULL},
  {N_("/Tags/Special/Other/Middle dot"), NULL, insert_char,
   97, NULL},
  {N_("/Tags/Formatting"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Formatting/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Formatting/Bold"), NULL, general_html, 1, NULL},
  {N_("/Tags/Formatting/Italic"), NULL, general_html, 2, NULL},
  {N_("/Tags/Formatting/Underline"), NULL, general_html, 3, NULL},
  {N_("/Tags/Formatting/Strikeout"), NULL, general_html, 4, NULL},
  {N_("/Tags/Formatting/Strong"), NULL, general_html, 16, NULL},
  {N_("/Tags/Formatting/Emphasis"), NULL, general_html, 17, NULL},
  {N_("/Tags/Formatting/<separator>"), NULL, NULL, 0, "<Separator>"},
  {N_("/Tags/Formatting/Paragraph"), NULL, general_html, 5, NULL},
  {N_("/Tags/Formatting/Break"), NULL, general_html, 6, NULL},
  {N_("/Tags/Formatting/Break clear all"), NULL, general_html, 41, NULL},
  {N_("/Tags/Formatting/Non-Breaking Space"), NULL, general_html, 7, NULL},
  {N_("/Tags/Formatting/<separator>"), NULL, NULL, 0, "<Separator>"},
  {N_("/Tags/Formatting/Font Size +1"), NULL, general_html, 11, NULL},
  {N_("/Tags/Formatting/Font Size -1"), NULL, general_html, 12, NULL},
  {N_("/Tags/Formatting/<separator>"), NULL, NULL, 0, "<Separator>"},
  {N_("/Tags/Formatting/Preformatted Text"), NULL, general_html, 13, NULL},
  {N_("/Tags/Formatting/Subscript"), NULL, general_html, 14, NULL},
  {N_("/Tags/Formatting/Superscript"), NULL, general_html, 15, NULL},
  {N_("/Tags/Formatting/<separator>"), NULL, NULL, 0, "<Separator>"},
  {N_("/Tags/Formatting/Center"), NULL, general_html, 8, NULL},
  {N_("/Tags/Formatting/Align right"), NULL, general_html, 9, NULL},
  {N_("/Tags/Formatting/<separator>"), NULL, NULL, 0, "<Separator>"},
  {N_("/Tags/Formatting/Comment"), NULL, general_html, 10, NULL},
  {N_("/Tags/Table"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/Table/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/Table/Table"), NULL, general_html, 24, NULL},
  {N_("/Tags/Table/Tablerow"), NULL, general_html, 25, NULL},
  {N_("/Tags/Table/Tableheader"), NULL, general_html, 26, NULL},
  {N_("/Tags/Table/Tabledata"), NULL, general_html, 27, NULL},
  {N_("/Tags/Table/Tablecaption"), NULL, general_html, 28, NULL},
  {N_("/Tags/List"), NULL, NULL, 0, "<Branch>"},
  {N_("/Tags/List/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Tags/List/Unordered list"), NULL, general_html, 33, NULL},
  {N_("/Tags/List/Ordered list"), NULL, general_html, 34, NULL},
  {N_("/Tags/List/List item"), NULL, general_html, 35, NULL},
  {N_("/Tags/List/Definition list"), NULL, general_html, 36, NULL},
  {N_("/Tags/List/Definition term"), NULL, general_html, 37, NULL},
  {N_("/Tags/List/Definition"), NULL, general_html, 38, NULL},
  {N_("/Tags/List/menu"), NULL, general_html, 39, NULL},
  {N_("/_Dialogs"), NULL, NULL, 0, "<Branch>"},
  {N_("/Dialogs/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Dialogs/General"), NULL, NULL, 0, "<Branch>"},
  {N_("/Dialogs/General/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Dialogs/General/Quickstart"), NULL, quickstart, 0, NULL},
  {N_("/Dialogs/General/DTD"), NULL, dtd, 0, NULL},
  {N_("/Dialogs/General/Head"), NULL, head, 0, NULL},
  {N_("/Dialogs/General/Body"), NULL, body, 0, NULL},
  {N_("/Dialogs/General/Anchor"), NULL, quickanchor, 0, NULL},
  {N_("/Dialogs/General/Email"), NULL, email, 0, NULL},
  {N_("/Dialogs/General/Rule"), NULL, quickrule, 0, NULL},
  {N_("/Dialogs/General/Font"), NULL, fontdialog, 0, NULL},
  {N_("/Dialogs/General/Basefont"), NULL, basefont, 0, NULL},
  {N_("/Dialogs/General/Quicklist"), NULL, quicklist, 0, NULL},
  {N_("/Dialogs/General/Meta"), NULL, meta, 0, NULL},
  {N_("/Dialogs/General/Embed"), NULL, embed, 0, NULL},
  {N_("/Dialogs/General/Select colour"), NULL, sel_colour, 0, NULL},
  {N_("/Dialogs/General/Insert time"), NULL, insert_time, 0, NULL},
  {N_("/Dialogs/General/Insert image"), NULL, image_insert_dialog, 0, NULL},
  {N_("/Dialogs/General/Insert thumbnail"), NULL, image_thumbnail_dialog,0, NULL},
  {N_("/Dialogs/Table"), NULL, NULL, 0, "<Branch>"},
  {N_("/Dialogs/Table/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Dialogs/Table/Table"), NULL, tabledialog, 0, NULL},
  {N_("/Dialogs/Table/Tablerow"), NULL, tablerowdialog, 0, NULL},
  {N_("/Dialogs/Table/Tableheader"), NULL, tableheaderdialog, 0, NULL},
  {N_("/Dialogs/Table/Tabledata"), NULL, tabledatadialog, 0, NULL},
  {N_("/Dialogs/CSS"), NULL, NULL, 0, "<Branch>"},
  {N_("/Dialogs/CSS/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Dialogs/CSS/Create style"), NULL, insert_in_stylesheet, 0, NULL},
  {N_("/Dialogs/CSS/Span"), NULL, insert_span, 0, NULL},
  {N_("/Dialogs/CSS/Div"), NULL, insert_div, 0, NULL},
  {N_("/Dialogs/CSS/Add class"), NULL, insert_class, 0, NULL},
  {N_("/Dialogs/CSS/Style"), NULL, general_html, 42, NULL},
  {N_("/Dialogs/CSS/Link to stylesheet"), NULL, general_html, 46, NULL},
  {N_("/Dialogs/Frame"), NULL, NULL, 0, "<Branch>"},
  {N_("/Dialogs/Frame/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Dialogs/Frame/Frameset"), NULL, framesetdialog, 0, NULL},
  {N_("/Dialogs/Frame/Frame"), NULL, framedialog, 0, NULL},
  {N_("/Dialogs/Form"), NULL, NULL, 0, "<Branch>"},
  {N_("/Dialogs/Form/tearoff1"), NULL, NULL, 0, "<Tearoff>"},
  {N_("/Dialogs/Form/Form"), NULL, formdialog, 0, NULL},
  {N_("/Dialogs/Form/Submit"), NULL, submitdialog, 0, NULL},
  {N_("/Dialogs/Form/Reset"), NULL, resetdialog, 0, NULL},
  {N_("/Dialogs/Form/Text"), NULL, textdialog, 0, NULL},
  {N_("/Dialogs/Form/Hidden"), NULL, hiddendialog, 0, NULL},
  {N_("/Dialogs/Form/Textarea"), NULL, textareadialog, 0, NULL},
  {N_("/Dialogs/Form/Radio buttons"), NULL, radiodialog, 0, NULL},
  {N_("/Dialogs/Form/Check buttons"), NULL, checkdialog, 0, NULL},
  {N_("/Dialogs/Form/Select"), NULL, selectdialog, 0, NULL}
};

static gchar *sp_chars[] =
{
  "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&AElig;",
  "&Auml;", "&Aring;", "&Ccedil;", "&Egrave;", "&Eacute;",
  "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;",
  "&Iuml;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;",
  "&Otilde;", "&Ouml;", "&Oslash;", "&Ugrave;", "&Uacute;",
  "&Ucirc;", "&Uuml;", "&Yacute;", "&agrave;", "&aacute;",
  "&acirc;", "&atilde;", "&aring;", "&aelig;", "&auml;",
  "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;",
  "&igrave;", "&iacute;", "&icircumflex;", "&iuml;", "&ntilde;",
  "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;",
  "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;",
  "&yacute;", "&yuml;", "&uml;", "&acute;", "&cedil;", "&cent;",
  "&pound;", "&curren;", "&yen;", "&not;", "&mult;", "&divide;",
  "&plusmn;", "&lt;", "&gt;", "&sup1;", "&sup2;", "&sup3;",
  "&frac14;", "&frac12;", "&frac34;", "&deg;", "&ETH;", "&THORN;",
  "&eth;", "&thorn;", "&szlig;", "&micro;", "&nbsp;", "&sect;",
  "&copy;", "&laquo;", "&raquo;", "&reg;", "&iexcl;", "&iquest;",
  "&ordf;", "&ordm;", "&para;", "&brvbar;", "&shy;", "&macr;",
  "&middot;"
};

#endif	/* __MENU_H_ */

