<?php
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: bookmarker.inc,v 1.17 1999/08/21 02:49:28 prenagha Exp $
# ---------------------------------------------------------------
# the following class sets various configuration variables
# used throughout the application.
class bookmarker_class  {
  var $version        = "1.6";

# used for quik-mark bookmark
  var $create_url     = "http://mydomain.com/bk/create.php3";

# used for mail-this-link bookmark
  var $maillink_url   = "http://mydomain.com/bk/maillink.php3";

# directory where FastTemplate templates are located on this server
  var $template_dir   = "/home/httpd/lib/bklib/templates";

# image URL - string added to the begining of an image file
# (for example, I set this to "./images/" which makes bookmarker
# build image URLs like <img src="./images/mailto.gif"...)
  var $image_url_prefix = "./images/";

# URL format checking. bookmarker can check the format of
# URLs entered on the create/maintain pages. This option
# lets you control this checking. Possible values:
#  0 = no checking of URL format
#  1 = URL format is checked, problems reported as warnings
#  2 = URL format is checked, problems reported as errors
  var $url_format_check = 2;

# determine if the FastTemplate intepretation is strict or
# not strict. Strict shows the {VAR_NAME} in the output HTML
# if a value is not substituted - this is useful for debugging
# and testing
  var $FastTemplate_strict = FALSE;
	
# how many URLs to show per page on the plain list page
# NOTE: If your database doesn't support the "LIMIT offset, rows"
# statement, set this to zero. In that case the LIMIT clause
# won't be added to the SQL. You will get all bookmarks on a
# single plain list page.
  var $urls_per_page  = 10;
	
# set these if you want to allow guest users access to 
# someone's bookmarks. NOTE: guest_password does NOT set
# the password for the guest user, you still need to do that
# using the user.php3 page - the guest_password is specified
# here so that it can be displayed on the login form.
  var $guest_user     = "guest";
  var $guest_password = "guest";
  var $guest_user_select_user = "bk";

# how many characters after the scheme(http://) and hostname 
# (www.mydomain.com) to match when checking for possible
# duplicates on the create page.
# Zero means to just match on scheme and hostname - this is 
# what I prefer.
  var $possible_dup_chars = 0;
		
# level of access required for user to use the mail-this-link
# page. The default is to only allow registered users to send
# email using bookmarker - anything else is asking for abuse!
# if you allow guest, you may want to bcc yourself by using the
# site header variable below.
  var $mail_this_link_permission_required = "editor";

# the following wording is automatically added to all outgoing
# mail-this-link email messages
  var $site_footer = "--\nThis message sent from the bookmarker bookmark manager\nat http://$SERVER_NAME$PHP_SELF\nPlease contact the server administrator at\n$SERVER_ADMIN to report abuse of this service.";

# this var controls the headers that are added to the mail-this-link
# email message. You may choose to bcc: yourself, record the senders IP...
# the headers should be separated by a newline ("\n")
  var $site_headers = "X-Sender: bookmarker at $SERVER_NAME\nX-Sender-IP: $REMOTE_ADDR";

# this var controls if the bookmarker links (start, create, search...)
# are displayed in the tree view. NOTE: these links are only displayed
# if 'group by category/subcategory' is also selected.
  var $show_bk_in_tree = 0; # set to 0 for 'off' 1 for 'on'
}

# instantiate the bookmarker class so we can access
# the variables.
$bookmarker = new bookmarker_class;

# every bookmarker page uses the FastTemplate class
# to generate HTML.
$tpl = new FastTemplate($bookmarker->template_dir);

if (! $bookmarker->FastTemplate_strict ) {
  $tpl->no_strict();
}

# create an instance of the data validation class
$validate = new Validator ();
?>
