#include <strings.h>
#include <gtk/gtk.h>
#include "alert.h"

#include "url.h"

guint alert_get_type(void);
static void alert_class_init (AlertClass *class);
static void alert_init (Alert *b);
GtkWidget* alert_new ();
void alert_dismiss(GtkWidget *widget, gpointer data);

guint
alert_get_type ()
{
  static guint b_type = 0;

  if (!b_type)
    {
      GtkTypeInfo b_info =
      {
        "Alert",
        sizeof (Alert),
        sizeof (AlertClass),
        (GtkClassInitFunc) alert_class_init,
        (GtkObjectInitFunc) alert_init,
        (GtkArgSetFunc) NULL,
        (GtkArgGetFunc) NULL,
      };

      b_type = gtk_type_unique (gtk_window_get_type(), &b_info);
    }

  return b_type;
}
enum {
  LAST_SIGNAL
};

/*static gint alert_signals[LAST_SIGNAL] = { 0 };*/

static void
alert_class_init (AlertClass *class)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass*) class;
  
/*
  gtk_object_class_add_signals (object_class, alert_signals, LAST_SIGNAL);
*/

  class->alert = NULL;
}

static void
alert_init (Alert *a)
{
#if 0
  GtkWidget *ok_button;
  GtkWidget *msg_label;

  msg_label = gtk_label_new(a->msg);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a)->vbox), msg_label,
                     TRUE, TRUE, 0);
  gtk_widget_show(msg_label);

  ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a)->action_area), ok_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok_button), "pressed",
                      GTK_SIGNAL_FUNC (alert_dismiss), a);
  gtk_widget_show(ok_button);
#endif
}

GtkWidget*
alert_new (char *msg)
{
  Alert *alert;
  GtkWidget *vbox;
  GtkWidget *msg_label;
  GtkWidget *separator;
  GtkWidget *ok_button;

  alert = gtk_type_new(alert_get_type());
  strcpy(alert->msg, msg);

  vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(alert), vbox);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);
  gtk_widget_show(vbox);

  msg_label = gtk_label_new(alert->msg);
  gtk_box_pack_start(GTK_BOX(vbox), msg_label,
                     TRUE, TRUE, 0);
  gtk_widget_show(msg_label);

  separator = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);

  ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(vbox), ok_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok_button), "pressed",
                      GTK_SIGNAL_FUNC (alert_dismiss), alert);
  gtk_widget_show(ok_button);

  return GTK_WIDGET (alert);
}

void alert_dismiss(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

