/* 
   sitecopy, manage remote web sites.
   Copyright (C) 1998-99, Joe Orton <joe@orton.demon.co.uk>.
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: common.c,v 1.12.2.1 1999/07/20 12:53:58 joe Exp $
*/

#include <config.h>

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif 
#include <stdarg.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */

#ifndef HAVE_SNPRINTF
#include "snprintf.h"
#endif /* HAVE_SNPRINTF */

#include "common.h"
#include "md5.h"

#ifdef ENABLE_NLS
#include <libintl.h>
#define _(str) gettext(str)
#else
#define _(str) str
#endif /* ENABLE_NLS */

int debug_mask;

void debug( int ch, char *template, ...) {
#ifdef DEBUGGING
    va_list params;
    if( (ch&debug_mask) != ch ) return;
    fflush( stdout );
    va_start( params, template );
    vfprintf( stderr, template, params );
    va_end( params );
#else
    /* No debugging here */
#endif
}

#ifndef HAVE_STRDUP

char *strdup( const char *s ) {
    char *new;
    new = malloc( strlen(s) + 1 );
    if( new != NULL ) {
	strcpy( new, s );
    }
    return new;
}

#endif

/* Snagged from fetchmail */
# if !HAVE_STRERROR && !defined(strerror)
char *strerror (errnum)
     int errnum;
{
  extern char *sys_errlist[];
  extern int sys_nerr;

  if (errnum > 0 && errnum <= sys_nerr)
    return sys_errlist[errnum];
  return _("Unknown system error");
}
# endif /* HAVE_STRERROR */

/* This from wget */
#define HEXD2asc(x) (((x) < 10) ? ((x) + '0') : ((x) - 10 + 'a'))

/* Writes the ASCII representation of the MD5 digest into the
 * given buffer, which must be at least 33 characters long. */
void md5_hexify( unsigned char md5_buf[16], char *buffer ) {
    int count;
    for( count = 0; count<16; count++ ) {
	buffer[count*2] = HEXD2asc( md5_buf[count] >> 4 );
	buffer[count*2+1] = HEXD2asc( md5_buf[count] & 0x0f );
    }
    buffer[32] = '\0';
}
