/*** PROPERTIES.C: Contains routines that update data taken from
                       window properties in the UltimateContexts ***/

/* ########################################################################

   uwm - THE ude WINDOW MANAGER

   ########################################################################

   Copyright (c) : Christian Ruppert

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "uwm.h"
#include "windows.h"
#include "init.h"

extern UDEScreen TheScreen;
extern Display *disp;
extern InitStruct InitS;
extern UltimateContext *ActiveWin;
extern Atom WM_TAKE_FOCUS;
extern Atom WM_DELETE_WINDOW;
extern Atom MOTIF_WM_HINTS;

/*** Updatera will update the given uc's ra structure, leaves the x,y,r,h-members untouched. ***/

void Updatera(UltimateContext *uc)
{
  XSizeHints sizehints;
  long supplied;

  if(!XGetWMNormalHints(disp,uc->win,&sizehints,&supplied)){
    sizehints.flags=0;
    uc->status|=PLACEIT;
  }

  UpdateUWMContext(uc);

  if(uc->frame != None) {
    if(((uc->Attr.x+uc->Attr.width)>(TheScreen.width+uc->BorderWidth))||\
       ((uc->Attr.y+uc->Attr.height)>(TheScreen.height+uc->BorderWidth))||\
       ((long)uc->Attr.y<(long)(0-uc->BorderWidth-TheScreen.TitleHeight))||\
       ((long)uc->Attr.x<(long)(0-uc->BorderWidth))){
      uc->status |=PLACEIT;
      if((uc->Attributes.class==InputOutput)&&\
         (!(uc->status&(ICONIFIED|MAPPED|KEEPMAPPED)))){
        XMoveWindow(disp,uc->frame,(TheScreen.width-uc->Attr.width)/2,\
                                 (TheScreen.height-uc->Attr.height)/2);
        UpdateUWMContext(uc);
      }
    }
  } else {
    if(((uc->Attributes.x+uc->Attributes.width)>TheScreen.width)||\
       ((uc->Attributes.y+uc->Attributes.height)>TheScreen.height)||\
       (uc->Attributes.x<0)||(uc->Attributes.y<0)){
      uc->status |=PLACEIT;
      if((uc->Attributes.class==InputOutput)&&
         (!(uc->status&(ICONIFIED|MAPPED|KEEPMAPPED)))){
        XMoveWindow(disp,uc->win,(TheScreen.width-uc->Attributes.width)/2,\
                               (TheScreen.height-uc->Attributes.height)/2);
        UpdateUWMContext(uc);
      }
    }
  }

  if(sizehints.flags & USPosition) {
    uc->status&=~PLACEIT;
    uc->ra.x=sizehints.x;
    uc->ra.y=sizehints.y;
  }

  if(sizehints.flags & PResizeInc) {
    uc->ra.wi=sizehints.width_inc;
    uc->ra.hi=sizehints.height_inc;
  } else uc->ra.wi=uc->ra.hi=1;

  if(sizehints.flags & PBaseSize) {
    uc->ra.bw=sizehints.base_width+2*uc->BorderWidth;
    uc->ra.bh=sizehints.base_height+2*uc->BorderWidth+TheScreen.TitleHeight;
  } else {
    uc->ra.bw=uc->Attributes.width+2*uc->BorderWidth;
    uc->ra.bh=uc->Attributes.height+2*uc->BorderWidth+TheScreen.TitleHeight;
  }
  while(uc->ra.bw>0) uc->ra.bw-=uc->ra.wi;
  while(uc->ra.bh>0) uc->ra.bh-=uc->ra.hi;

  if(sizehints.flags & PMinSize) {
    uc->ra.minw=sizehints.min_width+2*uc->BorderWidth;
    uc->ra.minh=sizehints.min_height+2*uc->BorderWidth+TheScreen.TitleHeight;
  } else {
    uc->ra.minw=2*uc->BorderWidth+1;
    uc->ra.minh=2*uc->BorderWidth+TheScreen.TitleHeight+1;
  }
  if(sizehints.flags &PMaxSize) {
    uc->ra.maxw=sizehints.max_width+2*uc->BorderWidth;
    uc->ra.maxh=sizehints.max_height+2*uc->BorderWidth+TheScreen.TitleHeight;
  } else {
    uc->ra.maxw=TheScreen.width+1;
    uc->ra.maxh=TheScreen.height+1;
  }
}

void UpdateName(UltimateContext *uc)
{
  char *name;    /* need that or gvim will crash uwm. */
  if(!XFetchName(disp,uc->win,&name)) return;
  if(uc->name) XFree(uc->name);
  uc->name=name;
  if(uc->title!=None){
    if(uc->name) {
      XResizeWindow(disp,uc->title,uc->TitleWidth=(XTextWidth(TheScreen.\
                                   TitleFont,uc->name,strlen(uc->name))+\
                      ((InitS.BorderTitleFlags & BT_CENTER_TITLE)?9:6)),\
                            uc->TitleHeight=TheScreen.TitleFont->ascent+\
                                         TheScreen.TitleFont->descent+3);
      if(InitS.BorderTitleFlags & BT_CENTER_TITLE)
        XMoveWindow(disp, uc->title, (uc->Attr.width-uc->TitleWidth)/2 ,\
                    (uc->BorderWidth-TheScreen.desktop.FrameBevelWidth-1) / 2\
                    + TheScreen.desktop.FrameBevelWidth);
      DrawTitle(uc,uc==ActiveWin);
    } else XResizeWindow(disp,uc->title,0,0);
  }
  DBG(fprintf(TheScreen.errout,"Window Name: %s\n",uc->name);)
}

void UpdateWMHints(UltimateContext *uc)
{
  if(uc->WMHints) XFree(uc->WMHints);
  uc->WMHints=XGetWMHints(disp,uc->win);
}

void UpdateMotifHints(UltimateContext *uc)
{
  int format;
  Atom type;
  unsigned long n;
  if(uc->MotifWMHints) XFree(uc->MotifWMHints);
  if(Success!=XGetWindowProperty(disp, uc->win, MOTIF_WM_HINTS, 0,
                                 PROP_MWM_HINTS_ELEMENTS, False, MOTIF_WM_HINTS,
                                 &type, &format, &n, &n,
                                 (unsigned char **)&uc->MotifWMHints))
    uc->MotifWMHints=NULL;
  if(uc->frame) {
    DisenborderWin(uc,True);
    EnborderWin(uc);
  }
}

void UpdateWMProtocols(UltimateContext *uc)
{
  Atom *prots;
  int count,a;

  uc->ProtocolFlags=0;
  if(XGetWMProtocols(disp,uc->win,&prots,&count)) {
    for(a=0;a<count;a++){
      if(prots[a]==WM_TAKE_FOCUS)    uc->ProtocolFlags|=TAKE_FOCUS;
      if(prots[a]==WM_DELETE_WINDOW) uc->ProtocolFlags|=DELETE_WINDOW;
    }
    XFree(prots);
  }
}
