/* Shared definitions for GNU wdiff.
   Copyright (C) 1994, 1997 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef SYSTEM_H
#define SYSTEM_H

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <assert.h>
#include <sys/types.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <string.h>
#if HAVE_STRINGS_H
#include <strings.h>
#endif
#if HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include <signal.h>
#include <pwd.h>
#include <math.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#if HAVE_SYS_UTSNAME_H
# include <sys/utsname.h>
#endif

#if HAVE_SYS_SYSINFO_H
# include <sys/sysinfo.h>
#endif

#if WITHTHREAD
# include <pthread.h>
#endif

#if HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif
#if HAVE_SELECT_H
# include <select.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>

#ifndef LINUX_SPARC
# include <arpa/inet.h>
#endif

#if HAVE_FLOATINGPOINT_H
#include <floatingpoint.h>
/*
#ifndef HAVE_FPSETMASK
#define HAVE_FPSETMASK
#endif
*/
#endif

#include <netdb.h>

#include "have.h"

#ifdef SUNOS
#define FORMATPTR	"%x"
#else
#define FORMATPTR	"%p"
#endif

#endif /* SYSTEM_H */
