#include "global.h"
#include "parse.h"
#include "move.h"


/* animator parser */
Private
void animatorParser(char *l, WObject *panim)
{
  char *w;
  Fileline str;

  l = parseName(l, panim->ext.animator.named, panim->ext.animator.name);
  w = parseFileLine(l);
  w = parsePosition(w, panim);
  panim->ext.animator.state = atoi(w);
  if (panim->ext.animator.state == 1) {
    struct timeval te;

    gettimeofday(&te, NULL);
    panim->ext.animator.sec = te.tv_sec;
    panim->ext.animator.usec = te.tv_usec;
  }
  w = strtok(NULL, SEP);
  panim->ext.animator.nb_frames = atoi(w);
  w = strtok(NULL, SEP);
  panim->ext.animator.frame = (atoi(w) % panim->ext.animator.nb_frames);
  w = strtok(NULL, SEP);
  panim->ext.animator.speed = (float) atof(w);
  w = strtok(NULL, SEP);
  strcpy(str, w);
  createNetObjectFromString(&(panim->noh), str, PERMANENT);
  w = strtok(NULL, SEP);
  panim->soh = SolidParser(w);  
  if (panim->ext.animator.named)
    setWObjectName(panim, panim->ext.animator.name);
}

Private
void animatorCreate(WObject *panim)
{
  panim->changeflag = FALSE;
  updateObjectIn3D(panim);
  setOptionalBuffer(panim);
  updateBB(panim);
  mobilelist = addObjectToList(panim, mobilelist);
  insertObjectIntoGrid(panim);
}

/* animator creation from the network */
Private
void createAnimatorFromNetwork(WObject *panim, Payload *ppl)
{
  strcpy(panim->h_name, ANIMATORNAME);
  animatorCreate(panim);
  setAllProperties((NetObject *) panim, ppl);
  panim->ext.animator.state = 0;
} 

/* animator creation from a file */
Private
void createAnimatorFromFile(Fileline l)
{
  WObject *panim;

  panim = (WObject*) malloc(sizeof(WObject));
  memset(panim, 0, sizeof(WObject));    
  panim->noh.type = ANIMATORTYPE;
  strcpy(panim->h_name, ANIMATORNAME);
  animatorParser(l, panim);
  animatorCreate(panim);
} 

/* animator update to the network */
Private
int updateAnimatorToNetwork(WObject *panim, WObject *panimold)
{
  int change = FALSE;
  
  if (panim->ext.animator.frame != panimold->ext.animator.frame) {
    declareDelta(&(panim->noh), ANIMATORPROPFRAME);
    change = TRUE;
  }
#ifdef CHANGENBFRAMES
  if (panim->ext.animator.nb_frames != panimold->ext.animator.nb_frames) {
    declareDelta(&(panim->noh), ANIMATORPROPNBFRAMES);
    change = TRUE;
  }
#endif
#ifdef CHANGEANIMSPEED
  if (panim->ext.animator.speed != panimold->ext.animator.speed) {
    declareDelta(&(panim->noh), ANIMATORPROPSPEED);
    change = TRUE;
  }
#endif
  return change;
}

Public
void animatorStart(WObject *panim, long sec, long usec)
{
  panim->ext.animator.sec = sec;
  panim->ext.animator.usec = usec;
  panim->ext.animator.state = 1;
}

Public
void animatorStop(WObject *panim, long sec, long usec)
{
  panim->ext.animator.state = 0;
}

/* object intersects: stop */
Private
void animatorIntersect(WObject *pwoh, WObject *pwohold, WObject *panim)
{
  copyPositionAndBB(pwohold, pwoh);
}

Private
int animatorChange(WObject *panim)
{
  return panim->ext.animator.state;
}

Private
void animatorUpdateTime(long sec, long usec, float *lasting, WObject *panim)
{
  *lasting = (float)(sec - panim->ext.animator.sec) +
    ((float)(usec - panim->ext.animator.usec) / MILLION);
  if (*lasting > panim->ext.animator.speed) {
    panim->ext.animator.sec = sec;
    panim->ext.animator.usec = usec;
  }
}

Private
void animatorChangePosition(float lasting, WObject *panim)
{
  if (lasting > panim->ext.animator.speed) {
    panim->ext.animator.frame =
      (panim->ext.animator.frame + 1) % panim->ext.animator.nb_frames;
    SolidSetFrame(panim->soh, panim->ext.animator.frame);
  }
}

Public
void set_frame(WObject *panim, Payload *ppl)
{
  WObject *panimold;
  
  panimold = copy_object(panim);
  scanPayload(ppl, "d", &(panim->ext.animator.frame));
  SolidSetFrame(panim->soh, panim->ext.animator.frame);
  update_object(panim, panimold);
}

Public
void get_frame(WObject *panim, Payload *ppl)
{
  writePayload(ppl, "d", panim->ext.animator.frame);
}

Public
void set_nb_frames(WObject *panim, Payload *ppl)
{
  WObject *panimold;
  
  panimold = copy_object(panim);
  scanPayload(ppl, "d", &(panim->ext.animator.nb_frames));
  update_object(panim, panimold);
}

Public
void get_nb_frames(WObject *panim, Payload *ppl)
{
  writePayload(ppl, "d", panim->ext.animator.nb_frames);
}

Public
void set_speed(WObject *panim, Payload *ppl)
{
  WObject *panimold;
  
  panimold = copy_object(panim);
  scanPayload(ppl, "f", &(panim->ext.animator.speed));
  update_object(panim, panimold);
}

Public
void get_speed(WObject *panim, Payload *ppl)
{
  writePayload(ppl, "f", panim->ext.animator.speed);
}

/* animator functions initialization */
Public
void initAnimatorFuncList(void)
{
  generalFuncList[ANIMATORTYPE].createFromFileline = createAnimatorFromFile;
  generalFuncList[ANIMATORTYPE].createFromNetwork = createAnimatorFromNetwork;  
  generalFuncList[ANIMATORTYPE].change = animatorChange;
  generalFuncList[ANIMATORTYPE].updateTime = animatorUpdateTime;
  generalFuncList[ANIMATORTYPE].changePosition = animatorChangePosition;
  generalFuncList[ANIMATORTYPE].updateToNetwork = updateAnimatorToNetwork;
  generalFuncList[ANIMATORTYPE].whenIntersect = animatorIntersect;

  propertiesnumber[ANIMATORTYPE] = ANIMATORPROPERTIES;

  setFuncList[ANIMATORPROPFRAME][ANIMATORTYPE].pf = set_frame;
  getFuncList[ANIMATORPROPFRAME][ANIMATORTYPE].pf = get_frame;
  setFuncList[ANIMATORPROPNBFRAMES][ANIMATORTYPE].pf = set_nb_frames;
  getFuncList[ANIMATORPROPNBFRAMES][ANIMATORTYPE].pf = get_nb_frames;
  setFuncList[ANIMATORPROPSPEED][ANIMATORTYPE].pf = set_speed;
  getFuncList[ANIMATORPROPSPEED][ANIMATORTYPE].pf = get_speed;

  strcpy(generalMethodList[0][ANIMATORTYPE].name, "Start");
  generalMethodList[0][ANIMATORTYPE].method = animatorStart;
  strcpy(generalMethodList[1][ANIMATORTYPE].name, "Stop");
  generalMethodList[1][ANIMATORTYPE].method = animatorStop;

  defmaxlasting[ANIMATORTYPE] = ANIMATORDEFMAXLAST;
}
