#include "global.h"
#include "parse.h"
#include "browsers.h"


/* web parser */
Private
void webParser(char *l, WObject *pweb)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pweb);
  strcpy(pweb->ext.host.url, w); w = strtok(NULL, SEP);
  pweb->soh = SolidParser(w);
}

/* create from a fileline */
Private
void createWebFromFile(Fileline l)
{
  WObject *pweb;

  pweb = (WObject*) malloc(sizeof(WObject));
  memset(pweb, 0, sizeof(WObject));    
  pweb->noh.type = WEBTYPE;
  webParser(l, pweb);
  strcpy(pweb->h_name, WEBNAME);

  updateObjectIn3D(pweb);
  setOptionalBuffer(pweb);
  updateBB(pweb);
  stilllist = addObjectToList(pweb, stilllist);
  insertObjectIntoGrid(pweb);
} 

/* object intersects: stop */
Private
void webIntersect(WObject *pwoh, WObject *pwohold, WObject *pweb)
{
#define GOTHROUGH
#ifdef GOTHROUGH
  pwoh->x += 0.01;
  pwoh->y += 0.01;
  updateObjectIn3D(pwoh);
  updateBB(pwoh);
#else
  copyPositionAndBB(pwohold, pwoh);
#endif
}

/* browser */
Private
void webMethode0(WObject *pweb, long sec, long usec)
{
#ifdef WITHNETSCAPE
  static char url[URL_LEN];

  strncpy(url, pweb->ext.host.url, sizeof(url));
  trace(DBG_TOOL, "Wmgt: browser on %s", url);
  /* quitbrowser(); */
  startbrowser(url);
#endif
}

/* functions initialisztion */
Public
void initWebFuncList(void)
{
  generalFuncList[WEBTYPE].createFromFileline = createWebFromFile;
  generalFuncList[WEBTYPE].whenIntersect = webIntersect;
  
  propertiesnumber[WEBTYPE] = 0;

  strcpy(generalMethodList[0][WEBTYPE].name, "open");
  generalMethodList[0][WEBTYPE].method = webMethode0;
}
