/* GiMd2Viewer - Quake2 model viewer
 * Copyright (C) 1998  Lionel ULMER <bbrox@mygale.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "global.h"
#include "mmedia.h"


typedef unsigned char byte;

typedef struct {
  byte Manufacturer;
  byte Version;
  byte Encoding;
  byte BitsPerPixel;
  byte Xmin_l; byte Xmin_h;
  byte Ymin_l; byte Ymin_h;
  byte Xmax_l; byte Xmax_h;
  byte Ymax_l; byte Ymax_h;
  byte HDPI_l; byte HDPI_h;
  byte VDPI_l; byte VDPI_h;
  byte Colormap[48];
  byte Reserved;
  byte NPlanes;
  byte BytesPerLine_l; byte BytesPerLine_h;
  byte PaletteInfo_l; byte PaletteInfo_h;
  byte HScreenSize_l; byte HScreeSize_h;
  byte VScreenSize_l; byte VScreeSize_h;
  byte Filler[54];
} Pcx;

typedef struct {
  byte r;
  byte g;
  byte b;
} Color;

#define TO_SHORT(h, a) (h. ## a ## _l | (h. ## a ## _h << 8))

static byte buffer[512];
static int buf_pos = 0;
static int buf_len = 0;

static inline
byte http_getc(void *th, MM_ReadFunc read_func)
{
  if (buf_pos >= buf_len) {
    buf_len = read_func(th, buffer, 512);
    buf_pos = 0;
  }
  return buffer[buf_pos++];
}

MM_Image *MM_loadPCX(void *th, MM_ReadFunc read_func,
		     MM_DisplayImageFunc display_func)
{
  Pcx pcxheader;
  unsigned short Xsize, Ysize, BPL;
  byte *ret, *tmp, *tmp2;
  Color palette[256];
  int i, y, x;
  MM_Image *image;
  
  /* Fool proofing */
  if (th == NULL)
    return NULL;
  
  /* Loads the header */
  read_func(th, (char *) &pcxheader, sizeof(pcxheader));

  /* Test if this is really a PCX file */
  if (pcxheader.Manufacturer != 0x0A)
    return NULL;
  /* Only decode one type of PCX */
  if ((pcxheader.Version != 0x05) || (pcxheader.BitsPerPixel != 8) ||
      (pcxheader.NPlanes != 0x01))
    return NULL;
  
  /* Gets the image dimentions */
  Xsize = (TO_SHORT(pcxheader, Xmax) - TO_SHORT(pcxheader, Xmin)) + 1;
  Ysize = (TO_SHORT(pcxheader, Ymax) - TO_SHORT(pcxheader, Ymin)) + 1;

  BPL = TO_SHORT(pcxheader, BytesPerLine);
  
  /* Temporary indexed buffer */
  ret = (char *) malloc(Xsize * Ysize);
  
  /* Start decoding the file */
  tmp = ret;
  for (y = 0; y < Ysize; y++) {
    int count = 0;
    byte data = 0x00;
    
    /* Decodes one line */
    x = 0;
    while (x < BPL) {
      if (count > 0) {
	if (x < Xsize)
	  *(tmp++) = data;
	x++;
	count--;
      } else {
	data = http_getc(th, read_func);
	if ((data & 0xC0) == 0xC0) {
	  count = data & 0x3F;
	  data = http_getc(th, read_func);
	} else {
	  count = 1;
	}
      }
    }
  }

  /* Decodes the palette */
  if (http_getc(th, read_func) != 0x0C) {
    free(ret);
    return NULL;
  }
  for (i = 0; i < 256; i++) {
    palette[i].r = http_getc(th, read_func);
    palette[i].g = http_getc(th, read_func);
    palette[i].b = http_getc(th, read_func);
  }

  /* Allocates memory */
  image = (MM_Image *) malloc(sizeof(MM_Image));
  image->xsize = Xsize;
  image->ysize = Ysize;
  image->format = MM_IMAGE_RGB;
  image->pixmap = (char *) malloc(3 * Xsize * Ysize);
  
  /* Converts the indexed buffer to RGB */
  tmp = ret;
  tmp2 = image->pixmap;
  for (x = 0; x < Xsize * Ysize; x++) {
    *(tmp2++) = palette[*tmp].r;
    *(tmp2++) = palette[*tmp].g;
    *(tmp2++) = palette[*tmp].b;
    tmp++;
  }
  free(ret);
  
  display_func(th, image);
  return image;
}
