/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  AFfiles.h

Description:
  Function prototypes for the TSP library AF file internal routines

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.14 $  $Date: 1998/06/26 20:41:09 $

----------------------------------------------------------------------*/

#ifndef AFfile_h_
#define AFfile_h_

#include <stdio.h>	/* typedef for FILE */
#include <setjmp.h>	/* typedef for jmp_buf */

#ifdef __STDC__
#  define p_(params)	params
#else
#  define const				/* Define const for K&R C */
#  define p_(params)	()
#endif

struct AF_opt;				/* Audio file routine options */
struct AF_NHpar;			/* Headerless audio file parameters */
struct AF_info;				/* Header information string */

#ifndef	AFILE_t_
#  define AFILE_t_
typedef struct AF_filepar AFILE;	/* Audio file parameters */
#endif

/* Header read/write definitions */
#define RHEAD_S(fp,string) \
	AFreadHead (fp, (void *)(string), 1, (int) (sizeof (string)), \
		    DS_NATIVE)
#define RHEAD_SN(fp,string,N) \
	AFreadHead (fp, (void *) (string), 1, (int) (N), DS_NATIVE)
#define RHEAD_V(fp,value,swap) \
	AFreadHead (fp, (void *) &(value), (int) (sizeof (value)), 1, \
		    (int) (swap))
#define RSKIP(fp,nbytes) \
	AFreadHead (fp, NULL, 1, (int) (nbytes), DS_NATIVE)
#define WHEAD_S(fp,string) \
	AFwriteHead (fp, (const void *) (string), 1, (int) (sizeof (string)), \
		     DS_NATIVE)
#define WHEAD_SN(fp,string,N) \
	AFwriteHead (fp, (const void *) (string), 1, (int) (N), DS_NATIVE)
#define WHEAD_P(fp,string) \
	AFwriteHead (fp, (const void *) (string), 1, (int) (strlen (string)), \
		     DS_NATIVE)
#define WHEAD_V(fp,value,swap) \
	AFwriteHead (fp, (const void *) &(value), (int) (sizeof (value)), 1, \
		     (int) (swap))

#ifdef __cplusplus
extern "C" {
#endif

int
AFfindType p_((FILE *fp));
struct AF_info *
AFgenHinfo p_((double Sfreq));
char *
AFgetHrec p_((const char name[], const struct AF_info *Hinfo));
int
AFgetSPrec p_((const char name[], int type, void *data, int erropt,
	       const char head[], int N));
struct AF_opt *
AFoptions p_((void));
void
AFprAFpar p_((AFILE *AFp, const char Fname[], FILE *fpinfo));
AFILE *
AFrdAIhead p_((FILE *fp));
AFILE *
AFrdAUhead p_((FILE *fp));
AFILE *
AFrdBLhead p_((FILE *fp));
AFILE *
AFrdEShead p_((FILE *fp));
int
AFrdHinfo p_((FILE *fp, int Size, struct AF_info *Hinfo, int Align));
int
AFrdHtext p_((FILE *fp, int Size, const char Ident[], struct AF_info *Hinfo,
	      int Align));
AFILE *
AFrdINhead p_((FILE *fp));
AFILE *
AFrdSFhead p_((FILE *fp));
AFILE *
AFrdSPhead p_((FILE *fp));
AFILE *
AFrdSWhead p_((FILE *fp));
AFILE *
AFrdTAhead p_((FILE *fp));
AFILE *
AFrdWVhead p_((FILE *fp));
int
AFreadHead p_((FILE *fp, void *Buf, int size, int Nelem, int Swapb));
void
AFresHinfo p_((void));
AFILE *
AFsetNHread p_((FILE *fp, const char Fname[]));
AFILE *
AFsetRead p_((FILE *fp, int Ftype, int Format, int Swapb, double Sfreq,
	      double ScaleF, long int Nchan, long int Ldata, long int Nsamp,
	      const struct AF_info *Hinfo, int Fix));
AFILE *
AFsetWrite p_((FILE *fp, int Ftype, int Format, int Swapb, double Sfreq,
	       double ScaleF, long int Nchan));
AFILE *
AFsetNHwrite p_((FILE *fp, int Ftype, int Dformat, long int Nchan,
		 double Sfreq));
int
AFupdAIhead p_((AFILE *AFp));
int
AFupdAUhead p_((AFILE *AFp));
int
AFupdHead p_((AFILE *AFp));
int
AFupdWVhead p_((AFILE *AFp));
AFILE *
AFwrAIhead p_((FILE *fp, int Format, long int Nframe, long int Nchan,
	       double Sfreq));
AFILE *
AFwrAUhead p_((FILE *fp, int Format, long int Nframe, long int Nchan,
	       double Sfreq));
AFILE *
AFwrWVhead p_((FILE *fp, int Format, long int Nframe, long int Nchan,
	       double Sfreq));
int
AFwriteHead p_((FILE *fp, const void *Buf, int Size, int Nv, int Swapb));

#ifdef __cplusplus
}
#endif

#endif /* AFfile_h_ */
