/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void VRfAmpldB (const float ampl[], float dB[], int N)

Purpose:
  Convert each value in an array of amplitudes to a decibel value

Description:
  This routine converts the elements of an array of amplitudes to decibels.
    dB[i] = 20 * log10(ampl[i]),  0 <= i < N.
  The value ampl[i] must be non-negative.

Parameters:
   -> const float ampl[]
      Input amplitude array (N elements).  This values must be non-negative.
  <-  float y[]
      Output array of decibel values (N elements).  The output array can be the
      same as the input array.
   -> int N
      Number of elements in the arrays (may be zero)

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.6 $  $Date: 1997/10/11 02:21:08 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfAmpldB.c 1.6 1997/10/11 libtsp-v3r0 $";

#include <math.h>

#include <libtsp.h>
#include <libtsp/VRmsg.h>


void
VRfAmpldB (ampl, dB, N)

     const float ampl[];
     float dB[];
     int N;

{
  int i;

  for (i = 0; i < N; ++i) {
    if (ampl[i] >= 0)
      dB[i] = 20.0 * log10 (ampl[i]);
    else
      UThalt ("VRfAmpldB: %s", VRM_NegAmpl);
  }

  return;
}
