/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  double VRfMax (const float x[], int N)

Purpose:
  Return the maximum value in a float array

Description:
  This routine findss the maximum of the values in a float array.

Parameters:
  <-  double VRfMax
      Maximum of the values in x
   -> const float x[]
      Input array (N elements)
   -> int N
      Number of elements in the array (must be greater than zero)

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.4 $  $Date: 1997/10/11 02:16:52 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfMax.c 1.4 1997/10/11 libtsp-v3r0 $";

#include <libtsp.h>
#include <libtsp/VRmsg.h>


double
VRfMax (x, N)

     const float x[];
     int N;

{
  int i;
  float xmax;

  if (N <= 0)
    UThalt ("VRfMax: %s", VRM_BadN);

  xmax = x[0];
  for (i = 1; i < N; ++i) {
    if (x[i] > xmax)
      xmax = x[i];
  }

  return (double) xmax;
}
