/************************************************************************
 *	bregex -- The `Better/BuGless/Berg' Regular Expression library	*
 *									*
 *	This package contains a regular expression library based on	*
 *	the POSIX interface.  It has been written in ANSI and K&R	*
 *	conforming C.							*
 *	The library is fully POSIX compliant except for the following:	*
 *		- regexec() can not be called concurrently on the same	*
 *		  compiled regex_t struct (use regcopy() instead).	*
 *		- Bracket expressions currently do not support:		*
 *			Collating symbols [. .]				*
 *			Equivalence class expressions [= =]		*
 *		- Basic regular expressions do not allow backreference	*
 *		  expressions in the search pattern.			*
 *									*
 *	Copyright (c) 1991-1996, by S.R. van den Berg, The Netherlands	*
 *									*
 *	You are allowed to use this library or any work derived		*
 *	thereof in any non-commercial package as long as you give	*
 *	me credit somewhere within this package.  When in doubt,	*
 *	contact me for an agreement.					*
 *									*
 *	I can be reached on the Internet under the following addresses: *
 *			<srb@cuci.nl>					*
 *			<berg@pool.informatik.rwth-aachen.de>		*
 ************************************************************************/
#ifndef BREGEX_H_
#define BREGEX_H_
/*$Id*/
/*
 * The following defines can be uncommented in any combination you see fit.
 * The default configuration (none of them defined) will be POSIX conforming
 * (exceptions noted above).  Uncommenting one or the other will cause the
 * regular expression library to change in compiled code size and speed.
 *
 * The following legenda applies:
 *	+	noticable increase
 *	-	noticable decrease
 *	.	no noticable change
 *	?	change will depend on C-compiler/C-library
 *
 * The columns correspond to the following characteristics:
 *	bregex.o size, regcomp() speed, heap+stack size, regexec() speed.
 */

/*#define RE_pNOSUB		-+-+		        permanent REG_NOSUB */
#define RE_pNOSUB
/*#define RE_pNEWLINE		-.-.		      permanent REG_NEWLINE */
#define RE_pNEWLINE
/*#define RE_nNEWLINE		-.-+	         permanently no REG_NEWLINE */
/*#define RE_pEXTENDED		-...		     permanent REG_EXTENDED */
#define RE_pEXTENDED
/*#define RE_nEXTENDED		-...	        permanently no REG_EXTENDED */
/*#define RE_WILDCARDS		+...		      allow shell wildcards */
/*#define RE_nICASE		-+.+		        case sensitive only */
/*#define RE_HEX_CHAR		+...   \x41 \x0a etc. will be recognised */
/*#define RE_OCT_CHAR		+...	    \11 \12 etc. will be recognised */
/*#define RE_NULL_CHAR		+...		      \0 will be recognised */
/*#define RE_SPEC_CHAR		+...	      \n \t etc. will be recognised */
#define RE_SPEC_CHAR
/*#define RE_EXEC_ERROR		+..-   erroneous regexps can be executed */
/*#define RE_COMMON_SUBXP	?.??    your C-optimiser had better be good */
/*#define RE_COPY		+...	        regcopy() will be available */
/*#define RE_STRLEN		-..+   you supply the strlen of the text */
#define RE_STRLEN
	      /* advantages: embedded \0 characters allowed, increased speed */
/*#define RE_MEMCHR		...?	         use memchr(), not relevant */
						/* when RE_STRLEN is defined */
/*#define RE_nCTYPE		?...	    do not use the <ctype.h> macros */
/*#define RE_nCHAR_CLASS	-...    character classes are not supported */
/*#define RE_nCASE_TABLE	-..-	         do not use two case tables */
/*#define RE_nJUMP_TABLE	-+--	   do not create a jumptable */
/*#define RE_SMALL_JUMP_TABLE	?.-?		    use a smaller jumptable */
/*#define RE_NSUBMAX		...+		   support REG_NSUBMAX flag */
/*#define RE_SUBSTR_PTR		-..+	   regmatch_t will contain pointers */
/*#define RE_nBRACES		-+..   e.g. a{3,5} will not be supported */
/*#define RE_nERROR_DETECT	-+..     regexp errors are silently `fixed' */
/*#define RE_nERROR_REPORT	-...	   regerror() will not be available */
/*#define RE_nCONCUR_COMPILE	-+-.	    regcomp() will be non-reentrant */
/*#define RE_nREUSABLE		-..+     only one execution/compiled regexp */
/*#define RE_EMPTY_OR		+...   empty or branches behave as expected */
/*#define RE_SURE_MINIMAL	-+..    regexps are expected to be in their */
			 /* minimal form, if they aren't, hangups can result */
/*#define RE_DUMB_ANCHOR	-+..    unquoted ^ and $ are always special */
				  /* crashes might result if used improperly */
/*
 * You can define RE_ABORT_EXPR to some expression that will be evaluated
 * in the main search loop of regexec() (once for every character in the input
 * stream).  As soon as it evaluates to true, regexec() will abort the search.
 *	Optimisations:		+..-
 */

/*#define P(args) args		    you can uncomment this if your compiler */
						       /* understands ANSI C */
#ifdef RE_CONF			  /* define RE_CONF to make bregex.h include */
#include RE_CONF			 /* your personal configuration file */
#endif
#ifdef RE_BREGEX_CONF		  /* define RE_CONF to make bregex.h include */
#include "bregex.conf"		   /* your other personal configuration file */
#endif

/**************************************************
 * All configurable options are *above* this line *
 **************************************************/

#ifndef P
#define P(args) ()
#define RE_P
#ifndef const
#define const
#define RE_const
#endif
#endif

#define REG_EXTENDED	1		 /* use extended regular expressions */
#define REG_WILDCARDS	(REG_mWILDCARDS|REG_EXTENDED) /* use shell wildcards */
#define REG_ICASE	2			     /* ignore case in match */
#define REG_NOSUB	4	/* equivalent to REG_NSUBMAX with re_nsub==0 */
#define REG_NEWLINE	8	      /* a dot and a class will not match \n */
#define REG_NOTBOL	16		 /* do not match ^ at the very start */
#define REG_NOTEOL	32		   /* do not match $ at the very end */

#define REG_LOWMEM	64	 /* regexec() will save memory and be slower */
#define REG_NSUBMAX	128		     /* regcomp() will check re_nsub */
#define REG_NOOFFSET	256	   /* regerror() will not display the offset */

#define REG_mWILDCARDS	512				  /* used internally */
#define REG_SIMPLE	1024				  /* used internally */
#define REG_ERROR	2048				  /* used internally */
#define REG_OUTOFMEM	4096				  /* used internally */

#define REG_NOMATCH	1				  /* Failed to match */
#define REG_BADPAT	2		       /* Invalid regular expression */
#define REG_ECOLLATE	3			/* Invalid collating element */
#define REG_ECTYPE	4		     /* Invalid character class type */
#define REG_EESCAPE	5				       /* Trailing \ */
#define REG_ESUBREG	6			 /* Number in \digit invalid */
#define REG_EBRACK	7				    /* [ ] imbalance */
#define REG_EPAREN	8				    /* ( ) imbalance */
#define REG_EBRACE	9				    /* { } imbalance */
#define REG_BADBR	10			   /* Content of { } invalid */
#define REG_ERANGE	11	     /* Invalid endpoint in range expression */
#define REG_ESPACE	12				    /* Out of memory */
#define REG_BADRPT	13	     /* Inappropriate use of magic character */

#define REG_ABORT	14				   /* Search aborted */

#define C_BACKREF	'g'		      /* \g designate backreferences */

#ifndef RE_SUBSTR_PTR
typedef int regoff_t;
typedef struct
{ union
   { regoff_t	rm_o;
     char*	rm_p;
   }		rm_ss,rm_es;
} regmatch_t;

#define rm_so	rm_ss.rm_o
#define rm_eo	rm_es.rm_o
#define rm_sp	rm_ss.rm_p
#define rm_ep	rm_es.rm_p
#else

typedef char*regptr_t;
typedef struct
{ char		*rm_sp,*rm_ep;
} regmatch_t;
#endif /* RE_SUBSTR_PTR */

typedef struct
{ size_t	re_nsub;
  unsigned	re_flags;
#ifndef RE_nJUMP_TABLE
  unsigned	re_maxjump;
#endif
  void*		re_compiled;
  void*		re_finpoint;
  union
   { size_t	re_error;
     void*	re_stack;
   }		re_es;
} regex_t;

#define re_erroffset	re_es.re_error		 /* can be used to determine */
				   /* the offset at which the error occurred */
#define regcomp		bregcomp	   /* use defines to prevent clashes */
#define regexec		bregexec		 /* with an existing library */
#define regfree		bregfree
#define regerror	bregerror

int
 regcomp P((regex_t*const preg,const char*const pattern,int cflags)),
#ifdef RE_STRLEN
 regexec P((/*const*/regex_t*preg,const char*const string,size_t length,
  size_t nmatch,regmatch_t pmatch[],int eflags));
#else
 regexec P((/*const*/regex_t*preg,const char*const string,size_t nmatch,
  regmatch_t pmatch[],int eflags));
#endif
#ifdef RE_COPY
int
 regcopy P((regex_t*const dest,const regex_t*const src));
#endif
#ifndef RE_nERROR_REPORT
size_t
 regerror P((const errcode,const regex_t*const preg,char*const errbuf,
  size_t errbuf_size));
#endif
void
 regfree P((regex_t*rg));

#ifndef reg_malloc
extern void
 *(*reg_malloc)P((size_t size)),
 *(*reg_realloc)P((void*ptr,size_t size)),
 (*reg_free)P((void*ptr));
#endif

#ifndef BREGEX_C_
#ifdef RE_P
#undef P
#endif
#ifdef RE_const
#undef const
#endif
#endif /* BREGEX_C_ */

#include "bregex.ext"

#endif /* BREGEX_H_ */
