/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import java.text.MessageFormat;
import netscape.security.AppletSecurity;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.softupdate.FolderSpec;
import netscape.softupdate.InstallObject;
import netscape.softupdate.SoftUpdateException;
import netscape.softupdate.SoftwareUpdate;
import netscape.softupdate.Strings;
import netscape.softupdate.VersionInfo;
import netscape.softupdate.VersionRegistry;

final class InstallFile
extends InstallObject {
    private String vrName;
    private VersionInfo versionInfo;
    private String jarLocation;
    private String tempFile = null;
    private String finalFile;
    private String regPackageName;
    private String userPackageName;
    private Target target;
    private boolean force;
    private boolean bJavaDir;
    private boolean replace = false;
    private boolean bChild = false;
    private boolean bUpgrade = false;

    InstallFile(SoftwareUpdate softwareUpdate, String string, VersionInfo versionInfo, String string2, FolderSpec folderSpec, String string3, boolean bl) throws SoftUpdateException {
        super(softwareUpdate);
        this.vrName = string;
        this.versionInfo = versionInfo;
        this.jarLocation = string2;
        this.force = bl;
        this.finalFile = folderSpec.MakeFullPath(string3);
        this.bJavaDir = folderSpec.IsJavaCapable();
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        privilegeManager.enablePrivilege(target);
        this.target = Target.findTarget("SoftwareInstall");
        privilegeManager.enablePrivilege(this.target, this.softUpdate.GetPrincipal());
        this.userPackageName = softwareUpdate.GetUserPackageName();
        this.regPackageName = softwareUpdate.GetRegPackageName();
        this.bChild = this.regPackageName.length() == 0 ? this.vrName.charAt(0) != '/' : this.vrName.startsWith(this.regPackageName);
        this.replace = this.NativeDoesFileExist(this.finalFile);
    }

    protected void Prepare() throws SoftUpdateException {
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        privilegeManager.enablePrivilege(target);
        privilegeManager.enablePrivilege(this.target, this.softUpdate.GetPrincipal());
        this.tempFile = this.softUpdate.ExtractJARFile(this.jarLocation, this.finalFile);
    }

    protected void Complete() throws SoftUpdateException {
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        privilegeManager.enablePrivilege(target);
        privilegeManager.enablePrivilege(this.target, this.softUpdate.GetPrincipal());
        int n = this.NativeComplete();
        privilegeManager.revertPrivilege(this.target);
        if (this.bJavaDir && !this.replace && (this.finalFile.toLowerCase().endsWith(".zip") || this.finalFile.toLowerCase().endsWith(".jar"))) {
            this.AddToClasspath(this.finalFile);
        }
        if (n == 0 || n == 999) {
            int n2;
            this.bUpgrade = !this.bChild ? (n2 = VersionRegistry.uninstallFileExists(this.regPackageName, this.vrName)) == 0 : VersionRegistry.inRegistry(this.vrName) == 0;
            Integer n3 = VersionRegistry.getRefCount(this.vrName);
            if (!this.bUpgrade) {
                if (n3 != null) {
                    int n4 = 1 + n3;
                    VersionRegistry.installComponent(this.vrName, this.finalFile, this.versionInfo, n4);
                } else if (this.replace) {
                    VersionRegistry.installComponent(this.vrName, this.finalFile, this.versionInfo, 2);
                } else {
                    VersionRegistry.installComponent(this.vrName, this.finalFile, this.versionInfo, 1);
                }
            } else if (this.bUpgrade) {
                if (n3 == null) {
                    VersionRegistry.installComponent(this.vrName, this.finalFile, this.versionInfo, 1);
                } else {
                    VersionRegistry.installComponent(this.vrName, this.finalFile, this.versionInfo);
                }
            }
            if (!this.bChild && !this.bUpgrade) {
                VersionRegistry.uninstallAddFile(this.regPackageName, this.vrName);
            }
        }
        if (n == 999) {
            throw new SoftUpdateException(this.finalFile, n);
        }
        if (n != 0) {
            Object[] objectArray = new Object[]{this.finalFile};
            throw new SoftUpdateException(MessageFormat.format(Strings.error_InstallFileUnexpected(), objectArray), n);
        }
    }

    protected void Abort() {
        this.NativeAbort();
    }

    private native void NativeAbort();

    private native int NativeComplete();

    private native void AddToClasspath(String var1);

    public String toString() {
        Object[] objectArray = new Object[]{this.finalFile};
        if (this.replace) {
            return MessageFormat.format(Strings.details_ReplaceFile(), objectArray);
        }
        return MessageFormat.format(Strings.details_InstallFile(), objectArray);
    }

    protected boolean CanUninstall() {
        return true;
    }

    protected boolean RegisterPackageNode() {
        return true;
    }
}

