// -*- C++ -*-
#ifndef SYMGEN_H
#define SYMGEN_H

#include "config.h"

#include <stdio.h>

#include "lyxlex.h"

class CharacterStream {
private:
        //ifstream progFile;
	FILE *progFile;
        int currentChar;
	int commentChar;
public:
	CharacterStream(){
		progFile = NULL;
		currentChar = EOF;
		commentChar = 0;
	}
	
        int lineNumber;
	void setCommentChar(int c){commentChar = c;}
	
        int Current(){ return currentChar;}
        void stepChar(){ char c; c = next();}
        char* currentLine(){
                // return a line from progfile
                return "hei";
        }

        void inFileName(const char* Filename){
                //progFile.open(Filename);
		progFile = fopen(Filename,"r");
        }
        void getReady(){ stepChar();}
        void terminate(){
		//progFile.close();
		if (progFile) fclose(progFile);
	}
private:
        int next();
        void newLine();
        void writeLine(
		//ofstream Outfile
		FILE *outFile
		);
        bool endOfFile(){
                //if (progFile.peek()==EOF) return true;
                //else return false;
		int c;
		if ((c=getc(progFile))==EOF) return true;
		else {
			ungetc(c,progFile);
			return false;
		}
        }
};

class InfoReceiver {
public:
        virtual void symbolRead(char* /*tx*/){
        }
        virtual void Error(char* tx){
                //cerr << "*** Error: " << tx << endl;
		fprintf(stderr,"*** Error: %s\n",tx);
        }
};

class SymbolGenerator {
protected:
        CharacterStream* charStream;
        char* thisSymbol;
        InfoReceiver* infoRec;
public:
        void inFileName(const char* Filename)
        {
                charStream = new CharacterStream;
                charStream->inFileName(Filename);
        }
	
        void setInfoReceiver(InfoReceiver *ir)
        {
                infoRec = ir;
        }
	
        void getReady()
        {
                charStream->getReady();
                stepSymbol();
        }
	
        void terminate()
        {
                charStream->terminate();
        }
	
        char* currentSymbol()
        {
                return thisSymbol;
        }
        
        void stepSymbol(void);
        bool currentIs(char* tx);
        int lineNumber();
        char* currentLine();
        bool currentIsInteger();
        int currentAsInteger();
        bool currentIsName();
        bool currentIsKeyword();
        bool currentIsVariableName();

        // error reporting
        void errorInLine(char* tx);

        // exercise funcs
        bool currentIsFloat();
        float currentAsFloat();

        void reportError(char* tx);
        char* nextString();
        char* nextConstant();
        char* nextOperation();
};

extern void readline(FILE*, char*);
extern char* NextToken();
extern char* NextLongToken();
extern int NextQStringToken(char *input, char *buf);
extern int NextStringToken(char* command, const char* string[]);
extern int FindStringToken(LyXLexClass*, char* command, const char* string[]);
extern int NextIntToken();
extern float NextFloatToken();
extern char *next_token(FILE *file);
extern char *next_token_line(FILE *file);
#endif
